/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input.stream.state;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.query.input.stream.state.PreStateProcessor;
import io.siddhi.core.query.input.stream.state.StreamPreStateProcessor;
import io.siddhi.query.api.execution.query.input.state.LogicalStateElement;
import io.siddhi.query.api.execution.query.input.stream.StateInputStream;
import java.util.Iterator;

public class LogicalPreStateProcessor
extends StreamPreStateProcessor {
    protected LogicalStateElement.Type logicalType;
    protected LogicalPreStateProcessor partnerStatePreProcessor;

    public LogicalPreStateProcessor(LogicalStateElement.Type type, StateInputStream.Type stateType) {
        super(stateType);
        this.logicalType = type;
    }

    @Override
    public PreStateProcessor cloneProcessor(String key) {
        LogicalPreStateProcessor logicalPreStateProcessor = new LogicalPreStateProcessor(this.logicalType, this.stateType);
        this.cloneProperties(logicalPreStateProcessor, key);
        logicalPreStateProcessor.init(this.siddhiQueryContext);
        return logicalPreStateProcessor;
    }

    @Override
    public void addState(StateEvent stateEvent) {
        this.lock.lock();
        try {
            if (this.isStartState || this.stateType == StateInputStream.Type.SEQUENCE) {
                if (this.newAndEveryStateEventList.isEmpty()) {
                    this.newAndEveryStateEventList.add(stateEvent);
                }
                if (this.partnerStatePreProcessor != null && this.partnerStatePreProcessor.newAndEveryStateEventList.isEmpty()) {
                    this.partnerStatePreProcessor.newAndEveryStateEventList.add(stateEvent);
                }
            } else {
                this.newAndEveryStateEventList.add(stateEvent);
                if (this.partnerStatePreProcessor != null) {
                    this.partnerStatePreProcessor.newAndEveryStateEventList.add(stateEvent);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addEveryState(StateEvent stateEvent) {
        StateEvent clonedEvent = this.stateEventCloner.copyStateEvent(stateEvent);
        clonedEvent.setEvent(this.stateId, null);
        this.lock.lock();
        try {
            this.newAndEveryStateEventList.add(clonedEvent);
            if (this.partnerStatePreProcessor != null) {
                clonedEvent.setEvent(this.partnerStatePreProcessor.stateId, null);
                this.partnerStatePreProcessor.newAndEveryStateEventList.add(clonedEvent);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resetState() {
        this.lock.lock();
        try {
            if (this.logicalType == LogicalStateElement.Type.OR || this.pendingStateEventList.size() == this.partnerStatePreProcessor.pendingStateEventList.size()) {
                this.pendingStateEventList.clear();
                this.partnerStatePreProcessor.pendingStateEventList.clear();
                if (this.isStartState && this.newAndEveryStateEventList.isEmpty()) {
                    if (this.stateType == StateInputStream.Type.SEQUENCE && this.thisStatePostProcessor.nextEveryStatePreProcessor == null && !((StreamPreStateProcessor)this.thisStatePostProcessor.nextStatePreProcessor).pendingStateEventList.isEmpty()) {
                        return;
                    }
                    this.init();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void updateState() {
        this.lock.lock();
        try {
            this.pendingStateEventList.addAll(this.newAndEveryStateEventList);
            this.newAndEveryStateEventList.clear();
            this.partnerStatePreProcessor.pendingStateEventList.addAll(this.partnerStatePreProcessor.newAndEveryStateEventList);
            this.partnerStatePreProcessor.newAndEveryStateEventList.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexEventChunk<StateEvent> processAndReturn(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<StateEvent> returnEventChunk = new ComplexEventChunk<StateEvent>(false);
        complexEventChunk.reset();
        StreamEvent streamEvent = (StreamEvent)complexEventChunk.next();
        this.lock.lock();
        try {
            Iterator iterator = this.pendingStateEventList.iterator();
            while (iterator.hasNext()) {
                StateEvent stateEvent = (StateEvent)iterator.next();
                if (this.isExpired(stateEvent, streamEvent.getTimestamp())) {
                    iterator.remove();
                    if (this.withinEveryPreStateProcessor == null) continue;
                    this.withinEveryPreStateProcessor.addEveryState(stateEvent);
                    this.withinEveryPreStateProcessor.updateState();
                    continue;
                }
                if (this.logicalType == LogicalStateElement.Type.OR && stateEvent.getStreamEvent(this.partnerStatePreProcessor.getStateId()) != null) {
                    iterator.remove();
                    continue;
                }
                stateEvent.setEvent(this.stateId, this.streamEventCloner.copyStreamEvent(streamEvent));
                this.process(stateEvent);
                if (this.thisLastProcessor.isEventReturned()) {
                    this.thisLastProcessor.clearProcessedEvent();
                    returnEventChunk.add(stateEvent);
                }
                if (this.stateChanged) {
                    iterator.remove();
                    continue;
                }
                switch (this.stateType) {
                    case PATTERN: {
                        stateEvent.setEvent(this.stateId, null);
                        break;
                    }
                    case SEQUENCE: {
                        stateEvent.setEvent(this.stateId, null);
                        iterator.remove();
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return returnEventChunk;
    }

    public void setPartnerStatePreProcessor(LogicalPreStateProcessor partnerStatePreProcessor) {
        this.partnerStatePreProcessor = partnerStatePreProcessor;
        partnerStatePreProcessor.lock = this.lock;
    }
}

