/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input.stream.state;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.MetaComplexEvent;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.query.input.ProcessStreamReceiver;
import io.siddhi.core.query.input.stream.StreamRuntime;
import io.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import io.siddhi.core.query.input.stream.state.StreamPostStateProcessor;
import io.siddhi.core.query.input.stream.state.StreamPreStateProcessor;
import io.siddhi.core.query.input.stream.state.receiver.SequenceMultiProcessStreamReceiver;
import io.siddhi.core.query.input.stream.state.receiver.SequenceSingleProcessStreamReceiver;
import io.siddhi.core.query.input.stream.state.runtime.InnerStateRuntime;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.Processor;
import java.util.List;

public class StateStreamRuntime
implements StreamRuntime {
    private MetaStateEvent metaStateEvent;
    private InnerStateRuntime innerStateRuntime;
    private SiddhiQueryContext siddhiQueryContext;

    public StateStreamRuntime(SiddhiQueryContext siddhiQueryContext, MetaStateEvent metaStateEvent) {
        this.siddhiQueryContext = siddhiQueryContext;
        this.metaStateEvent = metaStateEvent;
    }

    @Override
    public List<SingleStreamRuntime> getSingleStreamRuntimes() {
        return this.innerStateRuntime.getSingleStreamRuntimeList();
    }

    @Override
    public StreamRuntime clone(String key) {
        StateStreamRuntime stateStreamRuntime = new StateStreamRuntime(this.siddhiQueryContext, this.metaStateEvent);
        stateStreamRuntime.innerStateRuntime = this.innerStateRuntime.clone(key);
        for (SingleStreamRuntime singleStreamRuntime : stateStreamRuntime.getSingleStreamRuntimes()) {
            ProcessStreamReceiver processStreamReceiver = singleStreamRuntime.getProcessStreamReceiver();
            if (processStreamReceiver instanceof SequenceMultiProcessStreamReceiver) {
                ((SequenceMultiProcessStreamReceiver)processStreamReceiver).setStateStreamRuntime(stateStreamRuntime);
                continue;
            }
            if (!(processStreamReceiver instanceof SequenceSingleProcessStreamReceiver)) continue;
            ((SequenceSingleProcessStreamReceiver)processStreamReceiver).setStateStreamRuntime(stateStreamRuntime);
        }
        ((StreamPreStateProcessor)stateStreamRuntime.innerStateRuntime.getFirstProcessor()).setThisLastProcessor((StreamPostStateProcessor)stateStreamRuntime.innerStateRuntime.getLastProcessor());
        return stateStreamRuntime;
    }

    @Override
    public void setCommonProcessor(Processor commonProcessor) {
        this.innerStateRuntime.setQuerySelector(commonProcessor);
        this.innerStateRuntime.init();
    }

    @Override
    public MetaComplexEvent getMetaComplexEvent() {
        return this.metaStateEvent;
    }

    @Override
    public ProcessingMode getProcessingMode() {
        return ProcessingMode.BATCH;
    }

    public InnerStateRuntime getInnerStateRuntime() {
        return this.innerStateRuntime;
    }

    public void setInnerStateRuntime(InnerStateRuntime innerStateRuntime) {
        this.innerStateRuntime = innerStateRuntime;
    }

    public void resetAndUpdate() {
        this.innerStateRuntime.reset();
        this.innerStateRuntime.update();
    }
}

