/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.event;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.GroupedComplexEvent;
import io.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class LastGroupByPerEventOutputRateLimiter
extends OutputRateLimiter {
    private final Integer value;
    private String id;
    private volatile int counter = 0;
    private Map<String, ComplexEvent> allGroupByKeyEvents = new LinkedHashMap<String, ComplexEvent>();

    public LastGroupByPerEventOutputRateLimiter(String id, Integer value) {
        this.id = id;
        this.value = value;
    }

    @Override
    public OutputRateLimiter clone(String key) {
        LastGroupByPerEventOutputRateLimiter instance = new LastGroupByPerEventOutputRateLimiter(this.id + key, this.value);
        instance.setLatencyTracker(this.latencyTracker);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        ArrayList outputEventChunks = new ArrayList();
        LastGroupByPerEventOutputRateLimiter lastGroupByPerEventOutputRateLimiter = this;
        synchronized (lastGroupByPerEventOutputRateLimiter) {
            while (complexEventChunk.hasNext()) {
                Object object = complexEventChunk.next();
                if (object.getType() != ComplexEvent.Type.CURRENT && object.getType() != ComplexEvent.Type.EXPIRED) continue;
                complexEventChunk.remove();
                GroupedComplexEvent groupedComplexEvent = (GroupedComplexEvent)object;
                this.allGroupByKeyEvents.put(groupedComplexEvent.getGroupKey(), groupedComplexEvent.getComplexEvent());
                if (++this.counter != this.value) continue;
                this.counter = 0;
                if (this.allGroupByKeyEvents.size() == 0) continue;
                ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>(complexEventChunk.isBatch());
                for (ComplexEvent complexEvent : this.allGroupByKeyEvents.values()) {
                    outputEventChunk.add(complexEvent);
                }
                this.allGroupByKeyEvents.clear();
                outputEventChunks.add(outputEventChunk);
            }
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        LastGroupByPerEventOutputRateLimiter lastGroupByPerEventOutputRateLimiter = this;
        synchronized (lastGroupByPerEventOutputRateLimiter) {
            state.put("Counter", this.counter);
            state.put("AllGroupByKeyEvents", this.allGroupByKeyEvents);
        }
        return state;
    }

    @Override
    public synchronized void restoreState(Map<String, Object> state) {
        this.counter = (Integer)state.get("Counter");
        this.allGroupByKeyEvents = (Map)state.get("AllGroupByKeyEvents");
    }
}

