/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.event;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LastPerEventOutputRateLimiter
extends OutputRateLimiter {
    private final Integer value;
    private String id;
    private volatile int counter = 0;

    public LastPerEventOutputRateLimiter(String id, Integer value) {
        this.id = id;
        this.value = value;
    }

    @Override
    public OutputRateLimiter clone(String key) {
        LastPerEventOutputRateLimiter instance = new LastPerEventOutputRateLimiter(this.id + key, this.value);
        instance.setLatencyTracker(this.latencyTracker);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        ArrayList outputEventChunks = new ArrayList();
        LastPerEventOutputRateLimiter lastPerEventOutputRateLimiter = this;
        synchronized (lastPerEventOutputRateLimiter) {
            while (complexEventChunk.hasNext()) {
                Object object = complexEventChunk.next();
                if (object.getType() != ComplexEvent.Type.CURRENT && object.getType() != ComplexEvent.Type.EXPIRED || ++this.counter != this.value) continue;
                complexEventChunk.remove();
                ComplexEventChunk<Object> lastPerEventChunk = new ComplexEventChunk<Object>(complexEventChunk.isBatch());
                lastPerEventChunk.add(object);
                this.counter = 0;
                outputEventChunks.add(lastPerEventChunk);
            }
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("Counter", this.counter);
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.counter = (Integer)state.get("Counter");
    }
}

