/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.snapshot;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.GroupedComplexEvent;
import io.siddhi.core.event.stream.StreamEventPool;
import io.siddhi.core.query.output.ratelimit.snapshot.SnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.WrappedSnapshotOutputRateLimiter;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.parser.SchedulerParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;

public class GroupByPerSnapshotOutputRateLimiter
extends SnapshotOutputRateLimiter {
    private final Long value;
    private String id;
    private ScheduledExecutorService scheduledExecutorService;
    private Map<String, ComplexEvent> groupByKeyEvents = new LinkedHashMap<String, ComplexEvent>();
    private Scheduler scheduler;
    private long scheduledTime;

    public GroupByPerSnapshotOutputRateLimiter(String id, Long value, ScheduledExecutorService scheduledExecutorService, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter, SiddhiQueryContext siddhiQueryContext) {
        super(wrappedSnapshotOutputRateLimiter, siddhiQueryContext);
        this.id = id;
        this.value = value;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ArrayList<ComplexEventChunk<ComplexEvent>> outputEventChunks = new ArrayList<ComplexEventChunk<ComplexEvent>>();
        complexEventChunk.reset();
        GroupByPerSnapshotOutputRateLimiter groupByPerSnapshotOutputRateLimiter = this;
        synchronized (groupByPerSnapshotOutputRateLimiter) {
            complexEventChunk.reset();
            while (complexEventChunk.hasNext()) {
                Object object = complexEventChunk.next();
                if (object.getType() == ComplexEvent.Type.TIMER) {
                    this.tryFlushEvents(outputEventChunks, (ComplexEvent)object);
                    continue;
                }
                if (object.getType() != ComplexEvent.Type.CURRENT) continue;
                complexEventChunk.remove();
                this.tryFlushEvents(outputEventChunks, (ComplexEvent)object);
                GroupedComplexEvent groupedComplexEvent = (GroupedComplexEvent)object;
                this.groupByKeyEvents.put(groupedComplexEvent.getGroupKey(), groupedComplexEvent.getComplexEvent());
            }
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    private void tryFlushEvents(List<ComplexEventChunk<ComplexEvent>> outputEventChunks, ComplexEvent event) {
        if (event.getTimestamp() >= this.scheduledTime) {
            ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>(false);
            for (ComplexEvent complexEvent : this.groupByKeyEvents.values()) {
                outputEventChunk.add(this.cloneComplexEvent(complexEvent));
            }
            outputEventChunks.add(outputEventChunk);
            this.scheduledTime += this.value.longValue();
            this.scheduler.notifyAt(this.scheduledTime);
        }
    }

    @Override
    public void start() {
        this.scheduler = SchedulerParser.parse(this, this.siddhiQueryContext.getSiddhiAppContext());
        this.scheduler.setStreamEventPool(new StreamEventPool(0, 0, 0, 5));
        this.scheduler.init(this.lockWrapper, this.siddhiQueryContext.getName());
        long currentTime = System.currentTimeMillis();
        this.scheduledTime = currentTime + this.value;
        this.scheduler.notifyAt(this.scheduledTime);
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        GroupByPerSnapshotOutputRateLimiter groupByPerSnapshotOutputRateLimiter = this;
        synchronized (groupByPerSnapshotOutputRateLimiter) {
            state.put("GroupByKeyEvents", this.groupByKeyEvents);
        }
        return state;
    }

    @Override
    public synchronized void restoreState(Map<String, Object> state) {
        this.groupByKeyEvents = (Map)state.get("groupByKeyEvents");
    }

    @Override
    public SnapshotOutputRateLimiter clone(String key, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter) {
        return new GroupByPerSnapshotOutputRateLimiter(this.id + key, this.value, this.scheduledExecutorService, wrappedSnapshotOutputRateLimiter, this.siddhiQueryContext);
    }
}

