/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.snapshot;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.GroupedComplexEvent;
import io.siddhi.core.event.stream.StreamEventPool;
import io.siddhi.core.query.output.ratelimit.snapshot.SnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.WrappedSnapshotOutputRateLimiter;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.parser.SchedulerParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;

public class WindowedPerSnapshotOutputRateLimiter
extends SnapshotOutputRateLimiter {
    private final Long value;
    private final ScheduledExecutorService scheduledExecutorService;
    private String id;
    private List<ComplexEvent> eventList;
    private Comparator comparator;
    private Scheduler scheduler;
    private long scheduledTime;

    public WindowedPerSnapshotOutputRateLimiter(String id, Long value, ScheduledExecutorService scheduledExecutorService, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter, SiddhiQueryContext siddhiQueryContext) {
        super(wrappedSnapshotOutputRateLimiter, siddhiQueryContext);
        this.id = id;
        this.value = value;
        this.scheduledExecutorService = scheduledExecutorService;
        this.eventList = new LinkedList<ComplexEvent>();
        this.comparator = new Comparator<ComplexEvent>(){

            @Override
            public int compare(ComplexEvent event1, ComplexEvent event2) {
                if (Arrays.equals(event1.getOutputData(), event2.getOutputData())) {
                    return 0;
                }
                return 1;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ArrayList<ComplexEventChunk<ComplexEvent>> outputEventChunks = new ArrayList<ComplexEventChunk<ComplexEvent>>();
        complexEventChunk.reset();
        Object object = this;
        synchronized (object) {
            block2: while (complexEventChunk.hasNext()) {
                void var4_4;
                Object object2 = complexEventChunk.next();
                if (object2 instanceof GroupedComplexEvent) {
                    ComplexEvent complexEvent = ((GroupedComplexEvent)object2).getComplexEvent();
                }
                if (var4_4.getType() == ComplexEvent.Type.TIMER) {
                    this.tryFlushEvents(outputEventChunks, (ComplexEvent)var4_4);
                    continue;
                }
                if (var4_4.getType() == ComplexEvent.Type.CURRENT) {
                    complexEventChunk.remove();
                    this.tryFlushEvents(outputEventChunks, (ComplexEvent)var4_4);
                    this.eventList.add((ComplexEvent)var4_4);
                    continue;
                }
                if (var4_4.getType() == ComplexEvent.Type.EXPIRED) {
                    this.tryFlushEvents(outputEventChunks, (ComplexEvent)var4_4);
                    Iterator<ComplexEvent> iterator = this.eventList.iterator();
                    while (iterator.hasNext()) {
                        ComplexEvent currentEvent = iterator.next();
                        if (this.comparator.compare(currentEvent, var4_4) != 0) continue;
                        iterator.remove();
                        continue block2;
                    }
                    continue;
                }
                if (var4_4.getType() != ComplexEvent.Type.RESET) continue;
                this.tryFlushEvents(outputEventChunks, (ComplexEvent)var4_4);
                this.eventList.clear();
            }
        }
        object = outputEventChunks.iterator();
        while (object.hasNext()) {
            ComplexEventChunk complexEventChunk2 = (ComplexEventChunk)object.next();
            this.sendToCallBacks(complexEventChunk2);
        }
        return;
    }

    private void tryFlushEvents(List<ComplexEventChunk<ComplexEvent>> outputEventChunks, ComplexEvent event) {
        if (event.getTimestamp() >= this.scheduledTime) {
            ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>(false);
            for (ComplexEvent complexEvent : this.eventList) {
                outputEventChunk.add(this.cloneComplexEvent(complexEvent));
            }
            outputEventChunks.add(outputEventChunk);
            this.scheduledTime += this.value.longValue();
            this.scheduler.notifyAt(this.scheduledTime);
        }
    }

    @Override
    public SnapshotOutputRateLimiter clone(String key, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter) {
        return new WindowedPerSnapshotOutputRateLimiter(this.id + key, this.value, this.scheduledExecutorService, wrappedSnapshotOutputRateLimiter, this.siddhiQueryContext);
    }

    @Override
    public void start() {
        this.scheduler = SchedulerParser.parse(this, this.siddhiQueryContext.getSiddhiAppContext());
        this.scheduler.setStreamEventPool(new StreamEventPool(0, 0, 0, 5));
        this.scheduler.init(this.lockWrapper, this.siddhiQueryContext.getName());
        long currentTime = System.currentTimeMillis();
        this.scheduledTime = currentTime + this.value;
        this.scheduler.notifyAt(this.scheduledTime);
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        WindowedPerSnapshotOutputRateLimiter windowedPerSnapshotOutputRateLimiter = this;
        synchronized (windowedPerSnapshotOutputRateLimiter) {
            state.put("EventList", this.eventList);
        }
        return state;
    }

    @Override
    public synchronized void restoreState(Map<String, Object> state) {
        this.eventList = (List)state.get("EventList");
    }
}

