/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.snapshot;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.MetaComplexEvent;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.state.StateEventCloner;
import io.siddhi.core.event.state.StateEventPool;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.StreamEventPool;
import io.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.AggregationGroupByWindowedPerSnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.AggregationWindowedPerSnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.AllAggregationGroupByWindowedPerSnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.AllAggregationPerSnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.GroupByPerSnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.PerSnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.SnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.WindowedPerSnapshotOutputRateLimiter;
import io.siddhi.core.query.selector.attribute.processor.AttributeProcessor;
import io.siddhi.core.query.selector.attribute.processor.executor.AbstractAggregationAttributeExecutor;
import io.siddhi.core.util.lock.LockWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;

public class WrappedSnapshotOutputRateLimiter
extends OutputRateLimiter {
    private final Long value;
    private final ScheduledExecutorService scheduledExecutorService;
    private final boolean groupBy;
    private final boolean windowed;
    private SiddhiQueryContext siddhiQueryContext;
    private SnapshotOutputRateLimiter outputRateLimiter;
    private String id;
    private List<Integer> aggregateAttributePositionList = new ArrayList<Integer>();

    public WrappedSnapshotOutputRateLimiter(String id, Long value, ScheduledExecutorService scheduledExecutorService, boolean isGroupBy, boolean isWindowed, SiddhiQueryContext siddhiQueryContext) {
        this.id = id;
        this.value = value;
        this.scheduledExecutorService = scheduledExecutorService;
        this.groupBy = isGroupBy;
        this.windowed = isWindowed;
        this.siddhiQueryContext = siddhiQueryContext;
    }

    @Override
    public OutputRateLimiter clone(String key) {
        WrappedSnapshotOutputRateLimiter instance = new WrappedSnapshotOutputRateLimiter(this.id + key, this.value, this.scheduledExecutorService, this.groupBy, this.windowed, this.siddhiQueryContext);
        instance.outputRateLimiter = this.outputRateLimiter.clone(key, instance);
        return instance;
    }

    public void init(SiddhiQueryContext siddhiQueryContext, LockWrapper lockWrapper) {
        super.init(lockWrapper, siddhiQueryContext);
        this.outputRateLimiter.setQueryLock(lockWrapper);
    }

    public void init(int outPutAttributeSize, List<AttributeProcessor> attributeProcessorList, MetaComplexEvent metaComplexEvent) {
        for (AttributeProcessor attributeProcessor : attributeProcessorList) {
            if (!(attributeProcessor.getExpressionExecutor() instanceof AbstractAggregationAttributeExecutor)) continue;
            this.aggregateAttributePositionList.add(attributeProcessor.getOutputPosition());
        }
        this.outputRateLimiter = this.windowed ? (this.groupBy ? (outPutAttributeSize == this.aggregateAttributePositionList.size() ? new AllAggregationGroupByWindowedPerSnapshotOutputRateLimiter(this.id, this.value, this.scheduledExecutorService, this, this.siddhiQueryContext) : (this.aggregateAttributePositionList.size() > 0 ? new AggregationGroupByWindowedPerSnapshotOutputRateLimiter(this.id, this.value, this.scheduledExecutorService, this.aggregateAttributePositionList, this, this.siddhiQueryContext) : new WindowedPerSnapshotOutputRateLimiter(this.id, this.value, this.scheduledExecutorService, this, this.siddhiQueryContext))) : (outPutAttributeSize == this.aggregateAttributePositionList.size() ? new AllAggregationPerSnapshotOutputRateLimiter(this.id, this.value, this.scheduledExecutorService, this, this.siddhiQueryContext) : (this.aggregateAttributePositionList.size() > 0 ? new AggregationWindowedPerSnapshotOutputRateLimiter(this.id, this.value, this.scheduledExecutorService, this.aggregateAttributePositionList, this, this.siddhiQueryContext) : new WindowedPerSnapshotOutputRateLimiter(this.id, this.value, this.scheduledExecutorService, this, this.siddhiQueryContext)))) : (this.groupBy ? new GroupByPerSnapshotOutputRateLimiter(this.id, this.value, this.scheduledExecutorService, this, this.siddhiQueryContext) : new PerSnapshotOutputRateLimiter(this.id, this.value, this.scheduledExecutorService, this, this.siddhiQueryContext));
        if (metaComplexEvent instanceof MetaStateEvent) {
            StateEventPool stateEventPool = new StateEventPool((MetaStateEvent)metaComplexEvent, 5);
            this.outputRateLimiter.setStateEventCloner(new StateEventCloner((MetaStateEvent)metaComplexEvent, stateEventPool));
        } else {
            StreamEventPool streamEventPool = new StreamEventPool((MetaStreamEvent)metaComplexEvent, 5);
            this.outputRateLimiter.setStreamEventCloner(new StreamEventCloner((MetaStreamEvent)metaComplexEvent, streamEventPool));
        }
    }

    @Override
    public void start() {
        this.outputRateLimiter.start();
    }

    @Override
    public void stop() {
        this.outputRateLimiter.stop();
    }

    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        this.outputRateLimiter.process(complexEventChunk);
    }

    public void passToCallBacks(ComplexEventChunk complexEventChunk) {
        this.sendToCallBacks(complexEventChunk);
    }

    @Override
    public Map<String, Object> currentState() {
        return this.outputRateLimiter.currentState();
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.outputRateLimiter.restoreState(state);
    }
}

