/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.time;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.GroupedComplexEvent;
import io.siddhi.core.event.stream.StreamEventPool;
import io.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import io.siddhi.core.util.Schedulable;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.parser.SchedulerParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.log4j.Logger;

public class FirstGroupByPerTimeOutputRateLimiter
extends OutputRateLimiter
implements Schedulable {
    private static final Logger log = Logger.getLogger(FirstGroupByPerTimeOutputRateLimiter.class);
    private final Long value;
    private String id;
    private List<String> groupByKeys = new ArrayList<String>();
    private ComplexEventChunk<ComplexEvent> allComplexEventChunk;
    private ScheduledExecutorService scheduledExecutorService;
    private Scheduler scheduler;
    private long scheduledTime;

    public FirstGroupByPerTimeOutputRateLimiter(String id, Long value, ScheduledExecutorService scheduledExecutorService) {
        this.id = id;
        this.value = value;
        this.scheduledExecutorService = scheduledExecutorService;
        this.allComplexEventChunk = new ComplexEventChunk(false);
    }

    @Override
    public OutputRateLimiter clone(String key) {
        FirstGroupByPerTimeOutputRateLimiter instance = new FirstGroupByPerTimeOutputRateLimiter(this.id + key, this.value, this.scheduledExecutorService);
        instance.setLatencyTracker(this.latencyTracker);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ArrayList outputEventChunks = new ArrayList();
        complexEventChunk.reset();
        FirstGroupByPerTimeOutputRateLimiter firstGroupByPerTimeOutputRateLimiter = this;
        synchronized (firstGroupByPerTimeOutputRateLimiter) {
            while (complexEventChunk.hasNext()) {
                GroupedComplexEvent groupedComplexEvent;
                Object object = complexEventChunk.next();
                if (object.getType() == ComplexEvent.Type.TIMER) {
                    if (object.getTimestamp() < this.scheduledTime) continue;
                    if (this.allComplexEventChunk.getFirst() != null) {
                        ComplexEventChunk<ComplexEvent> eventChunk = new ComplexEventChunk<ComplexEvent>(complexEventChunk.isBatch());
                        eventChunk.add(this.allComplexEventChunk.getFirst());
                        this.allComplexEventChunk.clear();
                        this.groupByKeys.clear();
                        outputEventChunks.add(eventChunk);
                    } else {
                        this.groupByKeys.clear();
                    }
                    this.scheduledTime += this.value.longValue();
                    this.scheduler.notifyAt(this.scheduledTime);
                    continue;
                }
                if (object.getType() != ComplexEvent.Type.CURRENT && object.getType() != ComplexEvent.Type.EXPIRED || this.groupByKeys.contains((groupedComplexEvent = (GroupedComplexEvent)object).getGroupKey())) continue;
                complexEventChunk.remove();
                this.groupByKeys.add(groupedComplexEvent.getGroupKey());
                this.allComplexEventChunk.add(groupedComplexEvent.getComplexEvent());
            }
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    @Override
    public void start() {
        this.scheduler = SchedulerParser.parse(this, this.siddhiQueryContext.getSiddhiAppContext());
        this.scheduler.setStreamEventPool(new StreamEventPool(0, 0, 0, 5));
        this.scheduler.init(this.lockWrapper, this.siddhiQueryContext.getName());
        long currentTime = System.currentTimeMillis();
        this.scheduledTime = currentTime + this.value;
        this.scheduler.notifyAt(this.scheduledTime);
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        FirstGroupByPerTimeOutputRateLimiter firstGroupByPerTimeOutputRateLimiter = this;
        synchronized (firstGroupByPerTimeOutputRateLimiter) {
            state.put("AllComplexEventChunk", this.allComplexEventChunk.getFirst());
            state.put("GroupByKeys", this.groupByKeys);
        }
        return state;
    }

    @Override
    public synchronized void restoreState(Map<String, Object> state) {
        this.allComplexEventChunk.clear();
        this.allComplexEventChunk.add((ComplexEvent)state.get("AllComplexEventChunk"));
        this.groupByKeys = (List)state.get("GroupByKeys");
    }
}

