/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.time;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.StreamEventPool;
import io.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import io.siddhi.core.util.Schedulable;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.parser.SchedulerParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.log4j.Logger;

public class FirstPerTimeOutputRateLimiter
extends OutputRateLimiter
implements Schedulable {
    private static final Logger log = Logger.getLogger(FirstPerTimeOutputRateLimiter.class);
    private final Long value;
    private String id;
    private ComplexEvent firstEvent = null;
    private ScheduledExecutorService scheduledExecutorService;
    private Scheduler scheduler;
    private long scheduledTime;

    public FirstPerTimeOutputRateLimiter(String id, Long value, ScheduledExecutorService scheduledExecutorService) {
        this.id = id;
        this.value = value;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public OutputRateLimiter clone(String key) {
        FirstPerTimeOutputRateLimiter instance = new FirstPerTimeOutputRateLimiter(this.id + key, this.value, this.scheduledExecutorService);
        instance.setLatencyTracker(this.latencyTracker);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ArrayList outputEventChunks = new ArrayList();
        complexEventChunk.reset();
        FirstPerTimeOutputRateLimiter firstPerTimeOutputRateLimiter = this;
        synchronized (firstPerTimeOutputRateLimiter) {
            while (complexEventChunk.hasNext()) {
                Object object = complexEventChunk.next();
                if (object.getType() == ComplexEvent.Type.TIMER) {
                    if (object.getTimestamp() < this.scheduledTime) continue;
                    if (this.firstEvent != null) {
                        this.firstEvent = null;
                    }
                    this.scheduledTime += this.value.longValue();
                    this.scheduler.notifyAt(this.scheduledTime);
                    continue;
                }
                if (object.getType() != ComplexEvent.Type.CURRENT && object.getType() != ComplexEvent.Type.EXPIRED || this.firstEvent != null) continue;
                complexEventChunk.remove();
                this.firstEvent = object;
                ComplexEventChunk<Object> firstPerEventChunk = new ComplexEventChunk<Object>(complexEventChunk.isBatch());
                firstPerEventChunk.add(object);
                outputEventChunks.add(firstPerEventChunk);
            }
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    @Override
    public void start() {
        this.scheduler = SchedulerParser.parse(this, this.siddhiQueryContext.getSiddhiAppContext());
        this.scheduler.setStreamEventPool(new StreamEventPool(0, 0, 0, 5));
        this.scheduler.init(this.lockWrapper, this.siddhiQueryContext.getName());
        long currentTime = System.currentTimeMillis();
        this.scheduledTime = currentTime + this.value;
        this.scheduler.notifyAt(this.scheduledTime);
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        FirstPerTimeOutputRateLimiter firstPerTimeOutputRateLimiter = this;
        synchronized (firstPerTimeOutputRateLimiter) {
            state.put("FirstEvent", this.firstEvent);
        }
        return state;
    }

    @Override
    public synchronized void restoreState(Map<String, Object> state) {
        this.firstEvent = (ComplexEvent)state.get("FirstEvent");
    }
}

