/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.time;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.StreamEventPool;
import io.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import io.siddhi.core.util.Schedulable;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.parser.SchedulerParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.log4j.Logger;

public class LastPerTimeOutputRateLimiter
extends OutputRateLimiter
implements Schedulable {
    private static final Logger log = Logger.getLogger(LastPerTimeOutputRateLimiter.class);
    private final Long value;
    private String id;
    private ComplexEvent lastEvent = null;
    private ScheduledExecutorService scheduledExecutorService;
    private Scheduler scheduler;
    private long scheduledTime;

    public LastPerTimeOutputRateLimiter(String id, Long value, ScheduledExecutorService scheduledExecutorService) {
        this.id = id;
        this.value = value;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public OutputRateLimiter clone(String key) {
        LastPerTimeOutputRateLimiter instance = new LastPerTimeOutputRateLimiter(this.id + key, this.value, this.scheduledExecutorService);
        instance.setLatencyTracker(this.latencyTracker);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ArrayList outputEventChunks = new ArrayList();
        complexEventChunk.reset();
        LastPerTimeOutputRateLimiter lastPerTimeOutputRateLimiter = this;
        synchronized (lastPerTimeOutputRateLimiter) {
            complexEventChunk.reset();
            while (complexEventChunk.hasNext()) {
                Object object = complexEventChunk.next();
                if (object.getType() == ComplexEvent.Type.TIMER) {
                    if (object.getTimestamp() < this.scheduledTime) continue;
                    if (this.lastEvent != null) {
                        ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>(complexEventChunk.isBatch());
                        outputEventChunk.add(this.lastEvent);
                        this.lastEvent = null;
                        outputEventChunks.add(outputEventChunk);
                    }
                    this.scheduledTime += this.value.longValue();
                    this.scheduler.notifyAt(this.scheduledTime);
                    continue;
                }
                if (object.getType() != ComplexEvent.Type.CURRENT && object.getType() != ComplexEvent.Type.EXPIRED) continue;
                complexEventChunk.remove();
                this.lastEvent = object;
            }
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    @Override
    public void start() {
        this.scheduler = SchedulerParser.parse(this, this.siddhiQueryContext.getSiddhiAppContext());
        this.scheduler.setStreamEventPool(new StreamEventPool(0, 0, 0, 5));
        this.scheduler.init(this.lockWrapper, this.siddhiQueryContext.getName());
        long currentTime = System.currentTimeMillis();
        this.scheduledTime = currentTime + this.value;
        this.scheduler.notifyAt(this.scheduledTime);
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        LastPerTimeOutputRateLimiter lastPerTimeOutputRateLimiter = this;
        synchronized (lastPerTimeOutputRateLimiter) {
            state.put("LastEvent", this.lastEvent);
        }
        return state;
    }

    @Override
    public synchronized void restoreState(Map<String, Object> state) {
        this.lastEvent = (ComplexEvent)state.get("LastEvent");
    }
}

