/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.processor.stream;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.holder.StreamEventClonerHolder;
import io.siddhi.core.event.stream.populater.ComplexEventPopulater;
import io.siddhi.core.event.stream.populater.StreamEventPopulaterFactory;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.extension.holder.EternalReferencedHolder;
import io.siddhi.core.util.snapshot.Snapshotable;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractStreamProcessor
implements Processor,
EternalReferencedHolder,
Snapshotable {
    private static final Logger log = Logger.getLogger(AbstractStreamProcessor.class);
    protected Processor nextProcessor;
    protected List<Attribute> additionalAttributes;
    protected MetaStreamEvent metaStreamEvent;
    protected SiddhiQueryContext siddhiQueryContext;
    protected StreamEventClonerHolder streamEventClonerHolder = new StreamEventClonerHolder();
    protected StreamEventCloner streamEventCloner;
    protected AbstractDefinition inputDefinition;
    protected ExpressionExecutor[] attributeExpressionExecutors;
    protected int attributeExpressionLength;
    protected ComplexEventPopulater complexEventPopulater;
    protected String elementId = null;
    private ConfigReader configReader;
    private boolean outputExpectsExpiredEvents;

    public void initProcessor(MetaStreamEvent metaStreamEvent, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, SiddhiElement siddhiElement, SiddhiQueryContext siddhiQueryContext) {
        this.configReader = configReader;
        this.outputExpectsExpiredEvents = outputExpectsExpiredEvents;
        this.metaStreamEvent = metaStreamEvent;
        this.siddhiQueryContext = siddhiQueryContext;
        try {
            this.inputDefinition = metaStreamEvent.getLastInputDefinition();
            this.attributeExpressionExecutors = attributeExpressionExecutors;
            this.attributeExpressionLength = attributeExpressionExecutors.length;
            if (this.elementId == null) {
                this.elementId = "AbstractStreamProcessor-" + siddhiQueryContext.getSiddhiAppContext().getElementIdGenerator().createNewId();
            }
            siddhiQueryContext.getSiddhiAppContext().getSnapshotService().addSnapshotable(siddhiQueryContext.getName(), this);
            this.additionalAttributes = this.init(metaStreamEvent, metaStreamEvent.getLastInputDefinition(), attributeExpressionExecutors, configReader, outputExpectsExpiredEvents, siddhiQueryContext);
            siddhiQueryContext.getSiddhiAppContext().addEternalReferencedHolder(this);
            if (this.additionalAttributes.size() > 0) {
                StreamDefinition outputDefinition = StreamDefinition.id((String)this.inputDefinition.getId());
                outputDefinition.setQueryContextStartIndex(siddhiElement.getQueryContextStartIndex());
                outputDefinition.setQueryContextEndIndex(siddhiElement.getQueryContextEndIndex());
                for (Attribute attribute : this.inputDefinition.getAttributeList()) {
                    outputDefinition.attribute(attribute.getName(), attribute.getType());
                }
                for (Attribute attribute : this.additionalAttributes) {
                    outputDefinition.attribute(attribute.getName(), attribute.getType());
                }
                metaStreamEvent.addInputDefinition((AbstractDefinition)outputDefinition);
            }
        }
        catch (Throwable t) {
            throw new SiddhiAppCreationException(t.getMessage(), t, siddhiElement.getQueryContextStartIndex(), siddhiElement.getQueryContextEndIndex(), siddhiQueryContext.getSiddhiAppContext());
        }
    }

    protected abstract List<Attribute> init(MetaStreamEvent var1, AbstractDefinition var2, ExpressionExecutor[] var3, ConfigReader var4, boolean var5, SiddhiQueryContext var6);

    @Override
    public void process(ComplexEventChunk streamEventChunk) {
        streamEventChunk.reset();
        this.processEventChunk(streamEventChunk, this.nextProcessor, this.streamEventCloner, this.complexEventPopulater);
    }

    protected abstract void processEventChunk(ComplexEventChunk<StreamEvent> var1, Processor var2, StreamEventCloner var3, ComplexEventPopulater var4);

    @Override
    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    @Override
    public void setNextProcessor(Processor processor) {
        this.nextProcessor = processor;
    }

    @Override
    public Processor cloneProcessor(String key) {
        try {
            AbstractStreamProcessor abstractStreamProcessor = (AbstractStreamProcessor)this.getClass().newInstance();
            abstractStreamProcessor.inputDefinition = this.inputDefinition;
            ExpressionExecutor[] innerExpressionExecutors = new ExpressionExecutor[this.attributeExpressionLength];
            ExpressionExecutor[] attributeExpressionExecutors1 = this.attributeExpressionExecutors;
            for (int i = 0; i < this.attributeExpressionLength; ++i) {
                innerExpressionExecutors[i] = attributeExpressionExecutors1[i].cloneExecutor(key);
            }
            abstractStreamProcessor.attributeExpressionExecutors = innerExpressionExecutors;
            abstractStreamProcessor.attributeExpressionLength = this.attributeExpressionLength;
            abstractStreamProcessor.additionalAttributes = this.additionalAttributes;
            abstractStreamProcessor.additionalAttributes = this.additionalAttributes;
            abstractStreamProcessor.complexEventPopulater = this.complexEventPopulater;
            abstractStreamProcessor.siddhiQueryContext = this.siddhiQueryContext;
            abstractStreamProcessor.elementId = this.elementId + "-" + key;
            abstractStreamProcessor.configReader = this.configReader;
            abstractStreamProcessor.outputExpectsExpiredEvents = this.outputExpectsExpiredEvents;
            abstractStreamProcessor.siddhiQueryContext.getSiddhiAppContext().getSnapshotService().addSnapshotable(this.siddhiQueryContext.getName(), abstractStreamProcessor);
            abstractStreamProcessor.siddhiQueryContext.getSiddhiAppContext().addEternalReferencedHolder(abstractStreamProcessor);
            abstractStreamProcessor.init(this.metaStreamEvent, this.inputDefinition, this.attributeExpressionExecutors, this.configReader, this.outputExpectsExpiredEvents, this.siddhiQueryContext);
            abstractStreamProcessor.start();
            return abstractStreamProcessor;
        }
        catch (Exception e) {
            throw new SiddhiAppRuntimeException("Exception in cloning " + this.getClass().getCanonicalName(), e);
        }
    }

    public void constructStreamEventPopulater(MetaStreamEvent metaStreamEvent, int streamEventChainIndex) {
        if (this.complexEventPopulater == null) {
            this.complexEventPopulater = StreamEventPopulaterFactory.constructEventPopulator(metaStreamEvent, streamEventChainIndex, this.additionalAttributes);
        }
    }

    public void setStreamEventCloner(StreamEventCloner streamEventCloner) {
        this.streamEventCloner = streamEventCloner;
        this.streamEventClonerHolder.setStreamEventCloner(streamEventCloner);
    }

    @Override
    public void setToLast(Processor processor) {
        if (this.nextProcessor == null) {
            this.nextProcessor = processor;
        } else {
            this.nextProcessor.setToLast(processor);
        }
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public void clean() {
        for (ExpressionExecutor expressionExecutor : this.attributeExpressionExecutors) {
            expressionExecutor.clean();
        }
        this.siddhiQueryContext.getSiddhiAppContext().getSnapshotService().removeSnapshotable(this.siddhiQueryContext.getName(), this);
    }

    public abstract ProcessingMode getProcessingMode();
}

