/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.MetaComplexEvent;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.parser.ExpressionParser;
import io.siddhi.query.api.expression.Expression;
import java.util.List;
import java.util.Map;

public class GroupByKeyGenerator {
    private ExpressionExecutor[] groupByExecutors = null;

    public GroupByKeyGenerator(List<Expression> groupByList, MetaComplexEvent metaComplexEvent, int currentState, Map<String, Table> tableMap, List<VariableExpressionExecutor> executors, SiddhiQueryContext siddhiQueryContext) {
        if (!groupByList.isEmpty()) {
            this.groupByExecutors = new ExpressionExecutor[groupByList.size()];
            int expressionsSize = groupByList.size();
            for (int i = 0; i < expressionsSize; ++i) {
                this.groupByExecutors[i] = ExpressionParser.parseExpression(groupByList.get(i), metaComplexEvent, currentState, tableMap, executors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            }
        }
    }

    public String constructEventKey(ComplexEvent event) {
        if (this.groupByExecutors != null) {
            StringBuilder sb = new StringBuilder();
            for (ExpressionExecutor executor : this.groupByExecutors) {
                sb.append(executor.execute(event)).append(":-:");
            }
            return sb.toString();
        }
        return null;
    }

    public void clean() {
        for (ExpressionExecutor expressionExecutor : this.groupByExecutors) {
            expressionExecutor.clean();
        }
    }
}

