/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.query.api.definition.Attribute;
import java.util.Map;

public abstract class AttributeAggregator {
    protected ExpressionExecutor[] attributeExpressionExecutors;
    private int attributeSize;
    private ProcessingMode processingMode;
    private boolean outputExpectsExpiredEvents;
    private SiddhiQueryContext siddhiQueryContext;
    private ConfigReader configReader;

    public void initAggregator(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        this.processingMode = processingMode;
        this.outputExpectsExpiredEvents = outputExpectsExpiredEvents;
        this.siddhiQueryContext = siddhiQueryContext;
        this.configReader = configReader;
        try {
            this.attributeExpressionExecutors = attributeExpressionExecutors;
            this.attributeSize = attributeExpressionExecutors.length;
            this.init(attributeExpressionExecutors, processingMode, outputExpectsExpiredEvents, configReader, siddhiQueryContext);
        }
        catch (Throwable t) {
            throw new SiddhiAppCreationException(t);
        }
    }

    public AttributeAggregator cloneAggregator(String key) {
        try {
            AttributeAggregator attributeAggregator = (AttributeAggregator)this.getClass().newInstance();
            ExpressionExecutor[] innerExpressionExecutors = new ExpressionExecutor[this.attributeSize];
            for (int i = 0; i < this.attributeSize; ++i) {
                innerExpressionExecutors[i] = this.attributeExpressionExecutors[i].cloneExecutor(key);
            }
            attributeAggregator.initAggregator(innerExpressionExecutors, this.processingMode, this.outputExpectsExpiredEvents, this.configReader, this.siddhiQueryContext);
            return attributeAggregator;
        }
        catch (Exception e) {
            throw new SiddhiAppRuntimeException("Exception in cloning " + this.getClass().getCanonicalName(), e);
        }
    }

    public synchronized Object process(ComplexEvent event) {
        if (this.attributeSize > 1) {
            Object[] data = new Object[this.attributeSize];
            for (int i = 0; i < this.attributeSize; ++i) {
                data[i] = this.attributeExpressionExecutors[i].execute(event);
            }
            switch (event.getType()) {
                case CURRENT: {
                    return this.processAdd(data);
                }
                case EXPIRED: {
                    return this.processRemove(data);
                }
                case RESET: {
                    return this.reset();
                }
            }
        } else if (this.attributeSize == 1) {
            switch (event.getType()) {
                case CURRENT: {
                    return this.processAdd(this.attributeExpressionExecutors[0].execute(event));
                }
                case EXPIRED: {
                    return this.processRemove(this.attributeExpressionExecutors[0].execute(event));
                }
                case RESET: {
                    return this.reset();
                }
            }
        } else {
            switch (event.getType()) {
                case CURRENT: {
                    return this.processAdd(null);
                }
                case EXPIRED: {
                    return this.processRemove(null);
                }
                case RESET: {
                    return this.reset();
                }
            }
        }
        return null;
    }

    protected abstract void init(ExpressionExecutor[] var1, ProcessingMode var2, boolean var3, ConfigReader var4, SiddhiQueryContext var5);

    public abstract Attribute.Type getReturnType();

    public abstract Object processAdd(Object var1);

    public abstract Object processAdd(Object[] var1);

    public abstract Object processRemove(Object var1);

    public abstract Object processRemove(Object[] var1);

    public abstract boolean canDestroy();

    public abstract Object reset();

    public abstract Map<String, Object> currentState();

    public abstract void restoreState(Map<String, Object> var1);

    public void clean() {
        for (ExpressionExecutor expressionExecutor : this.attributeExpressionExecutors) {
            expressionExecutor.clean();
        }
    }
}

