/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.query.api.definition.Attribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@Extension(name="avg", namespace="", description="Calculates the average for all the events.", parameters={@Parameter(name="arg", description="The value that need to be averaged.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, returnAttributes={@ReturnAttribute(description="Returns the calculated average value as a double.", type={DataType.DOUBLE})}, examples={@Example(syntax="from fooStream#window.timeBatch\n select avg(temp) as avgTemp\n insert into barStream;", description="avg(temp) returns the average temp value for all the events based on their arrival and expiry.")})
public class AvgAttributeAggregator
extends AttributeAggregator {
    private AvgAttributeAggregator avgOutputAttributeAggregator;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Avg aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case FLOAT: {
                this.avgOutputAttributeAggregator = new AvgAttributeAggregatorFloat();
                break;
            }
            case INT: {
                this.avgOutputAttributeAggregator = new AvgAttributeAggregatorInt();
                break;
            }
            case LONG: {
                this.avgOutputAttributeAggregator = new AvgAttributeAggregatorLong();
                break;
            }
            case DOUBLE: {
                this.avgOutputAttributeAggregator = new AvgAttributeAggregatorDouble();
                break;
            }
            default: {
                throw new OperationNotSupportedException("Avg not supported for " + type);
            }
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.avgOutputAttributeAggregator.getReturnType();
    }

    @Override
    public Object processAdd(Object data) {
        if (data == null) {
            return this.avgOutputAttributeAggregator.currentValue();
        }
        return this.avgOutputAttributeAggregator.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("Avg cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        if (data == null) {
            return this.avgOutputAttributeAggregator.currentValue();
        }
        return this.avgOutputAttributeAggregator.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("Avg cannot process data array, but found " + Arrays.deepToString(data));
    }

    protected Object currentValue() {
        return null;
    }

    @Override
    public boolean canDestroy() {
        return this.avgOutputAttributeAggregator.canDestroy();
    }

    @Override
    public Object reset() {
        return this.avgOutputAttributeAggregator.reset();
    }

    @Override
    public Map<String, Object> currentState() {
        return this.avgOutputAttributeAggregator.currentState();
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.avgOutputAttributeAggregator.restoreState(state);
    }

    class AvgAttributeAggregatorLong
    extends AvgAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private double value = 0.0;
        private long count = 0L;

        AvgAttributeAggregatorLong() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            ++this.count;
            this.value += (double)((Long)data).longValue();
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object processRemove(Object obj) {
            --this.count;
            this.value -= (double)((Long)obj).longValue();
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object reset() {
            this.value = 0.0;
            this.count = 0L;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.value == 0.0 && this.count == 0L;
        }

        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Value", this.value);
            state.put("Count", this.count);
            return state;
        }

        @Override
        public void restoreState(Map<String, Object> state) {
            this.value = (Double)state.get("Value");
            this.count = (Long)state.get("Count");
        }

        @Override
        protected Object currentValue() {
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }
    }

    class AvgAttributeAggregatorInt
    extends AvgAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private double value = 0.0;
        private long count = 0L;

        AvgAttributeAggregatorInt() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            ++this.count;
            this.value += (double)((Integer)data).intValue();
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object processRemove(Object obj) {
            --this.count;
            this.value -= (double)((Integer)obj).intValue();
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object reset() {
            this.value = 0.0;
            this.count = 0L;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.value == 0.0 && this.count == 0L;
        }

        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Value", this.value);
            state.put("Count", this.count);
            return state;
        }

        @Override
        public void restoreState(Map<String, Object> state) {
            this.value = (Double)state.get("Value");
            this.count = (Long)state.get("Count");
        }

        @Override
        protected Object currentValue() {
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }
    }

    class AvgAttributeAggregatorFloat
    extends AvgAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private double value = 0.0;
        private long count = 0L;

        AvgAttributeAggregatorFloat() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            ++this.count;
            this.value += (double)((Float)data).floatValue();
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object processRemove(Object obj) {
            --this.count;
            this.value -= (double)((Float)obj).floatValue();
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object reset() {
            this.value = 0.0;
            this.count = 0L;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.value == 0.0 && this.count == 0L;
        }

        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Value", this.value);
            state.put("Count", this.count);
            return state;
        }

        @Override
        public void restoreState(Map<String, Object> state) {
            this.value = (Double)state.get("Value");
            this.count = (Long)state.get("Count");
        }

        @Override
        protected Object currentValue() {
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }
    }

    class AvgAttributeAggregatorDouble
    extends AvgAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private double value = 0.0;
        private long count = 0L;

        AvgAttributeAggregatorDouble() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            ++this.count;
            this.value += ((Double)data).doubleValue();
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object processRemove(Object obj) {
            --this.count;
            this.value -= ((Double)obj).doubleValue();
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object reset() {
            this.value = 0.0;
            this.count = 0L;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.value == 0.0 && this.count == 0L;
        }

        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Value", this.value);
            state.put("Count", this.count);
            return state;
        }

        @Override
        public void restoreState(Map<String, Object> state) {
            this.value = (Double)state.get("Value");
            this.count = (Long)state.get("Count");
        }

        @Override
        protected Object currentValue() {
            if (this.count == 0L) {
                return null;
            }
            return this.value / (double)this.count;
        }
    }
}

