/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.query.api.definition.Attribute;
import java.util.HashMap;
import java.util.Map;

@Extension(name="count", namespace="", description="Returns the count of all the events.", parameters={}, returnAttributes={@ReturnAttribute(description="Returns the event count as a long.", type={DataType.LONG})}, examples={@Example(syntax="from fooStream#window.timeBatch(10 sec)\nselect count() as count\ninsert into barStream;", description="This will return the count of all the events for time batch in 10 seconds.")})
public class CountAttributeAggregator
extends AttributeAggregator {
    private static Attribute.Type type = Attribute.Type.LONG;
    private long count = 0L;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
    }

    @Override
    public Attribute.Type getReturnType() {
        return type;
    }

    @Override
    public Object processAdd(Object data) {
        ++this.count;
        return this.count;
    }

    @Override
    public Object processAdd(Object[] data) {
        ++this.count;
        return this.count;
    }

    @Override
    public Object processRemove(Object data) {
        --this.count;
        return this.count;
    }

    @Override
    public Object processRemove(Object[] data) {
        --this.count;
        return this.count;
    }

    @Override
    public Object reset() {
        this.count = 0L;
        return this.count;
    }

    @Override
    public boolean canDestroy() {
        return this.count == 0L;
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("Count", this.count);
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.count = (Long)state.get("Count");
    }
}

