/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.query.api.definition.Attribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@Extension(name="distinctCount", namespace="", description="This returns the count of distinct occurrences for a given arg.", parameters={@Parameter(name="arg", description="The object for which the number of distinct occurences needs to be counted.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING})}, returnAttributes={@ReturnAttribute(description="Returns the count of distinct occurrences for a given arg.", type={DataType.LONG})}, examples={@Example(syntax="from fooStream\nselect distinctcount(pageID) as count\ninsert into barStream;", description="distinctcount(pageID) for the following output returns '3' when the available values are as follows.\n \"WEB_PAGE_1\"\n \"WEB_PAGE_1\"\n \"WEB_PAGE_2\"\n \"WEB_PAGE_3\"\n \"WEB_PAGE_1\"\n \"WEB_PAGE_2\"\n The three distinct occurences identified are 'WEB_PAGE_1', 'WEB_PAGE_2', and 'WEB_PAGE_3'.")})
public class DistinctCountAttributeAggregator
extends AttributeAggregator {
    private Map<Object, Long> distinctValues = new HashMap<Object, Long>();

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Distinct count aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.LONG;
    }

    @Override
    public Object processAdd(Object data) {
        Long preVal = this.distinctValues.get(data);
        if (preVal != null) {
            preVal = preVal + 1L;
            this.distinctValues.put(data, preVal);
        } else {
            this.distinctValues.put(data, 1L);
        }
        return this.getDistinctCount();
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("Distinct count aggregator cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        Long preVal;
        Long l = preVal = this.distinctValues.get(data);
        Long l2 = preVal = Long.valueOf(preVal - 1L);
        if (preVal > 0L) {
            this.distinctValues.put(data, preVal);
        } else {
            this.distinctValues.remove(data);
        }
        return this.getDistinctCount();
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("Distinct count aggregator cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset() {
        this.distinctValues.clear();
        return this.getDistinctCount();
    }

    @Override
    public boolean canDestroy() {
        return this.distinctValues.size() == 0;
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("DistinctValues", this.distinctValues);
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.distinctValues = (Map)state.get("DistinctValues");
    }

    private long getDistinctCount() {
        return this.distinctValues.size();
    }
}

