/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.query.api.definition.Attribute;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

@Extension(name="max", namespace="", description="Returns the maximum value for all the events.", parameters={@Parameter(name="arg", description="The value that needs to be compared to find the maximum value.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, returnAttributes={@ReturnAttribute(description="Returns the maximum value in the same data type as the input.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, examples={@Example(syntax="from fooStream#window.timeBatch(10 sec)\nselect max(temp) as maxTemp\ninsert into barStream;", description="max(temp) returns the maximum temp value recorded for all the events based on their arrival and expiry.")})
public class MaxAttributeAggregator
extends AttributeAggregator {
    private MaxAttributeAggregator maxOutputAttributeAggregator;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Max aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        boolean trackFutureStates = false;
        if (processingMode == ProcessingMode.SLIDE || outputExpectsExpiredEvents) {
            trackFutureStates = true;
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case FLOAT: {
                this.maxOutputAttributeAggregator = new MaxAttributeAggregatorFloat(trackFutureStates);
                break;
            }
            case INT: {
                this.maxOutputAttributeAggregator = new MaxAttributeAggregatorInt(trackFutureStates);
                break;
            }
            case LONG: {
                this.maxOutputAttributeAggregator = new MaxAttributeAggregatorLong(trackFutureStates);
                break;
            }
            case DOUBLE: {
                this.maxOutputAttributeAggregator = new MaxAttributeAggregatorDouble(trackFutureStates);
                break;
            }
            default: {
                throw new OperationNotSupportedException("Max not supported for " + type);
            }
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.maxOutputAttributeAggregator.getReturnType();
    }

    @Override
    public Object processAdd(Object data) {
        if (data == null) {
            return this.maxOutputAttributeAggregator.currentValue();
        }
        return this.maxOutputAttributeAggregator.processAdd(data);
    }

    protected Object currentValue() {
        return null;
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("Max cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        if (data == null) {
            return this.maxOutputAttributeAggregator.currentValue();
        }
        return this.maxOutputAttributeAggregator.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("Max cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public boolean canDestroy() {
        return this.maxOutputAttributeAggregator.canDestroy();
    }

    @Override
    public Object reset() {
        return this.maxOutputAttributeAggregator.reset();
    }

    @Override
    public Map<String, Object> currentState() {
        return this.maxOutputAttributeAggregator.currentState();
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.maxOutputAttributeAggregator.restoreState(state);
    }

    class MaxAttributeAggregatorLong
    extends MaxAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.LONG;
        private Deque<Long> maxDeque = null;
        private volatile Long maxValue = null;

        public MaxAttributeAggregatorLong(boolean trackFutureStates) {
            if (trackFutureStates) {
                this.maxDeque = new LinkedList<Long>();
            }
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Long value = (Long)data;
            if (this.maxDeque != null) {
                Iterator<Long> iterator = this.maxDeque.descendingIterator();
                while (iterator.hasNext() && iterator.next() < value) {
                    iterator.remove();
                }
                this.maxDeque.addLast(value);
            }
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            if (this.maxDeque != null) {
                this.maxDeque.removeFirstOccurrence(data);
                this.maxValue = this.maxDeque.peekFirst();
            } else if (this.maxValue != null && this.maxValue.equals(data)) {
                this.maxValue = null;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object reset() {
            if (this.maxDeque != null) {
                this.maxDeque.clear();
            }
            this.maxValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return (this.maxDeque == null || this.maxDeque.size() == 0) && this.maxValue == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            MaxAttributeAggregatorLong maxAttributeAggregatorLong = this;
            synchronized (maxAttributeAggregatorLong) {
                state.put("MaxValue", this.maxValue);
                state.put("MaxDeque", this.maxDeque);
            }
            return state;
        }

        @Override
        public synchronized void restoreState(Map<String, Object> state) {
            this.maxValue = (Long)state.get("MaxValue");
            this.maxDeque = (Deque)state.get("MaxDeque");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }

    class MaxAttributeAggregatorInt
    extends MaxAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.INT;
        private Deque<Integer> maxDeque = null;
        private volatile Integer maxValue = null;

        public MaxAttributeAggregatorInt(boolean trackFutureStates) {
            if (trackFutureStates) {
                this.maxDeque = new LinkedList<Integer>();
            }
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Integer value = (Integer)data;
            if (this.maxDeque != null) {
                Iterator<Integer> iterator = this.maxDeque.descendingIterator();
                while (iterator.hasNext() && iterator.next() < value) {
                    iterator.remove();
                }
                this.maxDeque.addLast(value);
            }
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            if (this.maxDeque != null) {
                this.maxDeque.removeFirstOccurrence(data);
                this.maxValue = this.maxDeque.peekFirst();
            } else if (this.maxValue != null && this.maxValue.equals(data)) {
                this.maxValue = null;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object reset() {
            if (this.maxDeque != null) {
                this.maxDeque.clear();
            }
            this.maxValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return (this.maxDeque == null || this.maxDeque.size() == 0) && this.maxValue == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            MaxAttributeAggregatorInt maxAttributeAggregatorInt = this;
            synchronized (maxAttributeAggregatorInt) {
                state.put("MaxValue", this.maxValue);
                state.put("MaxDeque", this.maxDeque);
            }
            return state;
        }

        @Override
        public synchronized void restoreState(Map<String, Object> state) {
            this.maxValue = (Integer)state.get("MaxValue");
            this.maxDeque = (Deque)state.get("MaxDeque");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }

    class MaxAttributeAggregatorFloat
    extends MaxAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.FLOAT;
        private Deque<Float> maxDeque = null;
        private volatile Float maxValue = null;

        public MaxAttributeAggregatorFloat(boolean trackFutureStates) {
            if (trackFutureStates) {
                this.maxDeque = new LinkedList<Float>();
            }
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Float value = (Float)data;
            if (this.maxDeque != null) {
                Iterator<Float> iterator = this.maxDeque.descendingIterator();
                while (iterator.hasNext() && iterator.next().floatValue() < value.floatValue()) {
                    iterator.remove();
                }
                this.maxDeque.addLast(value);
            }
            if (this.maxValue == null || this.maxValue.floatValue() < value.floatValue()) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            if (this.maxDeque != null) {
                this.maxDeque.removeFirstOccurrence(data);
                this.maxValue = this.maxDeque.peekFirst();
            } else if (this.maxValue != null && this.maxValue.equals(data)) {
                this.maxValue = null;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object reset() {
            if (this.maxDeque != null) {
                this.maxDeque.clear();
            }
            this.maxValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return (this.maxDeque == null || this.maxDeque.size() == 0) && this.maxValue == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            MaxAttributeAggregatorFloat maxAttributeAggregatorFloat = this;
            synchronized (maxAttributeAggregatorFloat) {
                state.put("MaxValue", this.maxValue);
                state.put("MaxDeque", this.maxDeque);
            }
            return state;
        }

        @Override
        public synchronized void restoreState(Map<String, Object> state) {
            this.maxValue = (Float)state.get("MaxValue");
            this.maxDeque = (Deque)state.get("MaxDeque");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }

    class MaxAttributeAggregatorDouble
    extends MaxAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private Deque<Double> maxDeque = null;
        private volatile Double maxValue = null;

        public MaxAttributeAggregatorDouble(boolean trackFutureStates) {
            if (trackFutureStates) {
                this.maxDeque = new LinkedList<Double>();
            }
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Double value = (Double)data;
            if (this.maxDeque != null) {
                Iterator<Double> iterator = this.maxDeque.descendingIterator();
                while (iterator.hasNext() && iterator.next() < value) {
                    iterator.remove();
                }
                this.maxDeque.addLast(value);
            }
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            if (this.maxDeque != null) {
                this.maxDeque.removeFirstOccurrence(data);
                this.maxValue = this.maxDeque.peekFirst();
            } else if (this.maxValue != null && this.maxValue.equals(data)) {
                this.maxValue = null;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object reset() {
            if (this.maxDeque != null) {
                this.maxDeque.clear();
            }
            this.maxValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return (this.maxDeque == null || this.maxDeque.size() == 0) && this.maxValue == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            MaxAttributeAggregatorDouble maxAttributeAggregatorDouble = this;
            synchronized (maxAttributeAggregatorDouble) {
                state.put("MaxValue", this.maxValue);
                state.put("MaxDeque", this.maxDeque);
            }
            return state;
        }

        @Override
        public synchronized void restoreState(Map<String, Object> state) {
            this.maxValue = (Double)state.get("MaxValue");
            this.maxDeque = (Deque)state.get("MaxDeque");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }
}

