/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.query.api.definition.Attribute;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

@Extension(name="min", namespace="", description="Returns the minimum value for all the events.", parameters={@Parameter(name="arg", description="The value that needs to be compared to find the minimum value.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, returnAttributes={@ReturnAttribute(description="Returns the minimum value in the same type as the input.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, examples={@Example(syntax="from inputStream\nselect min(temp) as minTemp\ninsert into outputStream;", description="min(temp) returns the minimum temp value recorded for all the events based on their arrival and expiry.")})
public class MinAttributeAggregator
extends AttributeAggregator {
    private MinAttributeAggregator minOutputAttributeAggregator;

    public void init(Attribute.Type type) {
    }

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Min aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        boolean trackFutureStates = false;
        if (processingMode == ProcessingMode.SLIDE || outputExpectsExpiredEvents) {
            trackFutureStates = true;
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case FLOAT: {
                this.minOutputAttributeAggregator = new MinAttributeAggregatorFloat(trackFutureStates);
                break;
            }
            case INT: {
                this.minOutputAttributeAggregator = new MinAttributeAggregatorInt(trackFutureStates);
                break;
            }
            case LONG: {
                this.minOutputAttributeAggregator = new MinAttributeAggregatorLong(trackFutureStates);
                break;
            }
            case DOUBLE: {
                this.minOutputAttributeAggregator = new MinAttributeAggregatorDouble(trackFutureStates);
                break;
            }
            default: {
                throw new OperationNotSupportedException("Min not supported for " + type);
            }
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.minOutputAttributeAggregator.getReturnType();
    }

    @Override
    public Object processAdd(Object data) {
        if (data == null) {
            return this.minOutputAttributeAggregator.currentValue();
        }
        return this.minOutputAttributeAggregator.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("Min cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        if (data == null) {
            return this.minOutputAttributeAggregator.currentValue();
        }
        return this.minOutputAttributeAggregator.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("Min cannot process data array, but found " + Arrays.deepToString(data));
    }

    protected Object currentValue() {
        return null;
    }

    @Override
    public boolean canDestroy() {
        return this.minOutputAttributeAggregator.canDestroy();
    }

    @Override
    public Object reset() {
        return this.minOutputAttributeAggregator.reset();
    }

    @Override
    public Map<String, Object> currentState() {
        return this.minOutputAttributeAggregator.currentState();
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.minOutputAttributeAggregator.restoreState(state);
    }

    class MinAttributeAggregatorLong
    extends MinAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.LONG;
        private Deque<Long> minDeque = null;
        private volatile Long minValue = null;

        public MinAttributeAggregatorLong(boolean trackFutureStates) {
            if (trackFutureStates) {
                this.minDeque = new LinkedList<Long>();
            }
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Long value = (Long)data;
            if (this.minDeque != null) {
                Iterator<Long> iterator = this.minDeque.descendingIterator();
                while (iterator.hasNext() && iterator.next() > value) {
                    iterator.remove();
                }
                this.minDeque.addLast(value);
            }
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public synchronized Object reset() {
            if (this.minDeque != null) {
                this.minDeque.clear();
            }
            this.minValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return (this.minDeque == null || this.minDeque.size() == 0) && this.minValue == null;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            if (this.minDeque != null) {
                this.minDeque.removeFirstOccurrence(data);
                this.minValue = this.minDeque.peekFirst();
            } else if (this.minValue != null && this.minValue.equals(data)) {
                this.minValue = null;
            }
            return this.minValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            MinAttributeAggregatorLong minAttributeAggregatorLong = this;
            synchronized (minAttributeAggregatorLong) {
                state.put("MinValue", this.minValue);
                state.put("MinDeque", this.minDeque);
            }
            return state;
        }

        @Override
        public synchronized void restoreState(Map<String, Object> state) {
            this.minValue = (Long)state.get("MinValue");
            this.minDeque = (Deque)state.get("MinDeque");
        }

        @Override
        protected Object currentValue() {
            return this.minValue;
        }
    }

    class MinAttributeAggregatorInt
    extends MinAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.INT;
        private Deque<Integer> minDeque = null;
        private volatile Integer minValue = null;

        public MinAttributeAggregatorInt(boolean trackFutureStates) {
            if (trackFutureStates) {
                this.minDeque = new LinkedList<Integer>();
            }
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Integer value = (Integer)data;
            if (this.minDeque != null) {
                Iterator<Integer> iterator = this.minDeque.descendingIterator();
                while (iterator.hasNext() && iterator.next() > value) {
                    iterator.remove();
                }
                this.minDeque.addLast(value);
            }
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public synchronized Object reset() {
            if (this.minDeque != null) {
                this.minDeque.clear();
            }
            this.minValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return (this.minDeque == null || this.minDeque.size() == 0) && this.minValue == null;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            if (this.minDeque != null) {
                this.minDeque.removeFirstOccurrence(data);
                this.minValue = this.minDeque.peekFirst();
            } else if (this.minValue != null && this.minValue.equals(data)) {
                this.minValue = null;
            }
            return this.minValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            MinAttributeAggregatorInt minAttributeAggregatorInt = this;
            synchronized (minAttributeAggregatorInt) {
                state.put("MinValue", this.minValue);
                state.put("MinDeque", this.minDeque);
            }
            return state;
        }

        @Override
        public synchronized void restoreState(Map<String, Object> state) {
            this.minValue = (Integer)state.get("MinValue");
            this.minDeque = (Deque)state.get("MinDeque");
        }

        @Override
        protected Object currentValue() {
            return this.minValue;
        }
    }

    class MinAttributeAggregatorFloat
    extends MinAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.FLOAT;
        private Deque<Float> minDeque = null;
        private volatile Float minValue = null;

        public MinAttributeAggregatorFloat(boolean trackFutureStates) {
            if (trackFutureStates) {
                this.minDeque = new LinkedList<Float>();
            }
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Float value = (Float)data;
            if (this.minDeque != null) {
                Iterator<Float> iterator = this.minDeque.descendingIterator();
                while (iterator.hasNext() && iterator.next().floatValue() > value.floatValue()) {
                    iterator.remove();
                }
                this.minDeque.addLast(value);
            }
            if (this.minValue == null || this.minValue.floatValue() > value.floatValue()) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            if (this.minDeque != null) {
                this.minDeque.removeFirstOccurrence(data);
                this.minValue = this.minDeque.peekFirst();
            } else if (this.minValue != null && this.minValue.equals(data)) {
                this.minValue = null;
            }
            return this.minValue;
        }

        @Override
        public synchronized Object reset() {
            if (this.minDeque != null) {
                this.minDeque.clear();
            }
            this.minValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return (this.minDeque == null || this.minDeque.size() == 0) && this.minValue == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            MinAttributeAggregatorFloat minAttributeAggregatorFloat = this;
            synchronized (minAttributeAggregatorFloat) {
                state.put("MinValue", this.minValue);
                state.put("MinDeque", this.minDeque);
            }
            return state;
        }

        @Override
        public synchronized void restoreState(Map<String, Object> state) {
            this.minValue = (Float)state.get("MinValue");
            this.minDeque = (Deque)state.get("MinDeque");
        }

        @Override
        protected Object currentValue() {
            return this.minValue;
        }
    }

    class MinAttributeAggregatorDouble
    extends MinAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private Deque<Double> minDeque = null;
        private volatile Double minValue = null;

        public MinAttributeAggregatorDouble(boolean trackFutureStates) {
            if (trackFutureStates) {
                this.minDeque = new LinkedList<Double>();
            }
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Double value = (Double)data;
            if (this.minDeque != null) {
                Iterator<Double> iterator = this.minDeque.descendingIterator();
                while (iterator.hasNext() && iterator.next() > value) {
                    iterator.remove();
                }
                this.minDeque.addLast(value);
            }
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            if (this.minDeque != null) {
                this.minDeque.removeFirstOccurrence(data);
                this.minValue = this.minDeque.peekFirst();
            } else if (this.minValue != null && this.minValue.equals(data)) {
                this.minValue = null;
            }
            return this.minValue;
        }

        @Override
        public synchronized Object reset() {
            if (this.minDeque != null) {
                this.minDeque.clear();
            }
            this.minValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return (this.minDeque == null || this.minDeque.size() == 0) && this.minValue == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            MinAttributeAggregatorDouble minAttributeAggregatorDouble = this;
            synchronized (minAttributeAggregatorDouble) {
                state.put("MinValue", this.minValue);
                state.put("MinDeque", this.minDeque);
            }
            return state;
        }

        @Override
        public synchronized void restoreState(Map<String, Object> state) {
            this.minValue = (Double)state.get("MinValue");
            this.minDeque = (Deque)state.get("MinDeque");
        }

        @Override
        protected Object currentValue() {
            return this.minValue;
        }
    }
}

