/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.processor.executor;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import io.siddhi.core.util.snapshot.Snapshotable;
import io.siddhi.query.api.definition.Attribute;

public abstract class AbstractAggregationAttributeExecutor
implements ExpressionExecutor,
Snapshotable {
    protected AttributeAggregator attributeAggregator;
    protected ExpressionExecutor[] attributeExpressionExecutors;
    protected SiddhiQueryContext siddhiQueryContext;
    protected int size;
    private String elementId = null;

    public AbstractAggregationAttributeExecutor(AttributeAggregator attributeAggregator, ExpressionExecutor[] attributeExpressionExecutors, SiddhiQueryContext siddhiQueryContext) {
        this.siddhiQueryContext = siddhiQueryContext;
        this.attributeExpressionExecutors = attributeExpressionExecutors;
        this.attributeAggregator = attributeAggregator;
        this.size = attributeExpressionExecutors.length;
        if (this.elementId == null) {
            this.elementId = "AbstractAggregationAttributeExecutor-" + this.siddhiQueryContext.getSiddhiAppContext().getElementIdGenerator().createNewId();
        }
        this.siddhiQueryContext.getSiddhiAppContext().getSnapshotService().addSnapshotable(siddhiQueryContext.getName(), this);
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.attributeAggregator.getReturnType();
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public void clean() {
        for (ExpressionExecutor expressionExecutor : this.attributeExpressionExecutors) {
            expressionExecutor.clean();
        }
        this.attributeAggregator.clean();
        this.siddhiQueryContext.getSiddhiAppContext().getSnapshotService().removeSnapshotable(this.siddhiQueryContext.getName(), this);
    }
}

