/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.processor.executor;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import io.siddhi.core.query.selector.attribute.processor.executor.AbstractAggregationAttributeExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.timestamp.TimestampGenerator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GroupByAggregationAttributeExecutor
extends AbstractAggregationAttributeExecutor {
    private static final ThreadLocal<String> keyThreadLocal = new ThreadLocal();
    private final ConfigReader configReader;
    private final TimestampGenerator timestampGenerator;
    protected Map<String, AttributeAggregator> aggregatorMap = new HashMap<String, AttributeAggregator>();
    protected Set<String> obsoleteAggregatorKeys = new HashSet<String>();
    protected long lastCleanupTimestamp = 0L;

    public GroupByAggregationAttributeExecutor(AttributeAggregator attributeAggregator, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        super(attributeAggregator, attributeExpressionExecutors, siddhiQueryContext);
        this.configReader = configReader;
        this.timestampGenerator = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator();
        this.lastCleanupTimestamp = this.timestampGenerator.currentTime();
    }

    public static ThreadLocal<String> getKeyThreadLocal() {
        return keyThreadLocal;
    }

    @Override
    public Object execute(ComplexEvent event) {
        long currentTime = this.timestampGenerator.currentTime();
        boolean canClean = false;
        if (this.lastCleanupTimestamp + 5000L < currentTime || this.obsoleteAggregatorKeys.size() > 25) {
            this.lastCleanupTimestamp = currentTime;
            canClean = true;
        }
        if (event.getType() == ComplexEvent.Type.RESET) {
            Object aOutput = null;
            if (canClean) {
                for (Map.Entry<String, AttributeAggregator> attributeAggregatorEntry : this.aggregatorMap.entrySet()) {
                    aOutput = attributeAggregatorEntry.getValue().process(event);
                    attributeAggregatorEntry.getValue().clean();
                }
                this.aggregatorMap.clear();
                this.obsoleteAggregatorKeys.clear();
            } else {
                for (Map.Entry<String, AttributeAggregator> attributeAggregatorEntry : this.aggregatorMap.entrySet()) {
                    aOutput = attributeAggregatorEntry.getValue().process(event);
                }
            }
            return aOutput;
        }
        String key = keyThreadLocal.get();
        AttributeAggregator currentAttributeAggregator = this.aggregatorMap.get(key);
        if (currentAttributeAggregator == null) {
            currentAttributeAggregator = this.attributeAggregator.cloneAggregator(key);
            this.aggregatorMap.put(key, currentAttributeAggregator);
        }
        Object results = currentAttributeAggregator.process(event);
        if (event.getType() == ComplexEvent.Type.EXPIRED && currentAttributeAggregator.canDestroy()) {
            this.obsoleteAggregatorKeys.add(key);
        }
        if (canClean) {
            this.destroyObsoleteAggregators();
        }
        return results;
    }

    @Override
    public ExpressionExecutor cloneExecutor(String key) {
        return new GroupByAggregationAttributeExecutor(this.attributeAggregator.cloneAggregator(key), this.attributeExpressionExecutors, this.configReader, this.siddhiQueryContext);
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        for (Map.Entry<String, AttributeAggregator> entry : this.aggregatorMap.entrySet()) {
            state.put(entry.getKey(), entry.getValue().currentState());
        }
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        for (Map.Entry<String, Object> item : state.entrySet()) {
            String key = item.getKey();
            AttributeAggregator aAttributeAggregator = this.attributeAggregator.cloneAggregator(key);
            aAttributeAggregator.restoreState((Map)item.getValue());
            this.aggregatorMap.put(key, aAttributeAggregator);
        }
    }

    private void destroyObsoleteAggregators() {
        for (String obsoleteKey : this.obsoleteAggregatorKeys) {
            AttributeAggregator attributeAggregator = this.aggregatorMap.get(obsoleteKey);
            if (attributeAggregator == null || !attributeAggregator.canDestroy()) continue;
            attributeAggregator.clean();
            this.aggregatorMap.remove(obsoleteKey);
        }
        this.obsoleteAggregatorKeys.clear();
    }
}

