/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.stream.output.sink;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.stream.output.sink.Sink;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.transport.DynamicOptions;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.query.api.definition.StreamDefinition;
import java.util.Arrays;
import java.util.Map;
import org.apache.log4j.Logger;

@Extension(name="log", namespace="sink", description="This is a sink that can be used as a logger. This will log the output events in the output stream with user specified priority and a prefix", parameters={@Parameter(name="priority", type={DataType.STRING}, description="This will set the logger priority i.e log level. Accepted values are INFO, DEBUG, WARN, FATAL, ERROR, OFF, TRACE", optional=true, defaultValue="INFO"), @Parameter(name="prefix", type={DataType.STRING}, description="This will be the prefix to the output message. If the output stream has event [2,4] and the prefix is given as \"Hello\" then the log will show \"Hello : [2,4]\"", optional=true, defaultValue="default prefix will be <Siddhi App Name> : <Stream Name>")}, examples={@Example(syntax="@sink(type='log', prefix='My Log', priority='DEBUG') \ndefine stream BarStream (symbol string, price float, volume long)", description="In this example BarStream uses log sink and the prefix is given as My Log. Also the priority is set to DEBUG."), @Example(syntax="@sink(type='log', priority='DEBUG') \ndefine stream BarStream (symbol string, price float, volume long)", description="In this example BarStream uses log sink and the priority is set to DEBUG. User has not specified prefix so the default prefix will be in the form <Siddhi App Name> : <Stream Name>"), @Example(syntax="@sink(type='log', prefix='My Log') \ndefine stream BarStream (symbol string, price float, volume long)", description="In this example BarStream uses log sink and the prefix is given as My Log. User has not given a priority so it will be set to default INFO."), @Example(syntax="@sink(type='log') \ndefine stream BarStream (symbol string, price float, volume long)", description="In this example BarStream uses log sink. The user has not given prefix or priority so they will be set to their default values.")})
public class LogSink
extends Sink {
    private static final Logger logger = Logger.getLogger(LogSink.class);
    private static final String PREFIX = "prefix";
    private static final String PRIORITY = "priority";
    private String logPrefix;
    private LogPriority logPriority;

    @Override
    public Class[] getSupportedInputEventClasses() {
        return new Class[]{Object.class};
    }

    @Override
    public String[] getSupportedDynamicOptions() {
        return new String[0];
    }

    @Override
    protected void init(StreamDefinition outputStreamDefinition, OptionHolder optionHolder, ConfigReader sinkConfigReader, SiddhiAppContext siddhiAppContext) {
        String defaultPrefix = siddhiAppContext.getName() + " : " + outputStreamDefinition.getId();
        this.logPrefix = optionHolder.validateAndGetStaticValue(PREFIX, defaultPrefix);
        this.logPriority = LogPriority.valueOf(optionHolder.validateAndGetStaticValue(PRIORITY, "INFO").toUpperCase());
    }

    @Override
    public void publish(Object payload, DynamicOptions transportOptions) throws ConnectionUnavailableException {
        String message = payload instanceof Object[] ? this.logPrefix + " : " + Arrays.deepToString((Object[])payload) : this.logPrefix + " : " + payload;
        this.logMessage(this.logPriority, message);
    }

    private void logMessage(LogPriority logPriority, String message) {
        switch (logPriority) {
            case INFO: {
                logger.info((Object)message);
                break;
            }
            case DEBUG: {
                logger.debug((Object)message);
                break;
            }
            case WARN: {
                logger.warn((Object)message);
                break;
            }
            case FATAL: {
                logger.fatal((Object)message);
                break;
            }
            case ERROR: {
                logger.error((Object)message);
                break;
            }
            case OFF: {
                break;
            }
            case TRACE: {
                logger.trace((Object)message);
            }
        }
    }

    @Override
    public void connect() throws ConnectionUnavailableException {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public Map<String, Object> currentState() {
        return null;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
    }

    private static enum LogPriority {
        INFO,
        DEBUG,
        WARN,
        FATAL,
        ERROR,
        OFF,
        TRACE;

    }
}

