/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.table;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.StreamEventPool;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.table.CompiledUpdateSet;
import io.siddhi.core.table.InMemoryCompiledUpdateSet;
import io.siddhi.core.table.Table;
import io.siddhi.core.table.holder.EventHolder;
import io.siddhi.core.table.record.RecordTableHandler;
import io.siddhi.core.util.collection.AddingStreamEventExtractor;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.collection.operator.Operator;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.parser.EventHolderPasser;
import io.siddhi.core.util.parser.ExpressionParser;
import io.siddhi.core.util.parser.OperatorParser;
import io.siddhi.core.util.snapshot.Snapshotable;
import io.siddhi.core.util.snapshot.state.SnapshotStateList;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.execution.query.output.stream.UpdateSet;
import io.siddhi.query.api.expression.Expression;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class InMemoryTable
extends Table
implements Snapshotable {
    private TableDefinition tableDefinition;
    private StreamEventCloner tableStreamEventCloner;
    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private EventHolder eventHolder;
    private String elementId;
    private SiddhiAppContext siddhiAppContext;

    @Override
    public void init(TableDefinition tableDefinition, StreamEventPool storeEventPool, StreamEventCloner storeEventCloner, ConfigReader configReader, SiddhiAppContext siddhiAppContext, RecordTableHandler recordTableHandler) {
        this.tableDefinition = tableDefinition;
        this.tableStreamEventCloner = storeEventCloner;
        this.siddhiAppContext = siddhiAppContext;
        this.eventHolder = EventHolderPasser.parse((AbstractDefinition)tableDefinition, storeEventPool, siddhiAppContext);
        if (this.elementId == null) {
            this.elementId = "InMemoryTable-" + siddhiAppContext.getElementIdGenerator().createNewId();
        }
        siddhiAppContext.getSnapshotService().addSnapshotable(tableDefinition.getId(), this);
    }

    @Override
    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    @Override
    public void add(ComplexEventChunk<StreamEvent> addingEventChunk) {
        try {
            this.readWriteLock.writeLock().lock();
            this.eventHolder.add(addingEventChunk);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void delete(ComplexEventChunk<StateEvent> deletingEventChunk, CompiledCondition compiledCondition) {
        try {
            this.readWriteLock.writeLock().lock();
            ((Operator)compiledCondition).delete(deletingEventChunk, this.eventHolder);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ComplexEventChunk<StateEvent> updatingEventChunk, CompiledCondition compiledCondition, CompiledUpdateSet compiledUpdateSet) {
        try {
            this.readWriteLock.writeLock().lock();
            ((Operator)compiledCondition).update(updatingEventChunk, this.eventHolder, (InMemoryCompiledUpdateSet)compiledUpdateSet);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateOrAdd(ComplexEventChunk<StateEvent> updateOrAddingEventChunk, CompiledCondition compiledCondition, CompiledUpdateSet compiledUpdateSet, AddingStreamEventExtractor addingStreamEventExtractor) {
        try {
            this.readWriteLock.writeLock().lock();
            ComplexEventChunk<StreamEvent> failedEvents = ((Operator)compiledCondition).tryUpdate(updateOrAddingEventChunk, this.eventHolder, (InMemoryCompiledUpdateSet)compiledUpdateSet, addingStreamEventExtractor);
            if (failedEvents != null) {
                this.eventHolder.add(failedEvents);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        try {
            this.readWriteLock.readLock().lock();
            boolean bl = ((Operator)compiledCondition).contains(matchingEvent, this.eventHolder);
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    protected void connect() throws ConnectionUnavailableException {
    }

    @Override
    protected void disconnect() {
    }

    @Override
    protected void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamEvent find(CompiledCondition compiledCondition, StateEvent matchingEvent) {
        try {
            this.readWriteLock.readLock().lock();
            StreamEvent streamEvent = ((Operator)compiledCondition).find(matchingEvent, this.eventHolder, this.tableStreamEventCloner);
            return streamEvent;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, SiddhiQueryContext siddhiQueryContext) {
        return OperatorParser.constructOperator(this.eventHolder, condition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
    }

    @Override
    public CompiledUpdateSet compileUpdateSet(UpdateSet updateSet, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, SiddhiQueryContext siddhiQueryContext) {
        HashMap<Integer, ExpressionExecutor> expressionExecutorMap = new HashMap<Integer, ExpressionExecutor>();
        for (UpdateSet.SetAttribute setAttribute : updateSet.getSetAttributeList()) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(setAttribute.getAssignmentExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            int attributePosition = this.tableDefinition.getAttributePosition(setAttribute.getTableVariable().getAttributeName());
            expressionExecutorMap.put(attributePosition, expressionExecutor);
        }
        return new InMemoryCompiledUpdateSet(expressionExecutorMap);
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("EventHolder", this.eventHolder.getSnapshot());
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.eventHolder.restore((SnapshotStateList)state.get("EventHolder"));
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public void clean() {
        this.siddhiAppContext.getSnapshotService().removeSnapshotable(this.tableDefinition.getId(), this);
    }
}

