/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.table.record;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.stream.window.QueryableProcessor;
import io.siddhi.core.table.Table;
import io.siddhi.core.table.record.AbstractRecordTable;
import io.siddhi.core.table.record.ExpressionBuilder;
import io.siddhi.core.table.record.RecordIterator;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.CompiledSelection;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.parser.ExpressionParser;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.execution.query.selection.OrderByAttribute;
import io.siddhi.query.api.execution.query.selection.OutputAttribute;
import io.siddhi.query.api.execution.query.selection.Selector;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractQueryableRecordTable
extends AbstractRecordTable
implements QueryableProcessor {
    private static final Logger log = Logger.getLogger(AbstractQueryableRecordTable.class);

    @Override
    public StreamEvent query(StateEvent matchingEvent, CompiledCondition compiledCondition, CompiledSelection compiledSelection) throws ConnectionUnavailableException {
        return this.query(matchingEvent, compiledCondition, compiledSelection, null);
    }

    @Override
    public StreamEvent query(StateEvent matchingEvent, CompiledCondition compiledCondition, CompiledSelection compiledSelection, Attribute[] outputAttributes) throws ConnectionUnavailableException {
        RecordStoreCompiledSelection recordStoreCompiledSelection = (RecordStoreCompiledSelection)compiledSelection;
        AbstractRecordTable.RecordStoreCompiledCondition recordStoreCompiledCondition = (AbstractRecordTable.RecordStoreCompiledCondition)compiledCondition;
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        for (Map.Entry<String, ExpressionExecutor> entry : recordStoreCompiledCondition.variableExpressionExecutorMap.entrySet()) {
            parameterMap.put(entry.getKey(), entry.getValue().execute(matchingEvent));
        }
        for (Map.Entry<String, ExpressionExecutor> entry : recordStoreCompiledSelection.variableExpressionExecutorMap.entrySet()) {
            parameterMap.put(entry.getKey(), entry.getValue().execute(matchingEvent));
        }
        Iterator<Object[]> records = this.recordTableHandler != null ? this.recordTableHandler.query(matchingEvent.getTimestamp(), parameterMap, recordStoreCompiledCondition.compiledCondition, recordStoreCompiledSelection.compiledSelection) : this.query(parameterMap, recordStoreCompiledCondition.compiledCondition, recordStoreCompiledSelection.compiledSelection, outputAttributes);
        ComplexEventChunk<StreamEvent> complexEventChunk = new ComplexEventChunk<StreamEvent>(true);
        if (records != null) {
            while (records.hasNext()) {
                Object[] record = records.next();
                StreamEvent streamEvent = this.storeEventPool.borrowEvent();
                streamEvent.setOutputData(new Object[outputAttributes.length]);
                System.arraycopy(record, 0, streamEvent.getOutputData(), 0, record.length);
                complexEventChunk.add(streamEvent);
            }
        }
        return (StreamEvent)complexEventChunk.getFirst();
    }

    protected abstract RecordIterator<Object[]> query(Map<String, Object> var1, CompiledCondition var2, CompiledSelection var3, Attribute[] var4) throws ConnectionUnavailableException;

    @Override
    public CompiledSelection compileSelection(Selector selector, List<Attribute> expectedOutputAttributes, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, SiddhiQueryContext siddhiQueryContext) {
        ExpressionExecutor expressionExecutor;
        List outputAttributes = selector.getSelectionList();
        if (outputAttributes.size() == 0) {
            MetaStreamEvent metaStreamEvent = matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvent(matchingMetaInfoHolder.getStoreEventIndex());
            List attributeList = metaStreamEvent.getLastInputDefinition().getAttributeList();
            Iterator iterator = attributeList.iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                outputAttributes.add(new OutputAttribute(new Variable(attribute.getName())));
            }
        }
        ArrayList<SelectAttributeBuilder> selectAttributeBuilders = new ArrayList<SelectAttributeBuilder>(outputAttributes.size());
        for (OutputAttribute outputAttribute : outputAttributes) {
            ExpressionBuilder expressionBuilder = new ExpressionBuilder(outputAttribute.getExpression(), matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
            selectAttributeBuilders.add(new SelectAttributeBuilder(expressionBuilder, outputAttribute.getRename()));
        }
        MatchingMetaInfoHolder metaInfoHolderAfterSelect = new MatchingMetaInfoHolder(matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getMatchingStreamEventIndex(), matchingMetaInfoHolder.getStoreEventIndex(), matchingMetaInfoHolder.getMatchingStreamDefinition(), matchingMetaInfoHolder.getMatchingStreamDefinition(), matchingMetaInfoHolder.getCurrentState());
        ArrayList<ExpressionBuilder> groupByExpressionBuilders = null;
        if (selector.getGroupByList().size() != 0) {
            groupByExpressionBuilders = new ArrayList<ExpressionBuilder>(outputAttributes.size());
            for (Variable variable : selector.getGroupByList()) {
                groupByExpressionBuilders.add(new ExpressionBuilder((Expression)variable, metaInfoHolderAfterSelect, variableExpressionExecutors, tableMap, siddhiQueryContext));
            }
        }
        ExpressionBuilder havingExpressionBuilder = null;
        if (selector.getHavingExpression() != null) {
            havingExpressionBuilder = new ExpressionBuilder(selector.getHavingExpression(), metaInfoHolderAfterSelect, variableExpressionExecutors, tableMap, siddhiQueryContext);
        }
        ArrayList<OrderByAttributeBuilder> orderByAttributeBuilders = null;
        if (selector.getOrderByList().size() != 0) {
            orderByAttributeBuilders = new ArrayList<OrderByAttributeBuilder>(selector.getOrderByList().size());
            for (OrderByAttribute orderByAttribute : selector.getOrderByList()) {
                ExpressionBuilder expressionBuilder = new ExpressionBuilder((Expression)orderByAttribute.getVariable(), metaInfoHolderAfterSelect, variableExpressionExecutors, tableMap, siddhiQueryContext);
                orderByAttributeBuilders.add(new OrderByAttributeBuilder(expressionBuilder, orderByAttribute.getOrder()));
            }
        }
        Long limit = null;
        Long offset = null;
        if (selector.getLimit() != null && (limit = Long.valueOf(((Number)((ConstantExpressionExecutor)(expressionExecutor = ExpressionParser.parseExpression((Expression)selector.getLimit(), metaInfoHolderAfterSelect.getMetaStateEvent(), -2, tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext))).getValue()).longValue())) < 0L) {
            throw new SiddhiAppCreationException("'limit' cannot have negative value, but found '" + limit + "'", (SiddhiElement)selector, siddhiQueryContext.getSiddhiAppContext());
        }
        if (selector.getOffset() != null && (offset = Long.valueOf(((Number)((ConstantExpressionExecutor)(expressionExecutor = ExpressionParser.parseExpression((Expression)selector.getOffset(), metaInfoHolderAfterSelect.getMetaStateEvent(), -2, tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext))).getValue()).longValue())) < 0L) {
            throw new SiddhiAppCreationException("'offset' cannot have negative value, but found '" + offset + "'", (SiddhiElement)selector, siddhiQueryContext.getSiddhiAppContext());
        }
        CompiledSelection compiledSelection = this.compileSelection(selectAttributeBuilders, groupByExpressionBuilders, havingExpressionBuilder, orderByAttributeBuilders, limit, offset);
        HashMap<String, ExpressionExecutor> expressionExecutorMap = new HashMap<String, ExpressionExecutor>();
        if (selectAttributeBuilders.size() != 0) {
            for (SelectAttributeBuilder selectAttributeBuilder : selectAttributeBuilders) {
                expressionExecutorMap.putAll(selectAttributeBuilder.getExpressionBuilder().getVariableExpressionExecutorMap());
            }
        }
        if (groupByExpressionBuilders != null && groupByExpressionBuilders.size() != 0) {
            for (ExpressionBuilder groupByExpressionBuilder : groupByExpressionBuilders) {
                expressionExecutorMap.putAll(groupByExpressionBuilder.getVariableExpressionExecutorMap());
            }
        }
        if (havingExpressionBuilder != null) {
            expressionExecutorMap.putAll(havingExpressionBuilder.getVariableExpressionExecutorMap());
        }
        if (orderByAttributeBuilders != null && orderByAttributeBuilders.size() != 0) {
            for (OrderByAttributeBuilder orderByAttributeBuilder : orderByAttributeBuilders) {
                expressionExecutorMap.putAll(orderByAttributeBuilder.getExpressionBuilder().getVariableExpressionExecutorMap());
            }
        }
        return new RecordStoreCompiledSelection(expressionExecutorMap, compiledSelection);
    }

    protected abstract CompiledSelection compileSelection(List<SelectAttributeBuilder> var1, List<ExpressionBuilder> var2, ExpressionBuilder var3, List<OrderByAttributeBuilder> var4, Long var5, Long var6);

    public class OrderByAttributeBuilder {
        private final ExpressionBuilder expressionBuilder;
        private final OrderByAttribute.Order order;

        public OrderByAttributeBuilder(ExpressionBuilder expressionBuilder, OrderByAttribute.Order order) {
            this.expressionBuilder = expressionBuilder;
            this.order = order;
        }

        public ExpressionBuilder getExpressionBuilder() {
            return this.expressionBuilder;
        }

        public OrderByAttribute.Order getOrder() {
            return this.order;
        }
    }

    public class SelectAttributeBuilder {
        private final ExpressionBuilder expressionBuilder;
        private final String rename;

        public SelectAttributeBuilder(ExpressionBuilder expressionBuilder, String rename) {
            this.expressionBuilder = expressionBuilder;
            this.rename = rename;
        }

        public ExpressionBuilder getExpressionBuilder() {
            return this.expressionBuilder;
        }

        public String getRename() {
            return this.rename;
        }
    }

    private class RecordStoreCompiledSelection
    implements CompiledSelection {
        private final Map<String, ExpressionExecutor> variableExpressionExecutorMap;
        private final CompiledSelection compiledSelection;

        RecordStoreCompiledSelection(Map<String, ExpressionExecutor> variableExpressionExecutorMap, CompiledSelection compiledSelection) {
            this.variableExpressionExecutorMap = variableExpressionExecutorMap;
            this.compiledSelection = compiledSelection;
        }

        @Override
        public CompiledSelection cloneCompilation(String key) {
            HashMap<String, ExpressionExecutor> newVariableExpressionExecutorMap = new HashMap<String, ExpressionExecutor>();
            for (Map.Entry<String, ExpressionExecutor> entry : this.variableExpressionExecutorMap.entrySet()) {
                newVariableExpressionExecutorMap.put(entry.getKey(), entry.getValue().cloneExecutor(key));
            }
            return new RecordStoreCompiledSelection(newVariableExpressionExecutorMap, this.compiledSelection);
        }
    }
}

