/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.table.record;

import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.table.record.RecordTableHandlerCallback;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.CompiledExpression;
import io.siddhi.core.util.collection.operator.CompiledSelection;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.TableDefinition;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class RecordTableHandler {
    private String elementId;
    private RecordTableHandlerCallback recordTableHandlerCallback;

    public String getElementId() {
        return this.elementId;
    }

    protected final void init(String elementId, TableDefinition tableDefinition, RecordTableHandlerCallback recordTableHandlerCallback) {
        this.elementId = elementId;
        this.recordTableHandlerCallback = recordTableHandlerCallback;
        this.init(elementId, tableDefinition);
    }

    public abstract void init(String var1, TableDefinition var2);

    public void add(long timestamp, List<Object[]> records) throws ConnectionUnavailableException {
        this.add(timestamp, records, this.recordTableHandlerCallback);
    }

    public abstract void add(long var1, List<Object[]> var3, RecordTableHandlerCallback var4) throws ConnectionUnavailableException;

    public void delete(long timestamp, List<Map<String, Object>> deleteConditionParameterMaps, CompiledCondition compiledCondition) throws ConnectionUnavailableException {
        this.delete(timestamp, deleteConditionParameterMaps, compiledCondition, this.recordTableHandlerCallback);
    }

    public abstract void delete(long var1, List<Map<String, Object>> var3, CompiledCondition var4, RecordTableHandlerCallback var5) throws ConnectionUnavailableException;

    public void update(long timestamp, CompiledCondition compiledCondition, List<Map<String, Object>> updateConditionParameterMaps, LinkedHashMap<String, CompiledExpression> updateSetMap, List<Map<String, Object>> updateSetParameterMaps) throws ConnectionUnavailableException {
        this.update(timestamp, compiledCondition, updateConditionParameterMaps, updateSetMap, updateSetParameterMaps, this.recordTableHandlerCallback);
    }

    public abstract void update(long var1, CompiledCondition var3, List<Map<String, Object>> var4, LinkedHashMap<String, CompiledExpression> var5, List<Map<String, Object>> var6, RecordTableHandlerCallback var7) throws ConnectionUnavailableException;

    public void updateOrAdd(long timestamp, CompiledCondition compiledCondition, List<Map<String, Object>> updateConditionParameterMaps, LinkedHashMap<String, CompiledExpression> updateSetMap, List<Map<String, Object>> updateSetParameterMaps, List<Object[]> addingRecords) throws ConnectionUnavailableException {
        this.updateOrAdd(timestamp, compiledCondition, updateConditionParameterMaps, updateSetMap, updateSetParameterMaps, addingRecords, this.recordTableHandlerCallback);
    }

    public abstract void updateOrAdd(long var1, CompiledCondition var3, List<Map<String, Object>> var4, LinkedHashMap<String, CompiledExpression> var5, List<Map<String, Object>> var6, List<Object[]> var7, RecordTableHandlerCallback var8) throws ConnectionUnavailableException;

    public Iterator<Object[]> find(long timestamp, Map<String, Object> findConditionParameterMap, CompiledCondition compiledCondition) throws ConnectionUnavailableException {
        return this.find(timestamp, findConditionParameterMap, compiledCondition, this.recordTableHandlerCallback);
    }

    public abstract Iterator<Object[]> find(long var1, Map<String, Object> var3, CompiledCondition var4, RecordTableHandlerCallback var5) throws ConnectionUnavailableException;

    public boolean contains(long timestamp, Map<String, Object> containsConditionParameterMap, CompiledCondition compiledCondition) throws ConnectionUnavailableException {
        return this.contains(timestamp, containsConditionParameterMap, compiledCondition, this.recordTableHandlerCallback);
    }

    public abstract boolean contains(long var1, Map<String, Object> var3, CompiledCondition var4, RecordTableHandlerCallback var5) throws ConnectionUnavailableException;

    @Deprecated
    public Iterator<Object[]> query(long timestamp, Map<String, Object> parameterMap, CompiledCondition compiledCondition, CompiledSelection compiledSelection) throws ConnectionUnavailableException {
        return this.query(timestamp, parameterMap, compiledCondition, compiledSelection, this.recordTableHandlerCallback);
    }

    public Iterator<Object[]> query(long timestamp, Map<String, Object> parameterMap, CompiledCondition compiledCondition, CompiledSelection compiledSelection, Attribute[] outputAttributes) throws ConnectionUnavailableException {
        return this.query(timestamp, parameterMap, compiledCondition, compiledSelection, outputAttributes, this.recordTableHandlerCallback);
    }

    @Deprecated
    public abstract Iterator<Object[]> query(long var1, Map<String, Object> var3, CompiledCondition var4, CompiledSelection var5, RecordTableHandlerCallback var6) throws ConnectionUnavailableException;

    public abstract Iterator<Object[]> query(long var1, Map<String, Object> var3, CompiledCondition var4, CompiledSelection var5, Attribute[] var6, RecordTableHandlerCallback var7) throws ConnectionUnavailableException;
}

