/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.collection.operator;

import io.siddhi.core.aggregation.IncrementalDataAggregator;
import io.siddhi.core.aggregation.IncrementalExecutor;
import io.siddhi.core.aggregation.IncrementalExternalTimestampDataAggregator;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.StreamEventPool;
import io.siddhi.core.event.stream.populater.ComplexEventPopulater;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.selector.GroupByKeyGenerator;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.collection.operator.Operator;
import io.siddhi.query.api.aggregation.TimePeriod;
import io.siddhi.query.api.definition.AggregationDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import io.siddhi.query.api.expression.Expression;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class IncrementalAggregateCompileCondition
implements CompiledCondition {
    private final StreamEventPool streamEventPoolForTableMeta;
    private final StreamEventCloner tableEventCloner;
    private final StreamEventPool streamEventPoolForAggregateMeta;
    private final StreamEventCloner aggregateEventCloner;
    private final List<Attribute> additionalAttributes;
    private Map<TimePeriod.Duration, CompiledCondition> withinTableCompiledConditions;
    private CompiledCondition inMemoryStoreCompileCondition;
    private CompiledCondition onCompiledCondition;
    private MetaStreamEvent tableMetaStreamEvent;
    private MetaStreamEvent aggregateMetaStreamEvent;
    private ComplexEventPopulater complexEventPopulater;
    private MatchingMetaInfoHolder alteredMatchingMetaInfoHolder;
    private ExpressionExecutor perExpressionExecutor;
    private ExpressionExecutor startTimeEndTimeExpressionExecutor;
    private boolean isProcessingOnExternalTime;

    public IncrementalAggregateCompileCondition(Map<TimePeriod.Duration, CompiledCondition> withinTableCompiledConditions, CompiledCondition inMemoryStoreCompileCondition, CompiledCondition onCompiledCondition, MetaStreamEvent tableMetaStreamEvent, MetaStreamEvent aggregateMetaSteamEvent, List<Attribute> additionalAttributes, MatchingMetaInfoHolder alteredMatchingMetaInfoHolder, ExpressionExecutor perExpressionExecutor, ExpressionExecutor startTimeEndTimeExpressionExecutor, boolean isProcessingOnExternalTime) {
        this.withinTableCompiledConditions = withinTableCompiledConditions;
        this.inMemoryStoreCompileCondition = inMemoryStoreCompileCondition;
        this.onCompiledCondition = onCompiledCondition;
        this.tableMetaStreamEvent = tableMetaStreamEvent;
        this.aggregateMetaStreamEvent = aggregateMetaSteamEvent;
        this.streamEventPoolForTableMeta = new StreamEventPool(tableMetaStreamEvent, 10);
        this.tableEventCloner = new StreamEventCloner(tableMetaStreamEvent, this.streamEventPoolForTableMeta);
        this.streamEventPoolForAggregateMeta = new StreamEventPool(aggregateMetaSteamEvent, 10);
        this.aggregateEventCloner = new StreamEventCloner(aggregateMetaSteamEvent, this.streamEventPoolForAggregateMeta);
        this.additionalAttributes = additionalAttributes;
        this.alteredMatchingMetaInfoHolder = alteredMatchingMetaInfoHolder;
        this.perExpressionExecutor = perExpressionExecutor;
        this.startTimeEndTimeExpressionExecutor = startTimeEndTimeExpressionExecutor;
        this.isProcessingOnExternalTime = isProcessingOnExternalTime;
    }

    @Override
    public CompiledCondition cloneCompilation(String key) {
        HashMap<TimePeriod.Duration, CompiledCondition> copyOfWithinTableCompiledConditions = new HashMap<TimePeriod.Duration, CompiledCondition>();
        for (Map.Entry<TimePeriod.Duration, CompiledCondition> entry : this.withinTableCompiledConditions.entrySet()) {
            copyOfWithinTableCompiledConditions.put(entry.getKey(), entry.getValue().cloneCompilation(key));
        }
        return new IncrementalAggregateCompileCondition(copyOfWithinTableCompiledConditions, this.inMemoryStoreCompileCondition.cloneCompilation(key), this.onCompiledCondition.cloneCompilation(key), this.tableMetaStreamEvent, this.aggregateMetaStreamEvent, this.additionalAttributes, this.alteredMatchingMetaInfoHolder, this.perExpressionExecutor, this.startTimeEndTimeExpressionExecutor, this.isProcessingOnExternalTime);
    }

    public StreamEvent find(StateEvent matchingEvent, AggregationDefinition aggregationDefinition, Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap, Map<TimePeriod.Duration, Table> aggregationTables, List<TimePeriod.Duration> incrementalDurations, List<ExpressionExecutor> baseExecutors, List<ExpressionExecutor> outputExpressionExecutors, SiddhiAppContext siddhiAppContext, List<List<ExpressionExecutor>> aggregateProcessingExecutorsList, List<GroupByKeyGenerator> groupbyKeyGeneratorList, ExpressionExecutor shouldUpdateExpressionExecutor, Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMapForPartitions) {
        ComplexEventChunk<StreamEvent> processedEvents;
        ExpressionExecutor shouldUpdateExpressionExecutorClone;
        TimePeriod.Duration perValue;
        ComplexEventChunk<StreamEvent> complexEventChunkToHoldWithinMatches = new ComplexEventChunk<StreamEvent>(true);
        String perValueAsString = this.perExpressionExecutor.execute(matchingEvent).toString();
        try {
            perValue = Expression.Time.normalizeDuration((String)perValueAsString);
        }
        catch (SiddhiAppValidationException e) {
            throw new SiddhiAppRuntimeException("Aggregation Query's per value is expected to be of a valid time function of the following " + TimePeriod.Duration.SECONDS + ", " + TimePeriod.Duration.MINUTES + ", " + TimePeriod.Duration.HOURS + ", " + TimePeriod.Duration.DAYS + ", " + TimePeriod.Duration.MONTHS + ", " + TimePeriod.Duration.YEARS + ".");
        }
        if (!incrementalExecutorMap.keySet().contains(perValue)) {
            throw new SiddhiAppRuntimeException("The aggregate values for " + perValue.toString() + " granularity cannot be provided since aggregation definition " + aggregationDefinition.getId() + " does not contain " + perValue.toString() + " duration");
        }
        Table tableForPerDuration = aggregationTables.get(perValue);
        Object[] startTimeEndTime = (Long[])this.startTimeEndTimeExpressionExecutor.execute(matchingEvent);
        if (startTimeEndTime == null) {
            throw new SiddhiAppRuntimeException("Start and end times for within duration cannot be retrieved");
        }
        this.complexEventPopulater.populateComplexEvent(matchingEvent.getStreamEvent(0), startTimeEndTime);
        StreamEvent withinMatchFromPersistedEvents = tableForPerDuration.find(matchingEvent, this.withinTableCompiledConditions.get(perValue));
        complexEventChunkToHoldWithinMatches.add(withinMatchFromPersistedEvents);
        long oldestInMemoryEventTimestamp = this.getOldestInMemoryEventTimestamp(incrementalExecutorMap, incrementalDurations, perValue);
        ExpressionExecutor expressionExecutor2 = shouldUpdateExpressionExecutorClone = shouldUpdateExpressionExecutor == null ? null : shouldUpdateExpressionExecutor.cloneExecutor(null);
        if (this.isProcessingOnExternalTime || this.requiresAggregatingInMemoryData(oldestInMemoryEventTimestamp, (Long[])startTimeEndTime)) {
            List<ExpressionExecutor> clonedBaseExecutors = baseExecutors.stream().map(expressionExecutor -> expressionExecutor.cloneExecutor("")).collect(Collectors.toList());
            IncrementalDataAggregator incrementalDataAggregator = new IncrementalDataAggregator(incrementalDurations, perValue, oldestInMemoryEventTimestamp, clonedBaseExecutors, this.tableMetaStreamEvent, siddhiAppContext, shouldUpdateExpressionExecutorClone);
            ComplexEventChunk<StreamEvent> aggregatedInMemoryEventChunk = incrementalExecutorMapForPartitions != null ? incrementalDataAggregator.aggregateInMemoryData(incrementalExecutorMapForPartitions) : incrementalDataAggregator.aggregateInMemoryData(incrementalExecutorMap);
            StreamEvent withinMatchFromInMemory = ((Operator)this.inMemoryStoreCompileCondition).find(matchingEvent, aggregatedInMemoryEventChunk, this.tableEventCloner);
            complexEventChunkToHoldWithinMatches.add(withinMatchFromInMemory);
        }
        if (this.isProcessingOnExternalTime) {
            int durationIndex = incrementalDurations.indexOf(perValue);
            List<ExpressionExecutor> expressionExecutors = aggregateProcessingExecutorsList.get(durationIndex);
            GroupByKeyGenerator groupByKeyGenerator = groupbyKeyGeneratorList.get(durationIndex);
            ExpressionExecutor shouldUpdateExpressionExecutorCloneExt = shouldUpdateExpressionExecutor == null ? null : shouldUpdateExpressionExecutor.cloneExecutor(null);
            IncrementalExternalTimestampDataAggregator incrementalExternalTimestampDataAggregator = new IncrementalExternalTimestampDataAggregator(expressionExecutors, groupByKeyGenerator, this.tableMetaStreamEvent, siddhiAppContext, shouldUpdateExpressionExecutorCloneExt);
            processedEvents = incrementalExternalTimestampDataAggregator.aggregateData(complexEventChunkToHoldWithinMatches);
        } else {
            processedEvents = complexEventChunkToHoldWithinMatches;
        }
        ComplexEventChunk<StreamEvent> aggregateSelectionComplexEventChunk = this.createAggregateSelectionEventChunk(processedEvents, outputExpressionExecutors);
        return ((Operator)this.onCompiledCondition).find(matchingEvent, aggregateSelectionComplexEventChunk, this.aggregateEventCloner);
    }

    private ComplexEventChunk<StreamEvent> createAggregateSelectionEventChunk(ComplexEventChunk<StreamEvent> complexEventChunkToHoldMatches, List<ExpressionExecutor> outputExpressionExecutors) {
        ComplexEventChunk<StreamEvent> aggregateSelectionComplexEventChunk = new ComplexEventChunk<StreamEvent>(true);
        StreamEvent resetEvent = this.streamEventPoolForTableMeta.borrowEvent();
        resetEvent.setType(ComplexEvent.Type.RESET);
        while (complexEventChunkToHoldMatches.hasNext()) {
            StreamEvent streamEvent = (StreamEvent)complexEventChunkToHoldMatches.next();
            StreamEvent newStreamEvent = this.streamEventPoolForAggregateMeta.borrowEvent();
            Object[] outputData = new Object[newStreamEvent.getOutputData().length];
            for (int i = 0; i < outputExpressionExecutors.size(); ++i) {
                outputData[i] = outputExpressionExecutors.get(i).execute(streamEvent);
            }
            newStreamEvent.setTimestamp(streamEvent.getTimestamp());
            newStreamEvent.setOutputData(outputData);
            aggregateSelectionComplexEventChunk.add(newStreamEvent);
        }
        for (ExpressionExecutor expressionExecutor : outputExpressionExecutors) {
            expressionExecutor.execute(resetEvent);
        }
        return aggregateSelectionComplexEventChunk;
    }

    private boolean requiresAggregatingInMemoryData(long oldestInMemoryEventTimestamp, Long[] startTimeEndTime) {
        if (oldestInMemoryEventTimestamp == -1L) {
            return false;
        }
        long endTimeForWithin = startTimeEndTime[1];
        return endTimeForWithin > oldestInMemoryEventTimestamp;
    }

    private long getOldestInMemoryEventTimestamp(Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap, List<TimePeriod.Duration> incrementalDurations, TimePeriod.Duration perValue) {
        for (int i = perValue.ordinal(); i >= incrementalDurations.get(0).ordinal(); --i) {
            long oldestEvent;
            TimePeriod.Duration incrementalDuration = TimePeriod.Duration.values()[i];
            if (!incrementalExecutorMap.containsKey(incrementalDuration) || (oldestEvent = incrementalExecutorMap.get(incrementalDuration).getAggregationStartTimestamp()) == -1L) continue;
            return oldestEvent;
        }
        return -1L;
    }

    public void setComplexEventPopulater(ComplexEventPopulater complexEventPopulater) {
        this.complexEventPopulater = complexEventPopulater;
    }

    public List<Attribute> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public MatchingMetaInfoHolder getAlteredMatchingMetaInfoHolder() {
        return this.alteredMatchingMetaInfoHolder;
    }
}

