/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.event.stream.converter;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.Event;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.event.stream.converter.StreamEventConverter;
import io.siddhi.core.event.stream.converter.StreamEventConverterFactory;

public class ConversionStreamEventChunk
extends ComplexEventChunk<StreamEvent> {
    private static final long serialVersionUID = 2754352338846132676L;
    private StreamEventConverter streamEventConverter;
    private StreamEventFactory streamEventFactory;

    public ConversionStreamEventChunk(MetaStreamEvent metaStreamEvent, StreamEventFactory streamEventFactory) {
        super(false);
        this.streamEventFactory = streamEventFactory;
        this.streamEventConverter = StreamEventConverterFactory.constructEventConverter(metaStreamEvent);
    }

    public ConversionStreamEventChunk(StreamEventConverter streamEventConverter, StreamEventFactory streamEventFactory) {
        super(false);
        this.streamEventConverter = streamEventConverter;
        this.streamEventFactory = streamEventFactory;
    }

    public void convertAndAssign(Event event) {
        StreamEvent newEvent = this.streamEventFactory.newInstance();
        this.streamEventConverter.convertEvent(event, newEvent);
        this.last = this.first = newEvent;
    }

    public void convertAndAssign(long timestamp, Object[] data) {
        StreamEvent newEvent = this.streamEventFactory.newInstance();
        this.streamEventConverter.convertData(timestamp, data, newEvent);
        this.last = this.first = newEvent;
    }

    public void convertAndAssign(ComplexEvent complexEvent) {
        this.first = this.streamEventFactory.newInstance();
        this.last = this.convertAllStreamEvents(complexEvent, (StreamEvent)this.first);
    }

    public void convertAndAssign(Event[] events) {
        StreamEvent firstEvent = this.streamEventFactory.newInstance();
        this.streamEventConverter.convertEvent(events[0], firstEvent);
        StreamEvent currentEvent = firstEvent;
        int eventsLength = events.length;
        for (int i = 1; i < eventsLength; ++i) {
            StreamEvent nextEvent = this.streamEventFactory.newInstance();
            this.streamEventConverter.convertEvent(events[i], nextEvent);
            currentEvent.setNext(nextEvent);
            currentEvent = nextEvent;
        }
        this.first = firstEvent;
        this.last = currentEvent;
    }

    public void convertAndAdd(Event event) {
        StreamEvent newEvent = this.streamEventFactory.newInstance();
        this.streamEventConverter.convertEvent(event, newEvent);
        if (this.first == null) {
            this.last = this.first = newEvent;
        } else {
            ((StreamEvent)this.last).setNext(newEvent);
            this.last = newEvent;
        }
    }

    private StreamEvent convertAllStreamEvents(ComplexEvent complexEvents, StreamEvent firstEvent) {
        this.streamEventConverter.convertComplexEvent(complexEvents, firstEvent);
        StreamEvent currentEvent = firstEvent;
        for (complexEvents = complexEvents.getNext(); complexEvents != null; complexEvents = complexEvents.getNext()) {
            StreamEvent nextEvent = this.streamEventFactory.newInstance();
            this.streamEventConverter.convertComplexEvent(complexEvents, nextEvent);
            currentEvent.setNext(nextEvent);
            currentEvent = nextEvent;
        }
        return currentEvent;
    }
}

