/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.condition;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.executor.condition.ConditionExpressionExecutor;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.collection.FinderStateEvent;
import io.siddhi.core.util.collection.operator.CompiledCondition;

public class InConditionExpressionExecutor
extends ConditionExpressionExecutor {
    private final int streamEventSize;
    private final boolean isMatchingEventAStateEvent;
    private final int matchingStreamIndex;
    private final CompiledCondition compiledCondition;
    private Table table;

    public InConditionExpressionExecutor(Table table, CompiledCondition compiledCondition, int streamEventSize, boolean isMatchingEventAStateEvent, int matchingStreamIndex) {
        this.streamEventSize = streamEventSize;
        this.isMatchingEventAStateEvent = isMatchingEventAStateEvent;
        this.matchingStreamIndex = matchingStreamIndex;
        this.table = table;
        this.compiledCondition = compiledCondition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean execute(ComplexEvent event) {
        FinderStateEvent finderStateEvent = new FinderStateEvent(this.streamEventSize, 0);
        try {
            if (this.isMatchingEventAStateEvent) {
                finderStateEvent.setEvent((StateEvent)event);
            } else {
                finderStateEvent.setEvent(this.matchingStreamIndex, (StreamEvent)event);
            }
            Boolean bl = this.table.containsEvent(finderStateEvent, this.compiledCondition);
            return bl;
        }
        finally {
            if (this.isMatchingEventAStateEvent) {
                finderStateEvent.setEvent(null);
            } else {
                finderStateEvent.setEvent(this.matchingStreamIndex, null);
            }
        }
    }
}

