/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.partition;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.Event;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.event.stream.converter.StreamEventConverter;
import io.siddhi.core.event.stream.converter.StreamEventConverterFactory;
import io.siddhi.core.partition.PartitionRuntime;
import io.siddhi.core.partition.executor.PartitionExecutor;
import io.siddhi.core.query.QueryRuntime;
import io.siddhi.core.query.input.stream.StreamRuntime;
import io.siddhi.core.stream.StreamJunction;
import io.siddhi.query.api.definition.StreamDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PartitionStreamReceiver
implements StreamJunction.Receiver {
    private final StreamEventFactory streamEventFactory;
    private StreamEventConverter streamEventConverter;
    private String streamId;
    private MetaStreamEvent metaStreamEvent;
    private StreamDefinition streamDefinition;
    private SiddhiAppContext siddhiAppContext;
    private PartitionRuntime partitionRuntime;
    private List<PartitionExecutor> partitionExecutors;
    private Map<String, StreamJunction> streamJunctionMap = new HashMap<String, StreamJunction>();

    public PartitionStreamReceiver(SiddhiAppContext siddhiAppContext, MetaStreamEvent metaStreamEvent, StreamDefinition streamDefinition, List<PartitionExecutor> partitionExecutors, PartitionRuntime partitionRuntime) {
        this.metaStreamEvent = metaStreamEvent;
        this.streamDefinition = streamDefinition;
        this.partitionRuntime = partitionRuntime;
        this.partitionExecutors = partitionExecutors;
        this.siddhiAppContext = siddhiAppContext;
        this.streamId = streamDefinition.getId();
        this.streamEventFactory = new StreamEventFactory(metaStreamEvent);
    }

    public void init() {
        this.streamEventConverter = StreamEventConverterFactory.constructEventConverter(this.metaStreamEvent);
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public void receive(ComplexEvent complexEvent) {
        if (this.partitionExecutors.size() == 0) {
            ComplexEventChunk<StreamEvent> outputEventChunk = new ComplexEventChunk<StreamEvent>(false);
            for (ComplexEvent aComplexEvent = complexEvent; aComplexEvent != null; aComplexEvent = aComplexEvent.getNext()) {
                StreamEvent newEvent = this.streamEventFactory.newInstance();
                this.streamEventConverter.convertComplexEvent(aComplexEvent, newEvent);
                outputEventChunk.add(newEvent);
            }
            this.send((ComplexEvent)outputEventChunk.getFirst());
        } else if (complexEvent.getNext() == null) {
            for (PartitionExecutor partitionExecutor : this.partitionExecutors) {
                StreamEvent newEvent = this.streamEventFactory.newInstance();
                this.streamEventConverter.convertComplexEvent(complexEvent, newEvent);
                String key = partitionExecutor.execute(newEvent);
                this.send(key, newEvent);
            }
        } else {
            ComplexEventChunk<ComplexEvent> complexEventChunk = new ComplexEventChunk<ComplexEvent>(false);
            complexEventChunk.add(complexEvent);
            ComplexEventChunk<StreamEvent> outputEventChunk = new ComplexEventChunk<StreamEvent>(false);
            String currentKey = null;
            while (complexEventChunk.hasNext()) {
                Object aEvent = complexEventChunk.next();
                complexEventChunk.remove();
                StreamEvent newEvent = this.streamEventFactory.newInstance();
                this.streamEventConverter.convertComplexEvent((ComplexEvent)aEvent, newEvent);
                boolean currentEventMatchedPrevPartitionExecutor = false;
                for (PartitionExecutor partitionExecutor : this.partitionExecutors) {
                    String key = partitionExecutor.execute(newEvent);
                    if (key == null) continue;
                    if (currentKey == null) {
                        currentKey = key;
                    } else if (!currentKey.equals(key)) {
                        Object firstEvent;
                        if (!currentEventMatchedPrevPartitionExecutor) {
                            firstEvent = outputEventChunk.getFirst();
                            this.send(currentKey, (ComplexEvent)firstEvent);
                            currentKey = key;
                            outputEventChunk.clear();
                        } else {
                            firstEvent = outputEventChunk.getFirst();
                            this.send(currentKey, (ComplexEvent)firstEvent);
                            currentKey = key;
                            outputEventChunk.clear();
                            StreamEvent cloneEvent = this.streamEventFactory.newInstance();
                            this.streamEventConverter.convertComplexEvent((ComplexEvent)aEvent, cloneEvent);
                            outputEventChunk.add(cloneEvent);
                        }
                    }
                    if (!currentEventMatchedPrevPartitionExecutor) {
                        outputEventChunk.add(newEvent);
                    }
                    currentEventMatchedPrevPartitionExecutor = true;
                }
            }
            this.send(currentKey, (ComplexEvent)outputEventChunk.getFirst());
            outputEventChunk.clear();
        }
    }

    @Override
    public void receive(Event event) {
        StreamEvent newEvent = this.streamEventFactory.newInstance();
        this.streamEventConverter.convertEvent(event, newEvent);
        for (PartitionExecutor partitionExecutor : this.partitionExecutors) {
            String key = partitionExecutor.execute(newEvent);
            this.send(key, newEvent);
        }
        if (this.partitionExecutors.size() == 0) {
            this.send(newEvent);
        }
    }

    @Override
    public void receive(long timestamp, Object[] data) {
        StreamEvent newEvent = this.streamEventFactory.newInstance();
        this.streamEventConverter.convertData(timestamp, data, newEvent);
        if (this.partitionExecutors.size() == 0) {
            this.send(newEvent);
        } else {
            for (PartitionExecutor partitionExecutor : this.partitionExecutors) {
                String key = partitionExecutor.execute(newEvent);
                this.send(key, newEvent);
            }
        }
    }

    @Override
    public void receive(Event[] events) {
        if (this.partitionExecutors.size() == 0) {
            StreamEvent firstEvent = this.streamEventFactory.newInstance();
            this.streamEventConverter.convertEvent(events[0], firstEvent);
            StreamEvent currentEvent = firstEvent;
            for (int i = 1; i < events.length; ++i) {
                StreamEvent nextEvent = this.streamEventFactory.newInstance();
                this.streamEventConverter.convertEvent(events[i], nextEvent);
                currentEvent.setNext(nextEvent);
                currentEvent = nextEvent;
            }
            this.send(firstEvent);
        } else {
            String key = null;
            StreamEvent firstEvent = null;
            StreamEvent currentEvent = null;
            for (Event event : events) {
                StreamEvent nextEvent = this.streamEventFactory.newInstance();
                this.streamEventConverter.convertEvent(event, nextEvent);
                for (PartitionExecutor partitionExecutor : this.partitionExecutors) {
                    String currentKey = partitionExecutor.execute(nextEvent);
                    if (currentKey == null) continue;
                    if (key == null) {
                        key = currentKey;
                        firstEvent = nextEvent;
                    } else if (!currentKey.equals(key)) {
                        this.send(key, firstEvent);
                        key = currentKey;
                        firstEvent = nextEvent;
                    } else {
                        currentEvent.setNext(nextEvent);
                    }
                    currentEvent = nextEvent;
                }
            }
            this.send(key, firstEvent);
        }
    }

    @Override
    public void receive(List<Event> events) {
        if (this.partitionExecutors.size() == 0) {
            StreamEvent firstEvent = null;
            StreamEvent currentEvent = null;
            for (Event event : events) {
                StreamEvent nextEvent = this.streamEventFactory.newInstance();
                this.streamEventConverter.convertEvent(event, nextEvent);
                if (firstEvent == null) {
                    firstEvent = nextEvent;
                } else {
                    currentEvent.setNext(nextEvent);
                }
                currentEvent = nextEvent;
            }
            this.send(firstEvent);
        } else {
            String key = null;
            StreamEvent firstEvent = null;
            StreamEvent currentEvent = null;
            for (Event event : events) {
                StreamEvent nextEvent = this.streamEventFactory.newInstance();
                this.streamEventConverter.convertEvent(event, nextEvent);
                for (PartitionExecutor partitionExecutor : this.partitionExecutors) {
                    String currentKey = partitionExecutor.execute(nextEvent);
                    if (currentKey == null) continue;
                    if (key == null) {
                        key = currentKey;
                        firstEvent = nextEvent;
                    } else if (!currentKey.equals(key)) {
                        this.send(key, firstEvent);
                        key = currentKey;
                        firstEvent = nextEvent;
                    } else {
                        currentEvent.setNext(nextEvent);
                    }
                    currentEvent = nextEvent;
                }
            }
            this.send(key, firstEvent);
        }
    }

    private void send(String key, ComplexEvent event) {
        if (key != null) {
            SiddhiAppContext.startPartitionFlow(key);
            try {
                this.partitionRuntime.initPartition();
                this.streamJunctionMap.get(this.streamId).sendEvent(event);
            }
            finally {
                SiddhiAppContext.stopPartitionFlow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(ComplexEvent event) {
        for (String key : this.partitionRuntime.getPartitionKeys()) {
            SiddhiAppContext.startPartitionFlow(key);
            try {
                this.streamJunctionMap.get(this.streamId).sendEvent(event);
            }
            finally {
                SiddhiAppContext.stopPartitionFlow();
            }
        }
    }

    public void addStreamJunction(List<QueryRuntime> queryRuntimeList) {
        StreamJunction streamJunction = this.streamJunctionMap.get(this.streamId);
        if (streamJunction == null) {
            streamJunction = (StreamJunction)this.partitionRuntime.getInnerPartitionStreamReceiverStreamJunctionMap().get(this.streamId);
            if (streamJunction == null) {
                streamJunction = this.createStreamJunction();
                this.partitionRuntime.addInnerpartitionStreamReceiverStreamJunction(this.streamId, streamJunction);
            }
            this.streamJunctionMap.put(this.streamId, streamJunction);
        }
        for (QueryRuntime queryRuntime : queryRuntimeList) {
            StreamRuntime streamRuntime = queryRuntime.getStreamRuntime();
            for (int i = 0; i < queryRuntime.getInputStreamId().size(); ++i) {
                if (!streamRuntime.getSingleStreamRuntimes().get(i).getProcessStreamReceiver().getStreamId().equals(this.streamId)) continue;
                streamJunction.subscribe(streamRuntime.getSingleStreamRuntimes().get(i).getProcessStreamReceiver());
            }
        }
    }

    private StreamJunction createStreamJunction() {
        return new StreamJunction(this.streamDefinition, this.siddhiAppContext.getExecutorService(), this.siddhiAppContext.getBufferSize(), null, this.siddhiAppContext);
    }
}

