/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregatorExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@Extension(name="minForever", namespace="", description="This is the attribute aggregator to store the minimum value for a given attribute throughout the lifetime of the query regardless of any windows in-front.", parameters={@Parameter(name="arg", description="The value that needs to be compared to find the minimum value.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, returnAttributes={@ReturnAttribute(description="Returns the minimum value in the same data type as the input.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, examples={@Example(syntax="from inputStream\nselect minForever(temp) as max\ninsert into outputStream;", description="minForever(temp) returns the minimum temp value recorded for all the events throughoutthe lifetime of the query.")})
public class MinForeverAttributeAggregatorExecutor
extends AttributeAggregatorExecutor<MinAggregatorState> {
    private Attribute.Type returnType;

    @Override
    protected StateFactory<MinAggregatorState> init(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("MinForever aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        this.returnType = attributeExpressionExecutors[0].getReturnType();
        return new StateFactory<MinAggregatorState>(){

            @Override
            public MinAggregatorState createNewState() {
                switch (MinForeverAttributeAggregatorExecutor.this.returnType) {
                    case FLOAT: {
                        return new MinForeverAttributeAggregatorStateFloat();
                    }
                    case INT: {
                        return new MinForeverAttributeAggregatorStateInt();
                    }
                    case LONG: {
                        return new MinForeverAttributeAggregatorStateLong();
                    }
                    case DOUBLE: {
                        return new MinForeverAttributeAggregatorStateDouble();
                    }
                }
                throw new OperationNotSupportedException("MinForever not supported for " + MinForeverAttributeAggregatorExecutor.this.returnType);
            }
        };
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Object processAdd(Object data, MinAggregatorState state) {
        if (data == null) {
            return state.currentValue();
        }
        return state.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data, MinAggregatorState state) {
        return new IllegalStateException("MinForever cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data, MinAggregatorState state) {
        if (data == null) {
            return state.currentValue();
        }
        return state.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data, MinAggregatorState state) {
        return new IllegalStateException("MinForever cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset(MinAggregatorState state) {
        return state.reset();
    }

    abstract class MinAggregatorState
    extends State {
        MinAggregatorState() {
        }

        public abstract Object processAdd(Object var1);

        public abstract Object processRemove(Object var1);

        public abstract Object reset();

        protected abstract Object currentValue();
    }

    class MinForeverAttributeAggregatorStateLong
    extends MinAggregatorState {
        private final Attribute.Type type = Attribute.Type.LONG;
        private volatile Long minValue = null;

        MinForeverAttributeAggregatorStateLong() {
        }

        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            Long value = (Long)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            return this.minValue;
        }

        @Override
        public Object processRemove(Object data) {
            Long value = (Long)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public boolean canDestroy() {
            return this.minValue == null;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MinValue", this.minValue);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.minValue = (Long)state.get("MinValue");
        }

        @Override
        protected Object currentValue() {
            return this.minValue;
        }
    }

    class MinForeverAttributeAggregatorStateInt
    extends MinAggregatorState {
        private final Attribute.Type type = Attribute.Type.INT;
        private volatile Integer minValue = null;

        MinForeverAttributeAggregatorStateInt() {
        }

        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            Integer value = (Integer)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            return this.minValue;
        }

        @Override
        public Object processRemove(Object data) {
            Integer value = (Integer)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MinValue", this.minValue);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.minValue = (Integer)state.get("MinValue");
        }

        @Override
        protected Object currentValue() {
            return this.minValue;
        }

        @Override
        public boolean canDestroy() {
            return this.minValue == null;
        }
    }

    class MinForeverAttributeAggregatorStateFloat
    extends MinAggregatorState {
        private final Attribute.Type type = Attribute.Type.FLOAT;
        private volatile Float minValue = null;

        MinForeverAttributeAggregatorStateFloat() {
        }

        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            Float value = (Float)data;
            if (this.minValue == null || this.minValue.floatValue() > value.floatValue()) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object processRemove(Object data) {
            Float value = (Float)data;
            if (this.minValue == null || this.minValue.floatValue() > value.floatValue()) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            return this.minValue;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MinValue", this.minValue);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.minValue = (Float)state.get("MinValue");
        }

        @Override
        protected Object currentValue() {
            return this.minValue;
        }

        @Override
        public boolean canDestroy() {
            return this.minValue == null;
        }
    }

    class MinForeverAttributeAggregatorStateDouble
    extends MinAggregatorState {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private volatile Double minValue = null;

        MinForeverAttributeAggregatorStateDouble() {
        }

        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            Double value = (Double)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object processRemove(Object data) {
            Double value = (Double)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            return this.minValue;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MinValue", this.minValue);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.minValue = (Double)state.get("MinValue");
        }

        @Override
        protected Object currentValue() {
            return this.minValue;
        }

        @Override
        public boolean canDestroy() {
            return this.minValue == null;
        }
    }
}

