/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.stream.input.source;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.stream.input.InputHandler;
import io.siddhi.core.stream.input.source.AttributeMapping;
import io.siddhi.core.stream.input.source.InputEventHandler;
import io.siddhi.core.stream.input.source.InputEventHandlerCallback;
import io.siddhi.core.stream.input.source.PassThroughSourceHandler;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.core.stream.input.source.SourceHandler;
import io.siddhi.core.stream.input.source.SourceSyncCallback;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.core.util.statistics.LatencyTracker;
import io.siddhi.core.util.statistics.ThroughputTracker;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.query.api.definition.StreamDefinition;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class SourceMapper
implements SourceEventListener {
    private static final Logger log = Logger.getLogger(SourceMapper.class);
    private final ThreadLocal<String[]> trpProperties = new ThreadLocal();
    private final ThreadLocal<String[]> trpSyncProperties = new ThreadLocal();
    private InputEventHandler inputEventHandler;
    private StreamDefinition streamDefinition;
    private String mapType;
    private String sourceType;
    private List<AttributeMapping> transportMappings;
    private SourceHandler sourceHandler;
    private SiddhiAppContext siddhiAppContext;
    private ThroughputTracker throughputTracker;
    private LatencyTracker mapperLatencyTracker;

    public final void init(StreamDefinition streamDefinition, String mapType, OptionHolder mapOptionHolder, List<AttributeMapping> attributeMappings, String sourceType, SourceSyncCallback sourceSyncCallback, List<AttributeMapping> transportMappings, SourceHandler sourceHandler, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        this.streamDefinition = streamDefinition;
        this.mapType = mapType;
        this.sourceType = sourceType;
        this.transportMappings = transportMappings;
        if (sourceHandler != null) {
            sourceHandler.initSourceHandler(siddhiAppContext.getName(), sourceSyncCallback, streamDefinition, siddhiAppContext);
        }
        this.sourceHandler = sourceHandler;
        this.siddhiAppContext = siddhiAppContext;
        if (siddhiAppContext.getStatisticsManager() != null) {
            this.throughputTracker = QueryParserHelper.createThroughputTracker(siddhiAppContext, streamDefinition.getId(), "Sources", sourceType);
            this.mapperLatencyTracker = QueryParserHelper.createLatencyTracker(siddhiAppContext, streamDefinition.getId(), "SourceMappers", sourceType + "." + mapType);
        }
        this.init(streamDefinition, mapOptionHolder, attributeMappings, configReader, siddhiAppContext);
    }

    public abstract void init(StreamDefinition var1, OptionHolder var2, List<AttributeMapping> var3, ConfigReader var4, SiddhiAppContext var5);

    public abstract Class[] getSupportedInputEventClasses();

    public final void setInputHandler(InputHandler inputHandler) {
        InputEventHandlerCallback inputEventHandlerCallback;
        if (this.sourceHandler != null) {
            this.sourceHandler.setInputHandler(inputHandler);
            inputEventHandlerCallback = this.sourceHandler;
        } else {
            inputEventHandlerCallback = new PassThroughSourceHandler(inputHandler);
        }
        this.inputEventHandler = new InputEventHandler(inputHandler, this.transportMappings, this.trpProperties, this.trpSyncProperties, this.sourceType, this.mapperLatencyTracker, this.siddhiAppContext, inputEventHandlerCallback);
    }

    @Override
    public final void onEvent(Object eventObject, String[] transportProperties) {
        this.onEvent(eventObject, transportProperties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onEvent(Object eventObject, String[] transportProperties, String[] transportSyncProperties) {
        block15: {
            try {
                if (eventObject == null) break block15;
                if (!this.allowNullInTransportProperties() && transportProperties != null) {
                    for (String property : transportProperties) {
                        if (property != null) continue;
                        log.error((Object)("Dropping event " + eventObject.toString() + " belonging to stream " + this.sourceHandler.getInputHandler().getStreamId() + " as it contains null transport properties and system is configured to not allow null transport properties. You can configure it via source mapper if the respective mapper type allows it. Refer mapper documentation to verify supportability"));
                        return;
                    }
                }
                this.trpProperties.set(transportProperties);
                if (transportSyncProperties != null) {
                    this.trpSyncProperties.set(transportSyncProperties);
                }
                try {
                    if (this.throughputTracker != null && this.siddhiAppContext.isStatsEnabled()) {
                        this.throughputTracker.eventIn();
                        this.mapperLatencyTracker.markIn();
                    }
                    this.mapAndProcess(eventObject, this.inputEventHandler);
                }
                finally {
                    if (this.throughputTracker != null && this.siddhiAppContext.isStatsEnabled()) {
                        this.mapperLatencyTracker.markOut();
                    }
                }
            }
            catch (InterruptedException | RuntimeException e) {
                log.error((Object)("Error while processing '" + eventObject + "', for the input Mapping '" + this.mapType + "' for the stream '" + this.streamDefinition.getId() + "'."), (Throwable)e);
            }
            finally {
                this.trpProperties.remove();
                if (transportSyncProperties != null) {
                    this.trpSyncProperties.remove();
                }
            }
        }
    }

    public SourceHandler getHandler() {
        return this.sourceHandler;
    }

    @Override
    public final StreamDefinition getStreamDefinition() {
        return this.streamDefinition;
    }

    protected abstract void mapAndProcess(Object var1, InputEventHandler var2) throws InterruptedException;

    protected abstract boolean allowNullInTransportProperties();
}

