/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.collection.operator;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.table.InMemoryCompiledUpdateSet;
import io.siddhi.core.table.holder.IndexedEventHolder;
import io.siddhi.core.table.holder.PrimaryKeyReferenceHolder;
import io.siddhi.core.util.collection.AddingStreamEventExtractor;
import io.siddhi.core.util.collection.executor.CollectionExecutor;
import io.siddhi.core.util.collection.operator.Operator;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class IndexOperator
implements Operator {
    private static final Logger log = Logger.getLogger(IndexOperator.class);
    protected String queryName;
    private CollectionExecutor collectionExecutor;

    public IndexOperator(CollectionExecutor collectionExecutor, String queryName) {
        this.collectionExecutor = collectionExecutor;
        this.queryName = queryName;
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, Object storeEvents, StreamEventCloner storeEventCloner) {
        return this.collectionExecutor.find(matchingEvent, (IndexedEventHolder)storeEvents, storeEventCloner);
    }

    @Override
    public boolean contains(StateEvent matchingEvent, Object storeEvents) {
        return this.collectionExecutor.contains(matchingEvent, (IndexedEventHolder)storeEvents);
    }

    @Override
    public void delete(ComplexEventChunk<StateEvent> deletingEventChunk, Object storeEvents) {
        deletingEventChunk.reset();
        while (deletingEventChunk.hasNext()) {
            StateEvent deletingEvent = (StateEvent)deletingEventChunk.next();
            this.collectionExecutor.delete(deletingEvent, (IndexedEventHolder)storeEvents);
        }
    }

    @Override
    public void update(ComplexEventChunk<StateEvent> updatingEventChunk, Object storeEvents, InMemoryCompiledUpdateSet compiledUpdateSet) {
        updatingEventChunk.reset();
        while (updatingEventChunk.hasNext()) {
            StateEvent updatingEvent = (StateEvent)updatingEventChunk.next();
            StreamEvent streamEvents = this.collectionExecutor.find(updatingEvent, (IndexedEventHolder)storeEvents, null);
            if (streamEvents == null) continue;
            ComplexEventChunk<StreamEvent> foundEventChunk = new ComplexEventChunk<StreamEvent>(false);
            foundEventChunk.add(streamEvents);
            this.update((IndexedEventHolder)storeEvents, compiledUpdateSet, updatingEvent, foundEventChunk);
        }
    }

    @Override
    public ComplexEventChunk<StreamEvent> tryUpdate(ComplexEventChunk<StateEvent> updatingOrAddingEventChunk, Object storeEvents, InMemoryCompiledUpdateSet compiledUpdateSet, AddingStreamEventExtractor addingStreamEventExtractor) {
        ComplexEventChunk<StreamEvent> failedEventChunk = new ComplexEventChunk<StreamEvent>(updatingOrAddingEventChunk.isBatch());
        updatingOrAddingEventChunk.reset();
        while (updatingOrAddingEventChunk.hasNext()) {
            StateEvent overwritingOrAddingEvent = (StateEvent)updatingOrAddingEventChunk.next();
            StreamEvent streamEvents = this.collectionExecutor.find(overwritingOrAddingEvent, (IndexedEventHolder)storeEvents, null);
            ComplexEventChunk<StreamEvent> foundEventChunk = new ComplexEventChunk<StreamEvent>(false);
            foundEventChunk.add(streamEvents);
            if (foundEventChunk.getFirst() != null) {
                this.update((IndexedEventHolder)storeEvents, compiledUpdateSet, overwritingOrAddingEvent, foundEventChunk);
                continue;
            }
            failedEventChunk.add(addingStreamEventExtractor.getAddingStreamEvent(overwritingOrAddingEvent));
        }
        return failedEventChunk;
    }

    private void update(IndexedEventHolder storeEvents, InMemoryCompiledUpdateSet compiledUpdateSet, StateEvent overwritingOrAddingEvent, ComplexEventChunk<StreamEvent> foundEventChunk) {
        boolean doDeleteUpdate = false;
        boolean fail = false;
        block0: for (Map.Entry<Integer, ExpressionExecutor> entry : compiledUpdateSet.getExpressionExecutorMap().entrySet()) {
            if (doDeleteUpdate || fail) break;
            if (!storeEvents.isAttributeIndexed(entry.getKey())) continue;
            foundEventChunk.reset();
            Object keys = null;
            PrimaryKeyReferenceHolder[] primaryKeyReferenceHolders = storeEvents.getPrimaryKeyReferenceHolders();
            if (primaryKeyReferenceHolders != null && primaryKeyReferenceHolders.length == 1 && entry.getKey().intValue() == primaryKeyReferenceHolders[0].getPrimaryKeyPosition()) {
                keys = new HashSet<Object>(storeEvents.getAllPrimaryKeyValues());
            }
            while (foundEventChunk.hasNext()) {
                StreamEvent streamEvent = (StreamEvent)foundEventChunk.next();
                Object updatingData = entry.getValue().execute(overwritingOrAddingEvent);
                Object storeEventData = streamEvent.getOutputData()[entry.getKey()];
                if (updatingData == null || storeEventData == null || updatingData.equals(storeEventData)) continue;
                doDeleteUpdate = true;
                if (keys == null || keys.size() == 0) continue block0;
                keys.remove(storeEventData);
                if (keys.add(updatingData)) continue;
                log.error((Object)("Update failed for event :" + overwritingOrAddingEvent + ", as there is already an event stored with primary key '" + updatingData + "' at '" + this.queryName + "'"));
                fail = true;
                continue block0;
            }
        }
        foundEventChunk.reset();
        if (!fail) {
            if (doDeleteUpdate) {
                this.collectionExecutor.delete(overwritingOrAddingEvent, storeEvents);
                ComplexEventChunk<StreamEvent> toUpdateEventChunk = new ComplexEventChunk<StreamEvent>(false);
                while (foundEventChunk.hasNext()) {
                    StreamEvent streamEvent = (StreamEvent)foundEventChunk.next();
                    foundEventChunk.remove();
                    streamEvent.setNext(null);
                    for (Map.Entry<Integer, ExpressionExecutor> entry : compiledUpdateSet.getExpressionExecutorMap().entrySet()) {
                        streamEvent.setOutputData(entry.getValue().execute(overwritingOrAddingEvent), entry.getKey());
                    }
                    toUpdateEventChunk.add(streamEvent);
                }
                storeEvents.add(toUpdateEventChunk);
            } else {
                while (foundEventChunk.hasNext()) {
                    StreamEvent streamEvent = (StreamEvent)foundEventChunk.next();
                    streamEvent.setNext(null);
                    for (Map.Entry<Integer, ExpressionExecutor> entry : compiledUpdateSet.getExpressionExecutorMap().entrySet()) {
                        streamEvent.setOutputData(entry.getValue().execute(overwritingOrAddingEvent), entry.getKey());
                    }
                }
            }
        }
    }
}

