/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.event.state;

import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.state.StateEventFactory;

public class StateEventCloner {
    private final int streamEventSize;
    private final int outputDataSize;
    private final StateEventFactory stateEventFactory;

    public StateEventCloner(MetaStateEvent metaStateEvent, StateEventFactory stateEventFactory) {
        this.stateEventFactory = stateEventFactory;
        this.streamEventSize = metaStateEvent.getStreamEventCount();
        this.outputDataSize = metaStateEvent.getOutputDataAttributes().size();
    }

    public StateEvent copyStateEvent(StateEvent stateEvent) {
        StateEvent newEvent = this.stateEventFactory.newInstance();
        if (this.outputDataSize > 0) {
            System.arraycopy(stateEvent.getOutputData(), 0, newEvent.getOutputData(), 0, this.outputDataSize);
        }
        if (this.streamEventSize > 0) {
            System.arraycopy(stateEvent.getStreamEvents(), 0, newEvent.getStreamEvents(), 0, this.streamEventSize);
        }
        newEvent.setType(stateEvent.getType());
        newEvent.setTimestamp(stateEvent.getTimestamp());
        newEvent.setId(stateEvent.getId());
        return newEvent;
    }
}

