/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.condition;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.condition.ConditionExpressionExecutor;
import io.siddhi.query.api.definition.Attribute;

public class AndConditionExpressionExecutor
extends ConditionExpressionExecutor {
    protected ExpressionExecutor leftConditionExecutor;
    protected ExpressionExecutor rightConditionExecutor;

    public AndConditionExpressionExecutor(ExpressionExecutor leftConditionExecutor, ExpressionExecutor rightConditionExecutor) {
        if (!leftConditionExecutor.getReturnType().equals((Object)Attribute.Type.BOOL) || !rightConditionExecutor.getReturnType().equals((Object)Attribute.Type.BOOL)) {
            if (!leftConditionExecutor.getReturnType().equals((Object)Attribute.Type.BOOL)) {
                throw new OperationNotSupportedException("Return type of condition executor " + leftConditionExecutor.toString() + " should be of type BOOL. Actual Type: " + leftConditionExecutor.getReturnType().toString());
            }
            if (!rightConditionExecutor.getReturnType().equals((Object)Attribute.Type.BOOL)) {
                throw new OperationNotSupportedException("Return type of condition executor " + rightConditionExecutor.toString() + " should be of type BOOL. Actual Type: " + rightConditionExecutor.getReturnType().toString());
            }
            throw new OperationNotSupportedException("Return type of condition executor " + leftConditionExecutor.toString() + " and condition executor" + rightConditionExecutor.toString() + "should be of type BOOL. Left executor: " + leftConditionExecutor.getReturnType().toString() + " Right executor: " + rightConditionExecutor.getReturnType().toString());
        }
        this.leftConditionExecutor = leftConditionExecutor;
        this.rightConditionExecutor = rightConditionExecutor;
    }

    @Override
    public Boolean execute(ComplexEvent event) {
        Object rightResult;
        Object leftResult = this.leftConditionExecutor.execute(event);
        if (leftResult != null && ((Boolean)leftResult).booleanValue() && (rightResult = this.rightConditionExecutor.execute(event)) != null && ((Boolean)rightResult).booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

