/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.function;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="instanceOfInteger", namespace="", description="Checks whether the parameter is an instance of Integer or not.", parameters={@Parameter(name="arg", description="The parameter to be checked.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL, DataType.OBJECT})}, returnAttributes={@ReturnAttribute(description="Returned type will be boolean and true if and only if the input is a instance of Integer.", type={DataType.BOOL})}, examples={@Example(syntax="from fooStream\nselect instanceOfInteger(value) as state\ninsert into barStream;", description="This will return true if the value field format is integer."), @Example(syntax="from fooStream\nselect instanceOfInteger(switchState) as state\ninsert into barStream;", description="if the switchState = true then this will returns false as the value is an instance of the boolean not a long.")})
public class InstanceOfIntegerFunctionExecutor
extends FunctionExecutor {
    Attribute.Type returnType = Attribute.Type.BOOL;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to instanceOfInteger() function, required only 1, but found " + attributeExpressionExecutors.length);
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return null;
    }

    protected Object execute(Object data, State state) {
        return data instanceof Integer;
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

