/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.snapshot;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.GroupedComplexEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.query.output.ratelimit.snapshot.AggregationWindowedPerSnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.WrappedSnapshotOutputRateLimiter;
import io.siddhi.core.util.parser.SchedulerParser;
import io.siddhi.core.util.snapshot.state.StateFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AggregationGroupByWindowedPerSnapshotOutputRateLimiter
extends AggregationWindowedPerSnapshotOutputRateLimiter {
    protected AggregationGroupByWindowedPerSnapshotOutputRateLimiter(Long value, List<Integer> aggregateAttributePositionList, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter, boolean groupBy, SiddhiQueryContext siddhiQueryContext) {
        super(value, aggregateAttributePositionList, wrappedSnapshotOutputRateLimiter, groupBy, siddhiQueryContext);
    }

    @Override
    protected StateFactory<AggregationWindowedPerSnapshotOutputRateLimiter.AggregationRateLimiterState> init() {
        this.scheduler = SchedulerParser.parse(this, this.siddhiQueryContext);
        this.scheduler.setStreamEventFactory(new StreamEventFactory(0, 0, 0));
        this.scheduler.init(this.lockWrapper, this.siddhiQueryContext.getName());
        return () -> new AggregationGroupByRateLimiterState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        ArrayList<ComplexEventChunk<ComplexEvent>> outputEventChunks = new ArrayList<ComplexEventChunk<ComplexEvent>>();
        AggregationGroupByRateLimiterState state = (AggregationGroupByRateLimiterState)this.stateHolder.getState();
        try {
            AggregationGroupByRateLimiterState aggregationGroupByRateLimiterState = state;
            synchronized (aggregationGroupByRateLimiterState) {
                complexEventChunk.reset();
                Object var5_5 = null;
                HashMap<Integer, Object> currentAggregateAttributeValueMap = null;
                block6: while (complexEventChunk.hasNext()) {
                    void var5_6;
                    Object event = complexEventChunk.next();
                    if (event.getType() == ComplexEvent.Type.TIMER) {
                        this.tryFlushEvents(outputEventChunks, (ComplexEvent)event, state);
                        continue;
                    }
                    complexEventChunk.remove();
                    this.tryFlushEvents(outputEventChunks, (ComplexEvent)event, state);
                    GroupedComplexEvent groupedComplexEvent = (GroupedComplexEvent)event;
                    if (var5_6 == null || !var5_6.equals(groupedComplexEvent.getGroupKey())) {
                        String string = groupedComplexEvent.getGroupKey();
                        currentAggregateAttributeValueMap = (HashMap<Integer, Object>)state.groupByAggregateAttributeValueMap.get(string);
                        if (currentAggregateAttributeValueMap == null) {
                            currentAggregateAttributeValueMap = new HashMap<Integer, Object>(this.aggregateAttributePositionList.size());
                            state.groupByAggregateAttributeValueMap.put(string, currentAggregateAttributeValueMap);
                        }
                    }
                    if (groupedComplexEvent.getType() == ComplexEvent.Type.CURRENT) {
                        state.eventList.add(groupedComplexEvent);
                        for (Integer position : this.aggregateAttributePositionList) {
                            currentAggregateAttributeValueMap.put(position, event.getOutputData()[position]);
                        }
                        continue;
                    }
                    if (groupedComplexEvent.getType() == ComplexEvent.Type.EXPIRED) {
                        Iterator iterator = state.eventList.iterator();
                        while (iterator.hasNext()) {
                            GroupedComplexEvent currentEvent = (GroupedComplexEvent)iterator.next();
                            if (this.comparator.compare(currentEvent.getComplexEvent(), groupedComplexEvent.getComplexEvent()) != 0) continue;
                            iterator.remove();
                            for (Integer position : this.aggregateAttributePositionList) {
                                currentAggregateAttributeValueMap.put(position, groupedComplexEvent.getOutputData()[position]);
                            }
                            continue block6;
                        }
                        continue;
                    }
                    if (groupedComplexEvent.getType() != ComplexEvent.Type.RESET) continue;
                    state.eventList.clear();
                    state.groupByAggregateAttributeValueMap.clear();
                }
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    private void tryFlushEvents(List<ComplexEventChunk<ComplexEvent>> outputEventChunks, ComplexEvent event, AggregationGroupByRateLimiterState state) {
        if (event.getTimestamp() >= state.scheduledTime) {
            this.constructOutputChunk(outputEventChunks, state);
            state.scheduledTime += this.value.longValue();
            this.scheduler.notifyAt(state.scheduledTime);
        }
    }

    private void constructOutputChunk(List<ComplexEventChunk<ComplexEvent>> outputEventChunks, AggregationGroupByRateLimiterState state) {
        ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>(false);
        HashSet<String> outputGroupingKeys = new HashSet<String>();
        for (GroupedComplexEvent originalComplexEvent : state.eventList) {
            String currentGroupByKey = originalComplexEvent.getGroupKey();
            if (outputGroupingKeys.contains(currentGroupByKey)) continue;
            outputGroupingKeys.add(currentGroupByKey);
            Map currentAggregateAttributeValueMap = (Map)state.groupByAggregateAttributeValueMap.get(currentGroupByKey);
            ComplexEvent eventCopy = this.cloneComplexEvent(originalComplexEvent.getComplexEvent());
            for (Integer position : this.aggregateAttributePositionList) {
                eventCopy.getOutputData()[position.intValue()] = currentAggregateAttributeValueMap.get(position);
            }
            outputEventChunk.add(eventCopy);
        }
        outputEventChunks.add(outputEventChunk);
    }

    class AggregationGroupByRateLimiterState
    extends AggregationWindowedPerSnapshotOutputRateLimiter.AggregationRateLimiterState {
        private List<GroupedComplexEvent> eventList;
        private Map<String, Map<Integer, Object>> groupByAggregateAttributeValueMap;

        public AggregationGroupByRateLimiterState() {
            super(AggregationGroupByWindowedPerSnapshotOutputRateLimiter.this);
            this.groupByAggregateAttributeValueMap = new HashMap<String, Map<Integer, Object>>();
            this.eventList = new LinkedList<GroupedComplexEvent>();
        }

        @Override
        public boolean canDestroy() {
            return this.groupByAggregateAttributeValueMap.isEmpty() && this.eventList.isEmpty() && this.scheduledTime == 0L;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("EventList", this.eventList);
            state.put("GroupByAggregateAttributeValueMap", this.groupByAggregateAttributeValueMap);
            state.put("ScheduledTime", this.scheduledTime);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.eventList = (List)state.get("EventList");
            this.groupByAggregateAttributeValueMap = (Map)state.get("GroupByAggregateAttributeValueMap");
            this.scheduledTime = (Long)state.get("ScheduledTime");
        }
    }
}

