/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregatorExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@Extension(name="maxForever", namespace="", description="This is the attribute aggregator to store the maximum value for a given attribute throughout the lifetime of the query regardless of any windows in-front.", parameters={@Parameter(name="arg", description="The value that needs to be compared to find the maximum value.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, returnAttributes={@ReturnAttribute(description="Returns the maximum value in the same data type as the input.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, examples={@Example(syntax="from inputStream\nselect maxForever(temp) as max\ninsert into outputStream;", description="maxForever(temp) returns the maximum temp value recorded for all the events throughout the lifetime of the query.")})
public class MaxForeverAttributeAggregatorExecutor
extends AttributeAggregatorExecutor<MaxAggregatorState> {
    private Attribute.Type returnType;

    @Override
    protected StateFactory<MaxAggregatorState> init(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("MaxForever aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        this.returnType = attributeExpressionExecutors[0].getReturnType();
        return new StateFactory<MaxAggregatorState>(){

            @Override
            public MaxAggregatorState createNewState() {
                switch (MaxForeverAttributeAggregatorExecutor.this.returnType) {
                    case FLOAT: {
                        return new MaxForeverAttributeAggregatorStateFloat();
                    }
                    case INT: {
                        return new MaxForeverAttributeAggregatorStateInt();
                    }
                    case LONG: {
                        return new MaxForeverAttributeAggregatorStateLong();
                    }
                    case DOUBLE: {
                        return new MaxForeverAttributeAggregatorStateDouble();
                    }
                }
                throw new OperationNotSupportedException("MaxForever not supported for " + MaxForeverAttributeAggregatorExecutor.this.returnType);
            }
        };
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Object processAdd(Object data, MaxAggregatorState state) {
        if (data == null) {
            return state.currentValue();
        }
        return state.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data, MaxAggregatorState state) {
        return new IllegalStateException("MaxForever cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data, MaxAggregatorState state) {
        if (data == null) {
            return state.currentValue();
        }
        return state.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data, MaxAggregatorState state) {
        return new IllegalStateException("MaxForever cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset(MaxAggregatorState state) {
        return state.reset();
    }

    abstract class MaxAggregatorState
    extends State {
        MaxAggregatorState() {
        }

        public abstract Object processAdd(Object var1);

        public abstract Object processRemove(Object var1);

        public abstract Object reset();

        protected abstract Object currentValue();
    }

    class MaxForeverAttributeAggregatorStateLong
    extends MaxAggregatorState {
        private volatile Long maxValue = null;

        MaxForeverAttributeAggregatorStateLong() {
        }

        @Override
        public Object processAdd(Object data) {
            Long value = (Long)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object processRemove(Object data) {
            Long value = (Long)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object reset() {
            return this.maxValue;
        }

        @Override
        public boolean canDestroy() {
            return this.maxValue == null;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MaxValue", this.maxValue);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.maxValue = (Long)state.get("MaxValue");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }

    class MaxForeverAttributeAggregatorStateInt
    extends MaxAggregatorState {
        private volatile Integer maxValue = null;

        MaxForeverAttributeAggregatorStateInt() {
        }

        @Override
        public Object processAdd(Object data) {
            Integer value = (Integer)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object processRemove(Object data) {
            Integer value = (Integer)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object reset() {
            return this.maxValue;
        }

        @Override
        public boolean canDestroy() {
            return this.maxValue == null;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MaxValue", this.maxValue);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.maxValue = (Integer)state.get("MaxValue");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }

    class MaxForeverAttributeAggregatorStateFloat
    extends MaxAggregatorState {
        private volatile Float maxValue = null;

        MaxForeverAttributeAggregatorStateFloat() {
        }

        @Override
        public Object processAdd(Object data) {
            Float value = (Float)data;
            if (this.maxValue == null || this.maxValue.floatValue() < value.floatValue()) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object processRemove(Object data) {
            Float value = (Float)data;
            if (this.maxValue == null || this.maxValue.floatValue() < value.floatValue()) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object reset() {
            return this.maxValue;
        }

        @Override
        public boolean canDestroy() {
            return this.maxValue == null;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MaxValue", this.maxValue);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.maxValue = (Float)state.get("MaxValue");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }

    class MaxForeverAttributeAggregatorStateDouble
    extends MaxAggregatorState {
        private volatile Double maxValue = null;

        MaxForeverAttributeAggregatorStateDouble() {
        }

        @Override
        public Object processAdd(Object data) {
            Double value = (Double)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object processRemove(Object data) {
            Double value = (Double)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object reset() {
            return this.maxValue;
        }

        @Override
        public boolean canDestroy() {
            return this.maxValue == null;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MaxValue", this.maxValue);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.maxValue = (Double)state.get("MaxValue");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }
}

