/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregatorExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@Extension(name="stdDev", namespace="", description="Returns the calculated standard deviation for all the events.", parameters={@Parameter(name="arg", description="The value that should be used to calculate the standard deviation.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, returnAttributes={@ReturnAttribute(description="Returns the calculated standard deviation value as a double.", type={DataType.DOUBLE})}, examples={@Example(syntax="from inputStream\nselect stddev(temp) as stdTemp\ninsert into outputStream;", description="stddev(temp) returns the calculated standard deviation of temp for all the events based on their arrival and expiry.")})
public class StdDevAttributeAggregatorExecutor
extends AttributeAggregatorExecutor<AggregatorState> {
    private Attribute.Type returnType;

    @Override
    protected StateFactory<AggregatorState> init(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("stdDev aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        this.returnType = Attribute.Type.DOUBLE;
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        return () -> {
            switch (type) {
                case INT: {
                    return new StdDevAttributeAggregatorStateInt();
                }
                case LONG: {
                    return new StdDevAttributeAggregatorStateLong();
                }
                case FLOAT: {
                    return new StdDevAttributeAggregatorStateFloat();
                }
                case DOUBLE: {
                    return new StdDevAttributeAggregatorStateDouble();
                }
            }
            throw new OperationNotSupportedException("stdDev not supported for " + this.returnType);
        };
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Object processAdd(Object data, AggregatorState state) {
        if (data == null) {
            return state.currentValue();
        }
        return state.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data, AggregatorState state) {
        return new IllegalStateException("stdDev cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data, AggregatorState state) {
        if (data == null) {
            return state.currentValue();
        }
        return state.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data, AggregatorState state) {
        return new IllegalStateException("stdDev cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset(AggregatorState state) {
        return state.reset();
    }

    private class StdDevAttributeAggregatorStateLong
    extends AggregatorState {
        private StdDevAttributeAggregatorStateLong() {
        }

        @Override
        public Object processAdd(Object data) {
            return this.processAdd(((Long)data).doubleValue());
        }

        @Override
        public Object processRemove(Object data) {
            return this.processRemove(((Long)data).doubleValue());
        }
    }

    private class StdDevAttributeAggregatorStateInt
    extends AggregatorState {
        private StdDevAttributeAggregatorStateInt() {
        }

        @Override
        public Object processAdd(Object data) {
            return this.processAdd(((Integer)data).doubleValue());
        }

        @Override
        public Object processRemove(Object data) {
            return this.processRemove(((Integer)data).doubleValue());
        }
    }

    private class StdDevAttributeAggregatorStateFloat
    extends AggregatorState {
        private StdDevAttributeAggregatorStateFloat() {
        }

        @Override
        public Object processAdd(Object data) {
            return this.processAdd(((Float)data).doubleValue());
        }

        @Override
        public Object processRemove(Object data) {
            return this.processRemove(((Float)data).doubleValue());
        }
    }

    private class StdDevAttributeAggregatorStateDouble
    extends AggregatorState {
        private StdDevAttributeAggregatorStateDouble() {
        }

        @Override
        public Object processAdd(Object data) {
            return this.processAdd((Double)data);
        }

        @Override
        public Object processRemove(Object data) {
            return this.processRemove((Double)data);
        }
    }

    abstract class AggregatorState
    extends State {
        private double mean;
        private double stdDeviation;
        private double sum;
        private int count = 0;

        AggregatorState() {
        }

        public abstract Object processRemove(Object var1);

        public abstract Object processAdd(Object var1);

        public Object processAdd(double value) {
            ++this.count;
            if (this.count == 0) {
                return null;
            }
            if (this.count == 1) {
                this.sum = this.mean = value;
                this.stdDeviation = 0.0;
                return 0.0;
            }
            double oldMean = this.mean;
            this.sum += value;
            this.mean = this.sum / (double)this.count;
            this.stdDeviation += (value - oldMean) * (value - this.mean);
            return Math.sqrt(this.stdDeviation / (double)this.count);
        }

        public Object processRemove(double value) {
            --this.count;
            if (this.count == 0) {
                this.mean = 0.0;
                this.sum = 0.0;
                this.stdDeviation = 0.0;
                return null;
            }
            double oldMean = this.mean;
            this.sum -= value;
            this.mean = this.sum / (double)this.count;
            this.stdDeviation -= (value - oldMean) * (value - this.mean);
            if (this.count == 1) {
                return 0.0;
            }
            return Math.sqrt(this.stdDeviation / (double)this.count);
        }

        public Object reset() {
            this.mean = 0.0;
            this.sum = 0.0;
            this.stdDeviation = 0.0;
            this.count = 0;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.count == 0 && this.sum == 0.0 && this.mean == 0.0 && this.stdDeviation == 0.0;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Sum", this.sum);
            state.put("Mean", this.mean);
            state.put("stdDeviation", this.stdDeviation);
            state.put("Count", this.count);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.sum = ((Long)state.get("Sum")).longValue();
            this.mean = ((Long)state.get("Mean")).longValue();
            this.stdDeviation = ((Long)state.get("stdDeviation")).longValue();
            this.count = (Integer)state.get("Count");
        }

        protected Object currentValue() {
            if (this.count == 0) {
                return null;
            }
            if (this.count == 1) {
                return 0.0;
            }
            return Math.sqrt(this.stdDeviation / (double)this.count);
        }
    }
}

