/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.function;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="coalesce", namespace="", description="Returns the value of the first input parameter that is not null, and all input parameters have to be on the same type.", parameters={@Parameter(name="arg", description="This function accepts one or more parameters. They can belong to any one of the available types. All the specified parameters should be of the same type.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL, DataType.OBJECT}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"arg", "..."})}, returnAttributes={@ReturnAttribute(description="This will be the same as the type of the first input parameter.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL, DataType.OBJECT})}, examples={@Example(syntax="from fooStream\nselect coalesce('123', null, '789') as value\ninsert into barStream;", description="This will returns first null value 123."), @Example(syntax="from fooStream\nselect coalesce(null, 76, 567) as value\ninsert into barStream;", description="This will returns first null value 76."), @Example(syntax="from fooStream\nselect coalesce(null, null, null) as value\ninsert into barStream;", description="This will returns null as there are no notnull values.")})
public class CoalesceFunctionExecutor
extends FunctionExecutor {
    private Attribute.Type returnType;

    public StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length == 0) {
            throw new SiddhiAppValidationException("Coalesce must have at least one parameter");
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        for (ExpressionExecutor expressionExecutor : attributeExpressionExecutors) {
            if (type == expressionExecutor.getReturnType()) continue;
            throw new SiddhiAppValidationException("Coalesce cannot have parameters with different type");
        }
        this.returnType = type;
        return null;
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    protected Object execute(Object[] obj, State state) {
        for (Object aObj : obj) {
            if (aObj == null) continue;
            return aObj;
        }
        return null;
    }

    protected Object execute(Object data, State state) {
        return data;
    }
}

