/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input.stream.state;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.MetaComplexEvent;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.partition.PartitionCreationListener;
import io.siddhi.core.query.input.stream.StreamRuntime;
import io.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import io.siddhi.core.query.input.stream.state.PreStateProcessor;
import io.siddhi.core.query.input.stream.state.runtime.InnerStateRuntime;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.selector.QuerySelector;
import java.util.List;

public class StateStreamRuntime
implements StreamRuntime {
    private MetaStateEvent metaStateEvent;
    private InnerStateRuntime innerStateRuntime;
    private List<PreStateProcessor> startupPreStateProcessors;

    public StateStreamRuntime(SiddhiQueryContext siddhiQueryContext, MetaStateEvent metaStateEvent) {
        this.metaStateEvent = metaStateEvent;
    }

    @Override
    public List<SingleStreamRuntime> getSingleStreamRuntimes() {
        return this.innerStateRuntime.getSingleStreamRuntimeList();
    }

    @Override
    public void setCommonProcessor(Processor commonProcessor) {
        this.innerStateRuntime.setQuerySelector(commonProcessor);
        this.innerStateRuntime.setup();
    }

    @Override
    public MetaComplexEvent getMetaComplexEvent() {
        return this.metaStateEvent;
    }

    @Override
    public ProcessingMode getProcessingMode() {
        return ProcessingMode.BATCH;
    }

    @Override
    public QuerySelector getQuerySelector() {
        return null;
    }

    public InnerStateRuntime getInnerStateRuntime() {
        return this.innerStateRuntime;
    }

    public void setInnerStateRuntime(InnerStateRuntime innerStateRuntime) {
        this.innerStateRuntime = innerStateRuntime;
    }

    public void resetAndUpdate() {
        this.innerStateRuntime.reset();
        this.innerStateRuntime.update();
    }

    public void setStartupPreStateProcessors(List<PreStateProcessor> startupPreStateProcessors) {
        this.startupPreStateProcessors = startupPreStateProcessors;
    }

    public void initPartition() {
        this.innerStateRuntime.init();
        for (PreStateProcessor preStateProcessor : this.startupPreStateProcessors) {
            if (!(preStateProcessor instanceof PartitionCreationListener)) continue;
            ((PartitionCreationListener)((Object)preStateProcessor)).partitionCreated();
        }
    }
}

