/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.table;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.table.CacheTable;
import io.siddhi.core.table.InMemoryTable;
import io.siddhi.core.table.holder.IndexEventHolder;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.TableDefinition;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CacheTableLFU
extends CacheTable {
    private static final Logger log = LogManager.getLogger(CacheTableLFU.class);
    private int cachePolicyAttributePosition;
    private int numColumns;
    private int expiryAttributePosition;

    @Override
    void addRequiredFieldsToCacheTableDefinition(TableDefinition cacheTableDefinition, boolean cacheExpiryEnabled) {
        if (cacheExpiryEnabled) {
            cacheTableDefinition.attribute("_TIMESTAMP_ADDED", Attribute.Type.LONG);
            cacheTableDefinition.attribute("_COUNT_LFU", Attribute.Type.INT);
            this.expiryAttributePosition = cacheTableDefinition.getAttributeList().size() - 2;
        } else {
            cacheTableDefinition.attribute("_COUNT_LFU", Attribute.Type.INT);
        }
        this.cachePolicyAttributePosition = cacheTableDefinition.getAttributeList().size() - 1;
        this.numColumns = this.cachePolicyAttributePosition + 1;
    }

    @Override
    public void deleteOneEntryUsingCachePolicy() {
        IndexEventHolder indexEventHolder = (IndexEventHolder)((InMemoryTable.TableState)this.stateHolder.getState()).getEventHolder();
        Set<Object> keys = indexEventHolder.getAllPrimaryKeyValues();
        int minCount = Integer.MAX_VALUE;
        Object keyOfMinCount = null;
        for (Object key : keys) {
            Object[] data = indexEventHolder.getEvent(key).getOutputData();
            int count = (Integer)data[this.cachePolicyAttributePosition];
            if (count >= minCount) continue;
            minCount = count;
            keyOfMinCount = key;
        }
        indexEventHolder.deleteEvent(keyOfMinCount);
    }

    @Override
    public void deleteEntriesUsingCachePolicy(int numRowsToDelete) {
        IndexEventHolder indexEventHolder = (IndexEventHolder)((InMemoryTable.TableState)this.stateHolder.getState()).getEventHolder();
        if (numRowsToDelete >= indexEventHolder.size()) {
            indexEventHolder.deleteAll();
        } else {
            Set<Object> keys = indexEventHolder.getAllPrimaryKeyValues();
            TreeMap<Integer, Object> toDelete = new TreeMap<Integer, Object>();
            for (Object key : keys) {
                if (toDelete.size() < numRowsToDelete) {
                    toDelete.put((Integer)indexEventHolder.getEvent(key).getOutputData()[this.cachePolicyAttributePosition], key);
                    continue;
                }
                Integer count = (Integer)indexEventHolder.getEvent(key).getOutputData()[this.cachePolicyAttributePosition];
                Integer firstKey = (Integer)toDelete.firstKey();
                if (count >= firstKey) continue;
                toDelete.remove(firstKey);
                toDelete.put(count, key);
            }
            for (Object deleteKey : toDelete.values()) {
                if (deleteKey == null) continue;
                indexEventHolder.deleteEvent(deleteKey);
            }
        }
    }

    @Override
    protected StreamEvent addRequiredFields(ComplexEvent event, SiddhiAppContext siddhiAppContext, boolean cacheExpiryEnabled) {
        Object[] outputDataForCache;
        Object[] outputData = event.getOutputData();
        if (cacheExpiryEnabled) {
            outputDataForCache = new Object[this.numColumns];
            outputDataForCache[this.expiryAttributePosition] = siddhiAppContext.getTimestampGenerator().currentTime();
            outputDataForCache[this.cachePolicyAttributePosition] = 1;
        } else {
            outputDataForCache = new Object[this.numColumns];
            outputDataForCache[this.cachePolicyAttributePosition] = 1;
        }
        System.arraycopy(outputData, 0, outputDataForCache, 0, outputData.length);
        StreamEvent eventForCache = new StreamEvent(0, 0, outputDataForCache.length);
        eventForCache.setOutputData(outputDataForCache);
        return eventForCache;
    }

    @Override
    public void updateCachePolicyAttribute(StreamEvent streamEvent) {
        streamEvent.getOutputData()[this.cachePolicyAttributePosition] = (Integer)streamEvent.getOutputData()[this.cachePolicyAttributePosition] + 1;
    }
}

