/*
 * Copyright (c) 2016, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package io.siddhi.core.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Helper class ot be used by siddhi tests. Any extension can utilize methods in here
 */
public class SiddhiTestHelper {
    private static final Logger LOG = LogManager.getLogger(SiddhiTestHelper.class);

    private SiddhiTestHelper() {

    }

    public static void waitForEvents(long sleepTime, AtomicBoolean condition, long timeout)
            throws InterruptedException {
        long currentWaitTime = 0;
        long startTime = System.currentTimeMillis();
        while (!condition.get() && (currentWaitTime <= timeout)) {
            Thread.sleep(sleepTime);
            currentWaitTime = System.currentTimeMillis() - startTime;
        }
    }

    public static void waitForEvents(long sleepTime, int expectedCount, AtomicInteger actualCount, long timeout)
            throws InterruptedException {
        long currentWaitTime = 0;
        long startTime = System.currentTimeMillis();
        while ((actualCount.get() < expectedCount) && (currentWaitTime <= timeout)) {
            Thread.sleep(sleepTime);
            currentWaitTime = System.currentTimeMillis() - startTime;
        }
    }

    public static void waitForEvents(long sleepTime, int expectedCount, int actualCount, long timeout)
            throws InterruptedException {
        long currentWaitTime = 0;
        long startTime = System.currentTimeMillis();
        while ((actualCount < expectedCount) && (currentWaitTime <= timeout)) {
            Thread.sleep(sleepTime);
            currentWaitTime = System.currentTimeMillis() - startTime;
        }
    }

    public static void waitForEvents(long sleepTime, int expectedSize, Collection<?> collection, long timeout)
            throws InterruptedException {
        long currentWaitTime = 0;
        long startTime = System.currentTimeMillis();
        while ((collection.size() < expectedSize) && (currentWaitTime <= timeout)) {
            Thread.sleep(sleepTime);
            currentWaitTime = System.currentTimeMillis() - startTime;
        }
    }

    public static boolean isEventsMatch(List<Object[]> actual, List<Object[]> expected) {
        if (actual.size() != expected.size()) {
            return false;
        } else {
            for (int i = 0; i < actual.size(); i++) {
                if (!Arrays.equals(actual.get(i), expected.get(i))) {
                    LOG.error("Sorted events do not match.");
                    return false;
                }
            }
            return true;
        }
    }

    public static boolean isUnsortedEventsMatch(List<Object[]> actual, List<Object[]> expected) {
        if (actual.size() != expected.size()) {
            return false;
        } else {
            for (int i = 0; i < actual.size(); i++) {
                boolean isThere = false;
                for (int j = 0; j < expected.size(); j++) {
                    if (Arrays.equals(actual.get(i), expected.get(j))) {
                        isThere = true;
                        break;
                    }
                }
                if (!isThere) {
                    return false;
                }
            }
            return true;
        }
    }
}
