/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.stream.input;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.DefinitionNotExistException;
import io.siddhi.core.stream.StreamJunction;
import io.siddhi.core.stream.input.InputDistributor;
import io.siddhi.core.stream.input.InputEntryValve;
import io.siddhi.core.stream.input.InputHandler;
import io.siddhi.core.stream.input.TableInputHandler;
import io.siddhi.core.table.Table;
import io.siddhi.query.api.definition.AbstractDefinition;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class InputManager {
    private final InputEntryValve inputEntryValve;
    private final SiddhiAppContext siddhiAppContext;
    private Map<String, InputHandler> inputHandlerMap = new LinkedHashMap<String, InputHandler>();
    private Map<String, TableInputHandler> tableInputHandlerMap = new LinkedHashMap<String, TableInputHandler>();
    private Map<String, StreamJunction> streamJunctionMap;
    private ConcurrentMap<String, Table> tableMap;
    private InputDistributor inputDistributor;
    private boolean isConnected = false;

    public InputManager(SiddhiAppContext siddhiAppContext, ConcurrentMap<String, AbstractDefinition> streamDefinitionMap, ConcurrentMap<String, StreamJunction> streamJunctionMap, ConcurrentMap<String, Table> tableMap) {
        this.streamJunctionMap = streamJunctionMap;
        this.tableMap = tableMap;
        this.inputDistributor = new InputDistributor();
        this.inputEntryValve = new InputEntryValve(siddhiAppContext, this.inputDistributor);
        this.siddhiAppContext = siddhiAppContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputHandler getInputHandler(String streamId) {
        InputHandler inputHandler = this.inputHandlerMap.get(streamId);
        if (inputHandler == null) {
            InputManager inputManager = this;
            synchronized (inputManager) {
                inputHandler = this.inputHandlerMap.get(streamId);
                if (inputHandler == null) {
                    InputHandler newInputHandler = this.constructInputHandler(streamId);
                    if (this.isConnected) {
                        newInputHandler.connect();
                    }
                    return newInputHandler;
                }
                return inputHandler;
            }
        }
        return inputHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableInputHandler getTableInputHandler(String tableId) {
        TableInputHandler tableInputHandler = this.tableInputHandlerMap.get(tableId);
        InputManager inputManager = this;
        synchronized (inputManager) {
            if (tableInputHandler == null) {
                return this.constructTableInputHandler(tableId);
            }
            return tableInputHandler;
        }
    }

    public synchronized void connect() {
        for (InputHandler inputHandler : this.inputHandlerMap.values()) {
            inputHandler.connect();
        }
        this.isConnected = true;
    }

    public synchronized void disconnect() {
        for (InputHandler inputHandler : this.inputHandlerMap.values()) {
            inputHandler.disconnect();
        }
        this.inputDistributor.clear();
        this.inputHandlerMap.clear();
        this.isConnected = false;
    }

    public synchronized InputHandler constructInputHandler(String streamId) {
        InputHandler inputHandler = new InputHandler(streamId, this.inputHandlerMap.size(), this.inputEntryValve, this.siddhiAppContext);
        StreamJunction streamJunction = this.streamJunctionMap.get(streamId);
        if (streamJunction == null) {
            throw new DefinitionNotExistException("Stream with stream ID " + streamId + " has not been defined");
        }
        this.inputDistributor.addInputProcessor(this.streamJunctionMap.get(streamId).constructPublisher());
        this.inputHandlerMap.put(streamId, inputHandler);
        return inputHandler;
    }

    public synchronized TableInputHandler constructTableInputHandler(String tableId) {
        Table correspondingTable = (Table)this.tableMap.get(tableId);
        if (correspondingTable == null) {
            throw new DefinitionNotExistException("Table with table ID " + tableId + " has not been defined");
        }
        TableInputHandler tableInputHandler = new TableInputHandler(correspondingTable, this.siddhiAppContext);
        this.tableInputHandlerMap.put(tableId, tableInputHandler);
        return tableInputHandler;
    }
}

