/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core;

import com.lmax.disruptor.ExceptionHandler;
import io.siddhi.annotation.Extension;
import io.siddhi.core.SiddhiAppRuntime;
import io.siddhi.core.aggregation.AggregationRuntime;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.debugger.SiddhiDebugger;
import io.siddhi.core.event.Event;
import io.siddhi.core.exception.CannotClearSiddhiAppStateException;
import io.siddhi.core.exception.CannotRestoreSiddhiAppStateException;
import io.siddhi.core.exception.DefinitionNotExistException;
import io.siddhi.core.exception.OnDemandQueryCreationException;
import io.siddhi.core.exception.QueryNotExistException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.partition.PartitionRuntime;
import io.siddhi.core.partition.PartitionRuntimeImpl;
import io.siddhi.core.query.OnDemandQueryRuntime;
import io.siddhi.core.query.QueryRuntime;
import io.siddhi.core.query.QueryRuntimeImpl;
import io.siddhi.core.query.input.stream.StreamRuntime;
import io.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import io.siddhi.core.query.output.callback.OutputCallback;
import io.siddhi.core.query.output.callback.QueryCallback;
import io.siddhi.core.stream.StreamJunction;
import io.siddhi.core.stream.input.InputHandler;
import io.siddhi.core.stream.input.InputManager;
import io.siddhi.core.stream.input.TableInputHandler;
import io.siddhi.core.stream.input.source.Source;
import io.siddhi.core.stream.input.source.SourceHandlerManager;
import io.siddhi.core.stream.output.StreamCallback;
import io.siddhi.core.stream.output.sink.Sink;
import io.siddhi.core.stream.output.sink.SinkCallback;
import io.siddhi.core.stream.output.sink.SinkHandlerManager;
import io.siddhi.core.table.Table;
import io.siddhi.core.table.record.RecordTableHandler;
import io.siddhi.core.table.record.RecordTableHandlerManager;
import io.siddhi.core.trigger.Trigger;
import io.siddhi.core.util.ExceptionUtil;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.StringUtil;
import io.siddhi.core.util.extension.holder.ExternalReferencedHolder;
import io.siddhi.core.util.parser.OnDemandQueryParser;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.core.util.persistence.util.PersistenceHelper;
import io.siddhi.core.util.snapshot.PersistenceReference;
import io.siddhi.core.util.statistics.BufferedEventsTracker;
import io.siddhi.core.util.statistics.LatencyTracker;
import io.siddhi.core.util.statistics.MemoryUsageTracker;
import io.siddhi.core.util.statistics.metrics.Level;
import io.siddhi.core.window.Window;
import io.siddhi.query.api.SiddhiApp;
import io.siddhi.query.api.annotation.Annotation;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.AggregationDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.definition.WindowDefinition;
import io.siddhi.query.api.exception.SiddhiAppContextException;
import io.siddhi.query.api.execution.query.OnDemandQuery;
import io.siddhi.query.api.execution.query.StoreQuery;
import io.siddhi.query.compiler.SiddhiCompiler;
import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SiddhiAppRuntimeImpl
implements SiddhiAppRuntime {
    private static final Logger log = LogManager.getLogger(SiddhiAppRuntimeImpl.class);
    private final Map<String, Window> windowMap;
    private final Map<String, List<Source>> sourceMap;
    private final Map<String, List<Sink>> sinkMap;
    private ConcurrentMap<String, AggregationRuntime> aggregationMap;
    private Map<String, AbstractDefinition> streamDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private Map<String, AbstractDefinition> tableDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private Map<String, AbstractDefinition> windowDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private Map<String, AbstractDefinition> aggregationDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private InputManager inputManager;
    private Map<String, QueryRuntime> queryProcessorMap = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, StreamJunction> streamJunctionMap = new ConcurrentHashMap<String, StreamJunction>();
    private Map<String, Table> tableMap = new ConcurrentHashMap<String, Table>();
    private Map<String, PartitionRuntime> partitionMap = new ConcurrentHashMap<String, PartitionRuntime>();
    private LinkedHashMap<OnDemandQuery, OnDemandQueryRuntime> onDemandQueryRuntimeMap = new LinkedHashMap();
    private ConcurrentMap<String, Trigger> triggerMap;
    private SiddhiAppContext siddhiAppContext;
    private Map<String, SiddhiAppRuntime> siddhiAppRuntimeMap;
    private MemoryUsageTracker memoryUsageTracker;
    private BufferedEventsTracker bufferedEventsTracker;
    private LatencyTracker onDemandQueryLatencyTracker;
    private SiddhiDebugger siddhiDebugger;
    private boolean running = false;
    private boolean runningWithoutSources = false;
    private Future futureIncrementalPersistor;
    private boolean incrementalDataPurging = true;
    private Set<String> warnings = new HashSet<String>();

    public SiddhiAppRuntimeImpl(Map<String, AbstractDefinition> streamDefinitionMap, Map<String, AbstractDefinition> tableDefinitionMap, Map<String, AbstractDefinition> windowDefinitionMap, Map<String, AbstractDefinition> aggregationDefinitionMap, InputManager inputManager, Map<String, QueryRuntime> queryProcessorMap, Map<String, StreamJunction> streamJunctionMap, Map<String, Table> tableMap, Map<String, Window> windowMap, ConcurrentMap<String, AggregationRuntime> aggregationMap, Map<String, List<Source>> sourceMap, Map<String, List<Sink>> sinkMap, Map<String, PartitionRuntime> partitionMap, ConcurrentMap<String, Trigger> triggerMap, SiddhiAppContext siddhiAppContext, Map<String, SiddhiAppRuntime> siddhiAppRuntimeMap) {
        this.streamDefinitionMap = streamDefinitionMap;
        this.tableDefinitionMap = tableDefinitionMap;
        this.windowDefinitionMap = windowDefinitionMap;
        this.aggregationDefinitionMap = aggregationDefinitionMap;
        this.inputManager = inputManager;
        this.queryProcessorMap = queryProcessorMap;
        this.streamJunctionMap = streamJunctionMap;
        this.tableMap = tableMap;
        this.windowMap = windowMap;
        this.aggregationMap = aggregationMap;
        this.sourceMap = sourceMap;
        this.sinkMap = sinkMap;
        this.partitionMap = partitionMap;
        this.triggerMap = triggerMap;
        this.siddhiAppContext = siddhiAppContext;
        this.siddhiAppRuntimeMap = siddhiAppRuntimeMap;
        if (siddhiAppContext.getStatisticsManager() != null) {
            this.monitorQueryMemoryUsage();
            this.monitorBufferedEvents();
            this.onDemandQueryLatencyTracker = QueryParserHelper.createLatencyTracker(siddhiAppContext, "query", "OnDemandQueries", null);
        }
        this.collectDeprecateWarnings();
        for (Map.Entry<String, List<Sink>> entry : sinkMap.entrySet()) {
            this.addCallback(entry.getKey(), new SinkCallback(entry.getValue(), streamDefinitionMap.get(entry.getKey())));
        }
        for (Map.Entry<String, List<Object>> entry : sourceMap.entrySet()) {
            InputHandler inputHandler = this.getInputHandler(entry.getKey());
            for (Source source : entry.getValue()) {
                source.getMapper().setInputHandler(inputHandler);
            }
        }
    }

    @Override
    public String getName() {
        return this.siddhiAppContext.getName();
    }

    @Override
    public Map<String, StreamDefinition> getStreamDefinitionMap() {
        return this.streamDefinitionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (StreamDefinition)e.getValue()));
    }

    @Override
    public Map<String, TableDefinition> getTableDefinitionMap() {
        return this.tableDefinitionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (TableDefinition)e.getValue()));
    }

    public ConcurrentMap<String, AggregationRuntime> getAggregationMap() {
        return this.aggregationMap;
    }

    @Override
    public Map<String, WindowDefinition> getWindowDefinitionMap() {
        return this.windowDefinitionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (WindowDefinition)e.getValue()));
    }

    @Override
    public Map<String, AggregationDefinition> getAggregationDefinitionMap() {
        return this.aggregationDefinitionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (AggregationDefinition)e.getValue()));
    }

    @Override
    public Set<String> getQueryNames() {
        return this.queryProcessorMap.keySet();
    }

    @Override
    public Map<String, Map<String, AbstractDefinition>> getPartitionedInnerStreamDefinitionMap() {
        HashMap<String, Map<String, AbstractDefinition>> innerStreams = new HashMap<String, Map<String, AbstractDefinition>>();
        for (PartitionRuntime partition : this.partitionMap.values()) {
            innerStreams.put(partition.getPartitionName(), partition.getLocalStreamDefinitionMap());
        }
        return innerStreams;
    }

    @Override
    public void addCallback(String streamId, StreamCallback streamCallback) {
        streamCallback.setStreamId(streamId);
        StreamJunction streamJunction = this.streamJunctionMap.get(streamId);
        if (streamJunction == null) {
            throw new DefinitionNotExistException("No stream found with name: " + streamId);
        }
        streamCallback.setStreamDefinition(this.streamDefinitionMap.get(streamId));
        streamCallback.setContext(this.siddhiAppContext);
        streamJunction.subscribe(streamCallback);
    }

    @Override
    public void addCallback(String queryName, QueryCallback callback) {
        callback.setQueryName(queryName);
        callback.setContext(this.siddhiAppContext);
        QueryRuntime queryRuntime = this.queryProcessorMap.get(queryName);
        if (queryRuntime == null) {
            throw new QueryNotExistException("No query found with name: " + queryName);
        }
        callback.setQuery(queryRuntime.getQuery());
        ((QueryRuntimeImpl)queryRuntime).addCallback(callback);
    }

    @Override
    public void removeCallback(StreamCallback streamCallback) {
        if (streamCallback.getStreamId() == null) {
            throw new SiddhiAppRuntimeException("Cannot find streamID in the streamCallback");
        }
        String streamId = streamCallback.getStreamId();
        StreamJunction streamJunction = this.streamJunctionMap.get(streamId);
        if (streamJunction != null) {
            streamJunction.unsubscribe(streamCallback);
        }
    }

    @Override
    public void removeCallback(QueryCallback callback) {
        if (callback.getQueryName() == null) {
            throw new SiddhiAppRuntimeException("Cannot find QueryName in the queryCallback");
        }
        String queryName = callback.getQueryName();
        QueryRuntime queryRuntime = this.queryProcessorMap.get(queryName);
        if (queryRuntime != null) {
            ((QueryRuntimeImpl)queryRuntime).removeCallback(callback);
        }
    }

    @Override
    public Event[] query(String onDemandQuery) {
        if (this.running) {
            return this.query(SiddhiCompiler.parseOnDemandQuery((String)onDemandQuery), onDemandQuery);
        }
        throw new OnDemandQueryCreationException("The siddhi app, '" + this.getName() + "' is currently shut down, the on demand query '" + onDemandQuery + "' cannot be executed.");
    }

    @Override
    public Event[] query(OnDemandQuery onDemandQuery) {
        if (this.running) {
            return this.query(onDemandQuery, null);
        }
        throw new OnDemandQueryCreationException("The siddhi app, '" + this.getName() + "' is currently shut down, the on demand query '" + onDemandQuery.toString() + "' cannot be executed.");
    }

    @Override
    @Deprecated
    public Event[] query(StoreQuery storeQuery) {
        if (this.running) {
            return this.query(storeQuery.getOnDemandQuery(), null);
        }
        throw new OnDemandQueryCreationException("The siddhi app, '" + this.getName() + "' is currently shut down, the on demand query '" + storeQuery.getOnDemandQuery().toString() + "' cannot be executed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event[] query(OnDemandQuery onDemandQuery, String onDemandQueryString) {
        try {
            if (Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0 && this.onDemandQueryLatencyTracker != null) {
                this.onDemandQueryLatencyTracker.markIn();
            }
            Event[] eventArray = this;
            synchronized (this) {
                Iterator<Map.Entry<OnDemandQuery, OnDemandQueryRuntime>> i;
                OnDemandQueryRuntime onDemandQueryRuntime = (OnDemandQueryRuntime)this.onDemandQueryRuntimeMap.remove(onDemandQuery);
                if (onDemandQueryRuntime == null) {
                    onDemandQueryRuntime = OnDemandQueryParser.parse(onDemandQuery, onDemandQueryString, this.siddhiAppContext, this.tableMap, this.windowMap, this.aggregationMap);
                } else {
                    onDemandQueryRuntime.reset();
                }
                this.onDemandQueryRuntimeMap.put(onDemandQuery, onDemandQueryRuntime);
                if (this.onDemandQueryRuntimeMap.size() > 50 && (i = this.onDemandQueryRuntimeMap.entrySet().iterator()).hasNext()) {
                    i.next();
                    i.remove();
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                eventArray = onDemandQueryRuntime.execute();
                return eventArray;
            }
        }
        catch (RuntimeException e) {
            if (e instanceof SiddhiAppContextException) {
                throw new OnDemandQueryCreationException(((SiddhiAppContextException)e).getMessageWithOutContext(), e, ((SiddhiAppContextException)e).getQueryContextStartIndex(), ((SiddhiAppContextException)e).getQueryContextEndIndex(), null, onDemandQueryString);
            }
            throw new OnDemandQueryCreationException(e.getMessage(), e);
        }
        finally {
            if (Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0 && this.onDemandQueryLatencyTracker != null) {
                this.onDemandQueryLatencyTracker.markOut();
            }
        }
    }

    @Override
    public Attribute[] getOnDemandQueryOutputAttributes(String onDemandQuery) {
        return this.getOnDemandQueryOutputAttributes(SiddhiCompiler.parseOnDemandQuery((String)onDemandQuery), onDemandQuery);
    }

    @Override
    public Attribute[] getOnDemandQueryOutputAttributes(OnDemandQuery onDemandQuery) {
        return this.getOnDemandQueryOutputAttributes(onDemandQuery, null);
    }

    @Override
    @Deprecated
    public Attribute[] getStoreQueryOutputAttributes(String onDemandQuery) {
        return this.getOnDemandQueryOutputAttributes(SiddhiCompiler.parseOnDemandQuery((String)onDemandQuery), onDemandQuery);
    }

    @Override
    @Deprecated
    public Attribute[] getStoreQueryOutputAttributes(StoreQuery storeQuery) {
        return this.getOnDemandQueryOutputAttributes(storeQuery.getOnDemandQuery(), null);
    }

    private Attribute[] getOnDemandQueryOutputAttributes(OnDemandQuery onDemandQuery, String onDemandQueryString) {
        try {
            OnDemandQueryRuntime onDemandQueryRuntime = this.onDemandQueryRuntimeMap.get(onDemandQuery);
            if (onDemandQueryRuntime == null) {
                onDemandQueryRuntime = OnDemandQueryParser.parse(onDemandQuery, onDemandQueryString, this.siddhiAppContext, this.tableMap, this.windowMap, this.aggregationMap);
                this.onDemandQueryRuntimeMap.put(onDemandQuery, onDemandQueryRuntime);
            }
            return onDemandQueryRuntime.getOnDemandQueryOutputAttributes();
        }
        catch (RuntimeException e) {
            if (e instanceof SiddhiAppContextException) {
                throw new OnDemandQueryCreationException(((SiddhiAppContextException)e).getMessageWithOutContext(), e, ((SiddhiAppContextException)e).getQueryContextStartIndex(), ((SiddhiAppContextException)e).getQueryContextEndIndex(), null, this.siddhiAppContext.getSiddhiAppString());
            }
            throw new OnDemandQueryCreationException(e.getMessage(), e);
        }
    }

    @Override
    public InputHandler getInputHandler(String streamId) {
        return this.inputManager.getInputHandler(streamId);
    }

    @Override
    public TableInputHandler getTableInputHandler(String tableId) {
        return this.inputManager.getTableInputHandler(tableId);
    }

    @Override
    public Collection<List<Source>> getSources() {
        return this.sourceMap.values();
    }

    @Override
    public Collection<List<Sink>> getSinks() {
        return this.sinkMap.values();
    }

    @Override
    public Collection<Table> getTables() {
        return this.tableMap.values();
    }

    @Override
    public Collection<Window> getWindows() {
        return this.windowMap.values();
    }

    @Override
    public Collection<Trigger> getTiggers() {
        return this.triggerMap.values();
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            log.warn("Error calling start() for Siddhi App '" + this.siddhiAppContext.getName() + "', SiddhiApp already started.");
            return;
        }
        if (!this.runningWithoutSources) {
            this.startWithoutSources();
        }
        if (this.runningWithoutSources) {
            this.startSources();
        }
    }

    @Override
    public synchronized void startWithoutSources() {
        if (this.running || this.runningWithoutSources) {
            log.warn("Error calling startWithoutSources() for Siddhi App '" + this.siddhiAppContext.getName() + "', SiddhiApp already started.");
        } else {
            try {
                this.memoryUsageTracker.disableMemoryUsageMetrics();
                if (this.siddhiAppContext.getRootMetricsLevel().compareTo(Level.OFF) != 0 && this.siddhiAppContext.getStatisticsManager() != null) {
                    if (this.siddhiAppContext.getRootMetricsLevel().compareTo(Level.DETAIL) == 0) {
                        this.memoryUsageTracker.enableMemoryUsageMetrics();
                    }
                    this.siddhiAppContext.getStatisticsManager().startReporting();
                }
                for (ExternalReferencedHolder externalReferencedHolder : this.siddhiAppContext.getExternalReferencedHolders()) {
                    externalReferencedHolder.start();
                }
                for (List list : this.sinkMap.values()) {
                    for (Sink sink : list) {
                        sink.connectWithRetry();
                    }
                }
                for (Table table : this.tableMap.values()) {
                    table.connectWithRetry();
                }
                for (StreamJunction streamJunction : this.streamJunctionMap.values()) {
                    streamJunction.startProcessing();
                }
                if (this.incrementalDataPurging) {
                    for (AggregationRuntime aggregationRuntime : this.aggregationMap.values()) {
                        aggregationRuntime.startPurging();
                    }
                }
                for (Trigger trigger : this.siddhiAppContext.getTriggerHolders()) {
                    trigger.start();
                }
                this.inputManager.connect();
                this.runningWithoutSources = true;
            }
            catch (Throwable t) {
                log.error("Error starting Siddhi App '" + this.siddhiAppContext.getName() + "', triggering shutdown process. " + t.getMessage());
                try {
                    this.shutdown();
                }
                catch (Throwable throwable) {
                    log.error("Error shutting down partially started Siddhi App '" + this.siddhiAppContext.getName() + "', " + throwable.getMessage());
                }
            }
        }
    }

    @Override
    public void setPurgingEnabled(boolean purgingEnabled) {
        this.incrementalDataPurging = purgingEnabled;
    }

    @Override
    public void startSources() {
        if (this.running) {
            log.warn("Error calling startSources() for Siddhi App '" + this.siddhiAppContext.getName() + "', SiddhiApp already started with the sources.");
            return;
        }
        if (!this.runningWithoutSources) {
            throw new SiddhiAppRuntimeException("Cannot call startSources() without calling startWithoutSources() for Siddhi App '" + this.siddhiAppContext.getName() + "'");
        }
        try {
            for (List<Source> sources : this.sourceMap.values()) {
                for (Source source : sources) {
                    source.connectWithRetry();
                }
            }
            this.running = true;
            this.runningWithoutSources = false;
        }
        catch (Throwable t) {
            log.error("Error starting Siddhi App '" + this.siddhiAppContext.getName() + "', triggering shutdown process. " + t.getMessage());
            try {
                this.shutdown();
            }
            catch (Throwable t1) {
                log.error("Error shutting down partially started Siddhi App '" + this.siddhiAppContext.getName() + "', " + t1.getMessage());
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        SourceHandlerManager sourceHandlerManager = this.siddhiAppContext.getSiddhiContext().getSourceHandlerManager();
        for (List<Source> list : this.sourceMap.values()) {
            for (Source source : list) {
                try {
                    if (sourceHandlerManager != null) {
                        sourceHandlerManager.unregisterSourceHandler(source.getMapper().getHandler().getId());
                    }
                    source.shutdown();
                }
                catch (Throwable t) {
                    log.error(StringUtil.removeCRLFCharacters(ExceptionUtil.getMessageWithContext(t, this.siddhiAppContext)) + " Error in shutting down source '" + StringUtil.removeCRLFCharacters(source.getType()) + "' at '" + StringUtil.removeCRLFCharacters(source.getStreamDefinition().getId()) + "' on Siddhi App '" + this.siddhiAppContext.getName() + "'.", t);
                }
            }
        }
        for (Table table : this.tableMap.values()) {
            try {
                table.shutdown();
            }
            catch (Throwable throwable) {
                log.error(StringUtil.removeCRLFCharacters(ExceptionUtil.getMessageWithContext(throwable, this.siddhiAppContext)) + " Error in shutting down table '" + StringUtil.removeCRLFCharacters(table.getTableDefinition().getId()) + "' on Siddhi App '" + StringUtil.removeCRLFCharacters(this.siddhiAppContext.getName()) + "'.", throwable);
            }
        }
        SinkHandlerManager sinkHandlerManager = this.siddhiAppContext.getSiddhiContext().getSinkHandlerManager();
        for (List<Sink> list : this.sinkMap.values()) {
            for (Sink sink : list) {
                try {
                    if (sinkHandlerManager != null) {
                        sinkHandlerManager.unregisterSinkHandler(sink.getHandler().getId());
                    }
                    sink.shutdown();
                }
                catch (Throwable t) {
                    log.error(StringUtil.removeCRLFCharacters(ExceptionUtil.getMessageWithContext(t, this.siddhiAppContext)) + " Error in shutting down sink '" + StringUtil.removeCRLFCharacters(sink.getType()) + "' at '" + StringUtil.removeCRLFCharacters(sink.getStreamDefinition().getId()) + "' on Siddhi App '" + StringUtil.removeCRLFCharacters(this.siddhiAppContext.getName()) + "'.", t);
                }
            }
        }
        for (Table table : this.tableMap.values()) {
            RecordTableHandlerManager recordTableHandlerManager = this.siddhiAppContext.getSiddhiContext().getRecordTableHandlerManager();
            if (recordTableHandlerManager != null) {
                String elementId = null;
                RecordTableHandler recordTableHandler = table.getHandler();
                if (recordTableHandler != null) {
                    elementId = recordTableHandler.getId();
                }
                if (elementId != null) {
                    recordTableHandlerManager.unregisterRecordTableHandler(elementId);
                }
            }
            table.shutdown();
        }
        for (ExternalReferencedHolder externalReferencedHolder : this.siddhiAppContext.getExternalReferencedHolders()) {
            try {
                externalReferencedHolder.stop();
            }
            catch (Throwable throwable) {
                log.error(StringUtil.removeCRLFCharacters(ExceptionUtil.getMessageWithContext(throwable, this.siddhiAppContext)) + " Error while stopping ExternalReferencedHolder '" + StringUtil.removeCRLFCharacters(externalReferencedHolder.toString()) + "' down Siddhi app '" + StringUtil.removeCRLFCharacters(this.siddhiAppContext.getName()) + "'.", throwable);
            }
        }
        this.inputManager.disconnect();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                for (StreamJunction streamJunction : SiddhiAppRuntimeImpl.this.streamJunctionMap.values()) {
                    streamJunction.stopProcessing();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SiddhiAppRuntimeImpl.this.siddhiAppContext.getScheduledExecutorService().shutdownNow();
                SiddhiAppRuntimeImpl.this.siddhiAppContext.getExecutorService().shutdownNow();
            }
        }, "Siddhi-SiddhiApp-" + this.siddhiAppContext.getName() + "-Shutdown-Cleaner");
        thread.start();
        if (this.siddhiAppRuntimeMap != null) {
            this.siddhiAppRuntimeMap.remove(this.siddhiAppContext.getName());
        }
        if (this.siddhiAppContext.getStatisticsManager() != null) {
            if (this.siddhiAppContext.getRootMetricsLevel().compareTo(Level.OFF) != 0) {
                this.siddhiAppContext.getStatisticsManager().stopReporting();
            }
            this.siddhiAppContext.getStatisticsManager().cleanup();
        }
        this.running = false;
        this.runningWithoutSources = false;
    }

    @Override
    public synchronized SiddhiDebugger debug() {
        this.siddhiDebugger = new SiddhiDebugger(this.siddhiAppContext);
        ArrayList<StreamRuntime> streamRuntime = new ArrayList<StreamRuntime>();
        ArrayList<OutputCallback> streamCallbacks = new ArrayList<OutputCallback>();
        for (QueryRuntime queryRuntime : this.queryProcessorMap.values()) {
            streamRuntime.add(((QueryRuntimeImpl)queryRuntime).getStreamRuntime());
            streamCallbacks.add(((QueryRuntimeImpl)queryRuntime).getOutputCallback());
        }
        for (StreamRuntime streamRuntime1 : streamRuntime) {
            for (SingleStreamRuntime singleStreamRuntime : streamRuntime1.getSingleStreamRuntimes()) {
                singleStreamRuntime.getProcessStreamReceiver().setSiddhiDebugger(this.siddhiDebugger);
            }
        }
        for (OutputCallback callback : streamCallbacks) {
            callback.setSiddhiDebugger(this.siddhiDebugger);
        }
        this.start();
        return this.siddhiDebugger;
    }

    @Override
    public PersistenceReference persist() {
        try {
            this.sourceMap.values().forEach(list -> list.forEach(Source::pause));
            if (this.siddhiAppContext.getSiddhiContext().getPersistenceStore() != null) {
                PersistenceReference persistenceReference = PersistenceHelper.persist(this.siddhiAppContext.getSnapshotService().fullSnapshot(), this.siddhiAppContext);
                return persistenceReference;
            }
            PersistenceReference persistenceReference = PersistenceHelper.persist(this.siddhiAppContext.getSnapshotService().incrementalSnapshot(), this.siddhiAppContext);
            return persistenceReference;
        }
        finally {
            this.sourceMap.values().forEach(list -> list.forEach(Source::resume));
        }
    }

    @Override
    public byte[] snapshot() {
        try {
            this.sourceMap.values().forEach(list -> list.forEach(Source::pause));
            byte[] byArray = this.siddhiAppContext.getSnapshotService().fullSnapshot();
            return byArray;
        }
        finally {
            this.sourceMap.values().forEach(list -> list.forEach(Source::resume));
        }
    }

    @Override
    public void restore(byte[] snapshot) throws CannotRestoreSiddhiAppStateException {
        try {
            this.sourceMap.values().forEach(list -> list.forEach(Source::pause));
            this.siddhiAppContext.getSnapshotService().restore(snapshot);
        }
        finally {
            this.sourceMap.values().forEach(list -> list.forEach(Source::resume));
        }
    }

    @Override
    public void restoreRevision(String revision) throws CannotRestoreSiddhiAppStateException {
        try {
            this.sourceMap.values().forEach(list -> list.forEach(Source::pause));
            this.siddhiAppContext.getSnapshotService().restoreRevision(revision);
        }
        finally {
            this.sourceMap.values().forEach(list -> list.forEach(Source::resume));
        }
    }

    @Override
    public String restoreLastRevision() throws CannotRestoreSiddhiAppStateException {
        String revision;
        try {
            this.sourceMap.values().forEach(list -> list.forEach(Source::pause));
            revision = this.siddhiAppContext.getSnapshotService().restoreLastRevision();
        }
        finally {
            this.sourceMap.values().forEach(list -> list.forEach(Source::resume));
        }
        return revision;
    }

    @Override
    public void clearAllRevisions() throws CannotClearSiddhiAppStateException {
        try {
            this.sourceMap.values().forEach(list -> list.forEach(Source::pause));
            this.siddhiAppContext.getSnapshotService().clearAllRevisions();
        }
        finally {
            this.sourceMap.values().forEach(list -> list.forEach(Source::resume));
        }
    }

    private void monitorQueryMemoryUsage() {
        this.memoryUsageTracker = this.siddhiAppContext.getSiddhiContext().getStatisticsConfiguration().getFactory().createMemoryUsageTracker(this.siddhiAppContext.getStatisticsManager());
        for (Map.Entry<String, QueryRuntime> entry : this.queryProcessorMap.entrySet()) {
            QueryParserHelper.registerMemoryUsageTracking(entry.getKey(), entry.getValue(), "Queries", this.siddhiAppContext, this.memoryUsageTracker);
        }
        for (PartitionRuntime partitionRuntime : this.partitionMap.values()) {
            ((PartitionRuntimeImpl)partitionRuntime).setMemoryUsageTracker(this.memoryUsageTracker);
        }
        for (Map.Entry entry : this.tableMap.entrySet()) {
            QueryParserHelper.registerMemoryUsageTracking((String)entry.getKey(), entry.getValue(), "Tables", this.siddhiAppContext, this.memoryUsageTracker);
        }
        for (Map.Entry entry : this.windowMap.entrySet()) {
            QueryParserHelper.registerMemoryUsageTracking((String)entry.getKey(), entry.getValue(), "Windows", this.siddhiAppContext, this.memoryUsageTracker);
        }
        for (Map.Entry entry : this.aggregationMap.entrySet()) {
            QueryParserHelper.registerMemoryUsageTracking((String)entry.getKey(), entry.getValue(), "Aggregations", this.siddhiAppContext, this.memoryUsageTracker);
        }
    }

    private void monitorBufferedEvents() {
        this.bufferedEventsTracker = this.siddhiAppContext.getSiddhiContext().getStatisticsConfiguration().getFactory().createBufferSizeTracker(this.siddhiAppContext.getStatisticsManager());
        for (Map.Entry<String, StreamJunction> entry : this.streamJunctionMap.entrySet()) {
            this.registerForBufferedEvents(entry);
        }
        for (Map.Entry<String, Object> entry : this.partitionMap.entrySet()) {
            ConcurrentMap<String, StreamJunction> streamJunctionMap = ((PartitionRuntimeImpl)entry.getValue()).getLocalStreamJunctionMap();
            for (Map.Entry<String, StreamJunction> entry2 : streamJunctionMap.entrySet()) {
                this.registerForBufferedEvents(entry2);
            }
        }
    }

    private void registerForBufferedEvents(Map.Entry<String, StreamJunction> entry) {
        if (entry.getValue().containsBufferedEvents()) {
            String metricName = this.siddhiAppContext.getSiddhiContext().getStatisticsConfiguration().getMetricPrefix() + "." + "SiddhiApps" + "." + this.getName() + "." + "Siddhi" + "." + "Streams" + "." + entry.getKey() + "." + "size";
            boolean matchExist = false;
            for (String regex : this.siddhiAppContext.getIncludedMetrics()) {
                if (!metricName.matches(regex)) continue;
                matchExist = true;
                break;
            }
            if (matchExist) {
                this.bufferedEventsTracker.registerEventBufferHolder(entry.getValue(), metricName);
            }
        }
    }

    @Override
    public void handleExceptionWith(ExceptionHandler<Object> exceptionHandler) {
        this.siddhiAppContext.setDisruptorExceptionHandler(exceptionHandler);
    }

    @Override
    public void handleRuntimeExceptionWith(ExceptionListener exceptionListener) {
        this.siddhiAppContext.setRuntimeExceptionListener(exceptionListener);
    }

    @Override
    public SiddhiApp getSiddhiApp() {
        return this.siddhiAppContext.getSiddhiApp();
    }

    @Override
    public Collection<QueryRuntime> getQueries() {
        return this.queryProcessorMap.values();
    }

    @Override
    public Collection<PartitionRuntime> getPartitions() {
        return this.partitionMap.values();
    }

    @Override
    public Level getStatisticsLevel() {
        return this.siddhiAppContext.getRootMetricsLevel();
    }

    @Override
    public void setStatisticsLevel(Level level) {
        if (this.running && this.siddhiAppContext.getStatisticsManager() != null) {
            if (this.siddhiAppContext.getRootMetricsLevel().compareTo(level) == 0) {
                if (level == Level.OFF) {
                    log.info("Siddhi App '" + this.getName() + "' statistics reporting is already disabled!");
                } else if (level == Level.BASIC || level == Level.DETAIL) {
                    log.info("Siddhi App '" + this.getName() + "' statistics reporting is already in " + level + " level!");
                }
            } else if (level == Level.OFF) {
                this.memoryUsageTracker.disableMemoryUsageMetrics();
                this.siddhiAppContext.setRootMetricsLevel(Level.OFF);
                this.siddhiAppContext.getStatisticsManager().stopReporting();
                log.info("Siddhi App '" + this.getName() + "' statistics reporting stopped!");
            } else {
                if (this.siddhiAppContext.getRootMetricsLevel().compareTo(Level.OFF) == 0) {
                    this.siddhiAppContext.getStatisticsManager().startReporting();
                    log.debug("Siddhi App '" + this.getName() + "' statistics reporting started!");
                }
                if (level == Level.DETAIL) {
                    this.memoryUsageTracker.enableMemoryUsageMetrics();
                }
                this.siddhiAppContext.setRootMetricsLevel(level);
                log.info("Siddhi App '" + this.getName() + "' statistics reporting changed to: " + level.toString());
            }
        } else if (this.running) {
            log.debug("Siddhi App '" + this.getName() + "' statistics reporting not changed, as app has not started running!");
        } else {
            log.debug("Siddhi App '" + this.getName() + "' statistics reporting not changed, as StatisticsManager is not defined!");
        }
    }

    @Override
    public void enablePlayBack(boolean playBackEnabled, Long idleTime, Long incrementInMilliseconds) {
        this.siddhiAppContext.setPlayback(playBackEnabled);
        if (!playBackEnabled) {
            for (Scheduler scheduler : this.siddhiAppContext.getSchedulerList()) {
                scheduler.switchToLiveMode();
            }
        } else {
            if (idleTime != null && incrementInMilliseconds != null) {
                this.siddhiAppContext.getTimestampGenerator().setIdleTime(idleTime);
                this.siddhiAppContext.getTimestampGenerator().setIncrementInMilliseconds(incrementInMilliseconds);
            }
            for (Scheduler scheduler : this.siddhiAppContext.getSchedulerList()) {
                scheduler.switchToPlayBackMode();
            }
        }
    }

    private void collectDeprecateWarnings() {
        Map<String, Class> deprecatedExtensions = this.siddhiAppContext.getSiddhiContext().getDeprecatedSiddhiExtensions();
        ArrayList<AbstractDefinition> extensionsInUse = new ArrayList<AbstractDefinition>();
        extensionsInUse.addAll(this.streamDefinitionMap.values());
        extensionsInUse.addAll(this.tableDefinitionMap.values());
        extensionsInUse.addAll(this.windowDefinitionMap.values());
        extensionsInUse.addAll(this.aggregationDefinitionMap.values());
        for (AbstractDefinition extDefinition : extensionsInUse) {
            for (Annotation annotation : extDefinition.getAnnotations()) {
                String type = annotation.getElement("type");
                if (annotation.getName().equalsIgnoreCase("Source")) {
                    type = "source:" + type;
                }
                if (annotation.getName().equalsIgnoreCase("Sink")) {
                    type = "sink:" + type;
                }
                if (annotation.getName().equalsIgnoreCase("Store")) {
                    type = "store:" + type;
                }
                if (type == null || !deprecatedExtensions.containsKey(type)) continue;
                Class ext = deprecatedExtensions.get(type);
                Extension extAnnotation = ext.getAnnotation(Extension.class);
                String warning = extAnnotation.deprecationNotice().isEmpty() ? type + " is being deprecated." : extAnnotation.deprecationNotice();
                this.warnings.add(warning);
                log.warn(warning);
            }
        }
    }

    @Override
    public Set<String> getWarnings() {
        return this.warnings;
    }
}

