/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.aggregation;

import io.siddhi.core.aggregation.AggregationRuntime;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.incremental.IncrementalUnixTimeFunctionExecutor;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.util.statistics.LatencyTracker;
import io.siddhi.core.util.statistics.ThroughputTracker;
import io.siddhi.core.util.statistics.metrics.Level;
import java.util.List;

public class IncrementalAggregationProcessor
implements Processor {
    private final List<ExpressionExecutor> incomingExpressionExecutors;
    private final StreamEventFactory streamEventFactory;
    private final LatencyTracker latencyTrackerInsert;
    private final ThroughputTracker throughputTrackerInsert;
    private SiddhiAppContext siddhiAppContext;
    private AggregationRuntime aggregationRuntime;
    private boolean isFirstEventArrived = false;

    public IncrementalAggregationProcessor(AggregationRuntime aggregationRuntime, List<ExpressionExecutor> incomingExpressionExecutors, MetaStreamEvent processedMetaStreamEvent, LatencyTracker latencyTrackerInsert, ThroughputTracker throughputTrackerInsert, SiddhiAppContext siddhiAppContext) {
        this.aggregationRuntime = aggregationRuntime;
        this.incomingExpressionExecutors = incomingExpressionExecutors;
        this.streamEventFactory = new StreamEventFactory(processedMetaStreamEvent);
        this.latencyTrackerInsert = latencyTrackerInsert;
        this.throughputTrackerInsert = throughputTrackerInsert;
        this.siddhiAppContext = siddhiAppContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<StreamEvent> streamEventChunk = new ComplexEventChunk<StreamEvent>();
        try {
            int noOfEvents = 0;
            if (this.latencyTrackerInsert != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                this.latencyTrackerInsert.markIn();
            }
            while (complexEventChunk.hasNext()) {
                Object complexEvent = complexEventChunk.next();
                if (!this.isFirstEventArrived) {
                    this.aggregationRuntime.initialiseExecutors(true);
                    this.isFirstEventArrived = true;
                }
                StreamEvent newEvent = this.streamEventFactory.newInstance();
                for (int i = 0; i < this.incomingExpressionExecutors.size(); ++i) {
                    ExpressionExecutor expressionExecutor = this.incomingExpressionExecutors.get(i);
                    Object outputData = expressionExecutor.execute((ComplexEvent)complexEvent);
                    if (expressionExecutor instanceof IncrementalUnixTimeFunctionExecutor && outputData == null) {
                        throw new SiddhiAppRuntimeException("Cannot retrieve the timestamp of event");
                    }
                    newEvent.setOutputData(outputData, i);
                }
                streamEventChunk.add(newEvent);
                ++noOfEvents;
            }
            this.aggregationRuntime.processEvents(streamEventChunk);
            if (this.throughputTrackerInsert != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                this.throughputTrackerInsert.eventsIn(noOfEvents);
            }
        }
        finally {
            if (this.latencyTrackerInsert != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
                this.latencyTrackerInsert.markOut();
            }
        }
    }

    @Override
    public void process(List<ComplexEventChunk> complexEventChunks) {
        ComplexEventChunk complexEventChunk = new ComplexEventChunk();
        for (ComplexEventChunk streamEventChunk : complexEventChunks) {
            complexEventChunk.addAll(streamEventChunk);
        }
        this.process(complexEventChunk);
    }

    @Override
    public Processor getNextProcessor() {
        return null;
    }

    @Override
    public void setNextProcessor(Processor processor) {
        throw new SiddhiAppCreationException("IncrementalAggregationProcessor does not support any next processor");
    }

    @Override
    public void setToLast(Processor processor) {
        throw new SiddhiAppCreationException("IncrementalAggregationProcessor does not support any next/last processor");
    }
}

