/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.time;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import io.siddhi.core.util.Schedulable;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FirstPerTimeOutputRateLimiter
extends OutputRateLimiter<RateLimiterState>
implements Schedulable {
    private static final Logger log = LogManager.getLogger(FirstPerTimeOutputRateLimiter.class);
    private final Long value;
    private String id;

    public FirstPerTimeOutputRateLimiter(String id, Long value) {
        this.id = id;
        this.value = value;
    }

    @Override
    protected StateFactory<RateLimiterState> init() {
        return () -> new RateLimiterState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<Object> outputEventChunk = new ComplexEventChunk<Object>();
        complexEventChunk.reset();
        RateLimiterState state = (RateLimiterState)this.stateHolder.getState();
        try {
            RateLimiterState rateLimiterState = state;
            synchronized (rateLimiterState) {
                long currentTime = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime();
                if (state.outputTime == null || state.outputTime + this.value <= currentTime) {
                    state.outputTime = currentTime;
                    Object event = complexEventChunk.next();
                    complexEventChunk.remove();
                    outputEventChunk.add(event);
                }
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
        outputEventChunk.reset();
        if (outputEventChunk.hasNext()) {
            this.sendToCallBacks(outputEventChunk);
        }
    }

    @Override
    public void partitionCreated() {
    }

    class RateLimiterState
    extends State {
        private Long outputTime;

        RateLimiterState() {
        }

        @Override
        public boolean canDestroy() {
            return this.outputTime == null;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("OutputTime", this.outputTime);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.outputTime = (Long)state.get("OutputTime");
        }
    }
}

