/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.processor.stream.window;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.stream.window.SlidingFindableWindowProcessor;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.collection.operator.Operator;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.parser.OperatorParser;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.expression.Expression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Extension(name="lossyFrequent", namespace="", description="This window identifies and returns all the events of which the current frequency exceeds the value specified for the supportThreshold parameter.", deprecated=true, parameters={@Parameter(name="support.threshold", description="The support threshold value.", type={DataType.DOUBLE}), @Parameter(name="error.bound", description="The error bound value.", optional=true, defaultValue="`support.threshold`/10", type={DataType.DOUBLE}), @Parameter(name="attribute", description="The attributes to group the events. If no attributes are given, the concatenation of all the attributes of the event is considered.", type={DataType.STRING}, optional=true, dynamic=true, defaultValue="The concatenation of all the attributes of the event is considered.")}, parameterOverloads={@ParameterOverload(parameterNames={"support.threshold"}), @ParameterOverload(parameterNames={"support.threshold", "error.bound"}), @ParameterOverload(parameterNames={"support.threshold", "error.bound", "attribute"})}, examples={@Example(syntax="define stream purchase (cardNo string, price float);\ndefine window purchaseWindow (cardNo string, price float) lossyFrequent(0.1, 0.01);\n@info(name = 'query0')\nfrom purchase[price >= 30]\ninsert into purchaseWindow;\n@info(name = 'query1')\nfrom purchaseWindow\nselect cardNo, price\ninsert all events into PotentialFraud;", description="lossyFrequent(0.1, 0.01) returns all the events of which the current frequency exceeds 0.1, with an error bound of 0.01."), @Example(syntax="define stream purchase (cardNo string, price float);\ndefine window purchaseWindow (cardNo string, price float) lossyFrequent(0.3, 0.05, cardNo);\n@info(name = 'query0')\nfrom purchase[price >= 30]\ninsert into purchaseWindow;\n@info(name = 'query1')\nfrom purchaseWindow\nselect cardNo, price\ninsert all events into PotentialFraud;", description="lossyFrequent(0.3, 0.05, cardNo) returns all the events of which the cardNo attributes frequency exceeds 0.3, with an error bound of 0.05.")})
@Deprecated
public class LossyFrequentWindowProcessor
extends SlidingFindableWindowProcessor<WindowState> {
    private static final Logger log = LogManager.getLogger(LossyFrequentWindowProcessor.class);
    private VariableExpressionExecutor[] variableExpressionExecutors;
    private double support;
    private double error;
    private double windowWidth;

    @Override
    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        this.support = Double.parseDouble(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue()));
        this.error = attributeExpressionExecutors.length > 1 ? Double.parseDouble(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue())) : this.support / 10.0;
        if (this.support > 1.0 || this.support < 0.0 || this.error > 1.0 || this.error < 0.0) {
            log.error("Wrong argument has provided, Error executing the window");
        }
        this.variableExpressionExecutors = new VariableExpressionExecutor[attributeExpressionExecutors.length - 2];
        if (attributeExpressionExecutors.length > 2) {
            for (int i = 2; i < attributeExpressionExecutors.length; ++i) {
                this.variableExpressionExecutors[i - 2] = (VariableExpressionExecutor)attributeExpressionExecutors[i];
            }
        }
        this.windowWidth = Math.ceil(1.0 / this.error);
        return () -> new WindowState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, WindowState state) {
        WindowState windowState = state;
        synchronized (windowState) {
            long currentTime = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime();
            StreamEvent streamEvent = streamEventChunk.getFirst();
            streamEventChunk.clear();
            while (streamEvent != null) {
                LossyCount lossyCount;
                StreamEvent next = streamEvent.getNext();
                streamEvent.setNext(null);
                StreamEvent clonedEvent = streamEventCloner.copyStreamEvent(streamEvent);
                clonedEvent.setType(ComplexEvent.Type.EXPIRED);
                state.totalCount++;
                if (state.totalCount != 1) {
                    state.currentBucketId = Math.ceil((double)state.totalCount / this.windowWidth);
                }
                String currentKey = this.generateKey(streamEvent);
                StreamEvent oldEvent = state.map.put(currentKey, clonedEvent);
                if (oldEvent != null) {
                    state.countMap.put(currentKey, ((LossyCount)state.countMap.get(currentKey)).incrementCount());
                } else {
                    LossyCount lCount = new LossyCount(1, (int)state.currentBucketId - 1);
                    state.countMap.put(currentKey, lCount);
                }
                ArrayList keys = new ArrayList();
                keys.addAll(state.countMap.keySet());
                for (String key : keys) {
                    lossyCount = (LossyCount)state.countMap.get(key);
                    if (!((double)lossyCount.getCount() >= (this.support - this.error) * (double)state.totalCount) || !key.equals(currentKey)) continue;
                    streamEventChunk.add(streamEvent);
                }
                if ((double)state.totalCount % this.windowWidth == 0.0) {
                    keys = new ArrayList();
                    keys.addAll(state.countMap.keySet());
                    for (String key : keys) {
                        lossyCount = (LossyCount)state.countMap.get(key);
                        if (!((double)(lossyCount.getCount() + lossyCount.getBucketId()) <= state.currentBucketId)) continue;
                        log.info("Removing the Event: " + key + " from the window");
                        state.countMap.remove(key);
                        StreamEvent expirtedEvent = (StreamEvent)state.map.remove(key);
                        expirtedEvent.setTimestamp(currentTime);
                        streamEventChunk.add(expirtedEvent);
                    }
                }
                streamEvent = next;
            }
        }
        nextProcessor.process(streamEventChunk);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    private String generateKey(StreamEvent event) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.variableExpressionExecutors.length == 0) {
            for (Object data : event.getOutputData()) {
                stringBuilder.append(data);
            }
        } else {
            for (VariableExpressionExecutor executor : this.variableExpressionExecutors) {
                stringBuilder.append(event.getAttribute(executor.getPosition()));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, WindowState state, SiddhiQueryContext siddhiQueryContext) {
        return OperatorParser.constructOperator(state.map.values(), condition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition, StreamEventCloner streamEventCloner, WindowState state) {
        return ((Operator)compiledCondition).find(matchingEvent, state.map.values(), streamEventCloner);
    }

    class WindowState
    extends State {
        private int totalCount = 0;
        private double currentBucketId = 1.0;
        private ConcurrentHashMap<String, LossyCount> countMap = new ConcurrentHashMap();
        private ConcurrentHashMap<String, StreamEvent> map = new ConcurrentHashMap();

        WindowState() {
        }

        @Override
        public boolean canDestroy() {
            return this.countMap.isEmpty() && this.map.isEmpty();
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("CountMap", this.countMap);
            state.put("Map", this.map);
            state.put("TotalCount", this.totalCount);
            state.put("CurrentBucketId", this.currentBucketId);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.countMap = (ConcurrentHashMap)state.get("CountMap");
            this.countMap = (ConcurrentHashMap)state.get("Map");
            this.totalCount = (Integer)state.get("TotalCount");
            this.currentBucketId = (Double)state.get("CurrentBucketId");
        }
    }

    public class LossyCount {
        int count;
        int bucketId;

        public LossyCount(int count, int bucketId) {
            this.count = count;
            this.bucketId = bucketId;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public int getBucketId() {
            return this.bucketId;
        }

        public void setBucketId(int bucketId) {
            this.bucketId = bucketId;
        }

        public LossyCount incrementCount() {
            ++this.count;
            return this;
        }
    }
}

