/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.aggregation;

import io.siddhi.core.aggregation.AggregationExpressionVisitor;
import io.siddhi.core.table.record.ExpressionVisitor;
import io.siddhi.query.api.expression.AttributeFunction;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.Variable;
import io.siddhi.query.api.expression.condition.And;
import io.siddhi.query.api.expression.condition.Compare;
import io.siddhi.query.api.expression.condition.In;
import io.siddhi.query.api.expression.condition.IsNull;
import io.siddhi.query.api.expression.condition.Not;
import io.siddhi.query.api.expression.condition.Or;
import io.siddhi.query.api.expression.constant.Constant;
import io.siddhi.query.api.expression.math.Add;
import io.siddhi.query.api.expression.math.Divide;
import io.siddhi.query.api.expression.math.Mod;
import io.siddhi.query.api.expression.math.Multiply;
import io.siddhi.query.api.expression.math.Subtract;

public class AggregationExpressionBuilder {
    private Expression expression;

    public AggregationExpressionBuilder(Expression expression) {
        this.expression = expression;
    }

    public void build(AggregationExpressionVisitor expressionVisitor) {
        this.build(this.expression, expressionVisitor);
    }

    private void build(Expression expression, AggregationExpressionVisitor expressionVisitor) {
        if (expression instanceof And) {
            this.build(((And)expression).getLeftExpression(), expressionVisitor);
            this.build(((And)expression).getRightExpression(), expressionVisitor);
            expressionVisitor.endVisitAnd();
        } else if (expression instanceof Or) {
            this.build(((Or)expression).getLeftExpression(), expressionVisitor);
            this.build(((Or)expression).getRightExpression(), expressionVisitor);
            expressionVisitor.endVisitOr();
        } else if (expression instanceof Not) {
            this.build(((Not)expression).getExpression(), expressionVisitor);
            expressionVisitor.endVisitNot();
        } else if (expression instanceof Compare) {
            this.build(((Compare)expression).getLeftExpression(), expressionVisitor);
            this.build(((Compare)expression).getRightExpression(), expressionVisitor);
            expressionVisitor.endVisitCompare(((Compare)expression).getOperator());
        } else if (expression instanceof Constant) {
            expressionVisitor.addConstantExpression(expression);
        } else if (expression instanceof Variable) {
            expressionVisitor.addVariableExpression(expression);
        } else if (expression instanceof IsNull) {
            IsNull isNull = (IsNull)expression;
            if (isNull.getExpression() != null) {
                this.build(((IsNull)expression).getExpression(), expressionVisitor);
                expressionVisitor.endVisitIsNull(null);
            }
        } else if (expression instanceof AttributeFunction) {
            Expression[] expressions;
            for (Expression value : expressions = ((AttributeFunction)expression).getParameters()) {
                this.build(value, expressionVisitor);
            }
            expressionVisitor.endVisitAttributeFunction(((AttributeFunction)expression).getNamespace(), ((AttributeFunction)expression).getName(), expressions.length);
        } else if (expression instanceof Add) {
            this.build(((Add)expression).getLeftValue(), expressionVisitor);
            this.build(((Add)expression).getRightValue(), expressionVisitor);
            expressionVisitor.endVisitMath(ExpressionVisitor.MathOperator.ADD);
        } else if (expression instanceof Subtract) {
            this.build(((Subtract)expression).getLeftValue(), expressionVisitor);
            this.build(((Subtract)expression).getRightValue(), expressionVisitor);
            expressionVisitor.endVisitMath(ExpressionVisitor.MathOperator.SUBTRACT);
        } else if (expression instanceof Divide) {
            this.build(((Divide)expression).getLeftValue(), expressionVisitor);
            this.build(((Divide)expression).getRightValue(), expressionVisitor);
            expressionVisitor.endVisitMath(ExpressionVisitor.MathOperator.DIVIDE);
        } else if (expression instanceof Multiply) {
            this.build(((Multiply)expression).getLeftValue(), expressionVisitor);
            this.build(((Multiply)expression).getRightValue(), expressionVisitor);
            expressionVisitor.endVisitMath(ExpressionVisitor.MathOperator.MULTIPLY);
        } else if (expression instanceof Mod) {
            this.build(((Mod)expression).getLeftValue(), expressionVisitor);
            this.build(((Mod)expression).getRightValue(), expressionVisitor);
            expressionVisitor.endVisitMath(ExpressionVisitor.MathOperator.MOD);
        } else if (expression instanceof In) {
            this.build(((In)expression).getExpression(), expressionVisitor);
            expressionVisitor.endVisitIn(((In)expression).getSourceId());
        }
    }
}

