/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.aggregation.persistedaggregation.config;

import com.google.common.collect.Maps;
import io.siddhi.core.aggregation.persistedaggregation.config.DBAggregationQueryConfiguration;
import io.siddhi.core.aggregation.persistedaggregation.config.DBAggregationQueryConfigurationEntry;
import io.siddhi.core.exception.CannotLoadConfigurationException;
import io.siddhi.core.util.parser.AggregationParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DBAggregationQueryUtil {
    private static final Logger LOG = LogManager.getLogger(DBAggregationQueryUtil.class);
    private static DBAggregationConfigurationMapper mapper;

    public static DBAggregationQueryConfigurationEntry lookupCurrentQueryConfigurationEntry(AggregationParser.Database databaseType) throws CannotLoadConfigurationException {
        DBAggregationConfigurationMapper mapper = DBAggregationQueryUtil.loadDBAggregationConfigurationMapper();
        DBAggregationQueryConfigurationEntry entry = mapper.lookupEntry(databaseType.toString());
        if (entry != null) {
            return entry;
        }
        throw new CannotLoadConfigurationException("Cannot find a database section in the RDBMS configuration for the database: " + (Object)((Object)databaseType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DBAggregationConfigurationMapper loadDBAggregationConfigurationMapper() throws CannotLoadConfigurationException {
        if (mapper != null) return mapper;
        Class<DBAggregationQueryUtil> clazz = DBAggregationQueryUtil.class;
        synchronized (DBAggregationQueryUtil.class) {
            DBAggregationQueryConfiguration config = DBAggregationQueryUtil.loadQueryConfiguration();
            mapper = new DBAggregationConfigurationMapper(config);
            // ** MonitorExit[var0] (shouldn't be in output)
            return mapper;
        }
    }

    private static DBAggregationQueryConfiguration loadQueryConfiguration() throws CannotLoadConfigurationException {
        return new DBAggregationConfigLoader().loadConfiguration();
    }

    private static class DBAggregationConfigLoader {
        private DBAggregationConfigLoader() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private DBAggregationQueryConfiguration loadConfiguration() throws CannotLoadConfigurationException {
            DBAggregationQueryConfiguration dBAggregationQueryConfiguration;
            InputStream inputStream = null;
            try {
                JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{DBAggregationQueryConfiguration.class});
                Unmarshaller unmarshaller = ctx.createUnmarshaller();
                ClassLoader classLoader = this.getClass().getClassLoader();
                inputStream = classLoader.getResourceAsStream("db-aggregation-config.xml");
                if (inputStream == null) {
                    throw new CannotLoadConfigurationException("db-aggregation-config.xml is not found in the classpath");
                }
                dBAggregationQueryConfiguration = (DBAggregationQueryConfiguration)unmarshaller.unmarshal(inputStream);
                if (inputStream == null) return dBAggregationQueryConfiguration;
            }
            catch (JAXBException e) {
                try {
                    throw new CannotLoadConfigurationException("Error in processing RDBMS query configuration: " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        LOG.error(String.format("Failed to close the input stream for %s", "db-aggregation-config.xml"));
                    }
                    throw throwable;
                }
            }
            try {
                inputStream.close();
                return dBAggregationQueryConfiguration;
            }
            catch (IOException e) {
                LOG.error(String.format("Failed to close the input stream for %s", "db-aggregation-config.xml"));
            }
            return dBAggregationQueryConfiguration;
        }
    }

    private static class DBAggregationConfigurationMapper {
        private List<Map.Entry<Pattern, DBAggregationQueryConfigurationEntry>> entries = new ArrayList<Map.Entry<Pattern, DBAggregationQueryConfigurationEntry>>();

        public DBAggregationConfigurationMapper(DBAggregationQueryConfiguration config) {
            for (DBAggregationQueryConfigurationEntry entry : config.getDatabases()) {
                this.entries.add(Maps.immutableEntry((Object)Pattern.compile(entry.getDatabaseName().toLowerCase(Locale.ENGLISH)), (Object)entry));
            }
        }

        private List<DBAggregationQueryConfigurationEntry> extractMatchingConfigEntries(String dbName) {
            ArrayList<DBAggregationQueryConfigurationEntry> result = new ArrayList<DBAggregationQueryConfigurationEntry>();
            this.entries.forEach(entry -> {
                if (((Pattern)entry.getKey()).matcher(dbName).find()) {
                    result.add((DBAggregationQueryConfigurationEntry)entry.getValue());
                }
            });
            return result;
        }

        public DBAggregationQueryConfigurationEntry lookupEntry(String dbName) {
            List<DBAggregationQueryConfigurationEntry> dbResults = this.extractMatchingConfigEntries(dbName.toLowerCase(Locale.ENGLISH));
            if (dbResults.isEmpty()) {
                return null;
            }
            return dbResults.get(0);
        }
    }
}

