/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.table.holder;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.Operation;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.event.stream.converter.StreamEventConverter;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.table.holder.IndexedEventHolder;
import io.siddhi.core.table.holder.PrimaryKeyReferenceHolder;
import io.siddhi.core.util.snapshot.SnapshotRequest;
import io.siddhi.core.util.snapshot.state.Snapshot;
import io.siddhi.core.util.snapshot.state.SnapshotStateList;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.expression.condition.Compare;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexEventHolder
implements IndexedEventHolder,
Serializable {
    private static final Logger log = LogManager.getLogger(IndexEventHolder.class);
    private static final long serialVersionUID = 1272291743721603253L;
    private static final float FULL_SNAPSHOT_THRESHOLD = 2.1f;
    protected final Map<Object, StreamEvent> primaryKeyData;
    protected final Map<String, TreeMap<Object, Set<StreamEvent>>> indexData;
    private final PrimaryKeyReferenceHolder[] primaryKeyReferenceHolders;
    private final String tableName;
    private final String siddhiAppName;
    private final transient SiddhiAppContext siddhiAppContext;
    protected String primaryKeyAttributes = null;
    private StreamEventFactory tableStreamEventFactory;
    private StreamEventConverter eventConverter;
    private Map<String, Integer> indexMetaData;
    private Map<String, Integer> multiPrimaryKeyMetaData = new LinkedHashMap<String, Integer>();
    private Map<String, Integer> allIndexMetaData = new HashMap<String, Integer>();
    private ArrayList<Operation> operationChangeLog = new ArrayList();
    private long eventsCount;
    private boolean forceFullSnapshot = true;
    private boolean isOperationLogEnabled = true;

    public IndexEventHolder(StreamEventFactory tableStreamEventFactory, StreamEventConverter eventConverter, PrimaryKeyReferenceHolder[] primaryKeyReferenceHolders, boolean isPrimaryNumeric, Map<String, Integer> indexMetaData, AbstractDefinition tableDefinition, SiddhiAppContext siddhiAppContext) {
        this.tableStreamEventFactory = tableStreamEventFactory;
        this.eventConverter = eventConverter;
        this.primaryKeyReferenceHolders = primaryKeyReferenceHolders;
        this.indexMetaData = indexMetaData;
        this.tableName = tableDefinition.getId();
        this.siddhiAppName = siddhiAppContext.getName();
        this.siddhiAppContext = siddhiAppContext;
        if (primaryKeyReferenceHolders != null) {
            this.primaryKeyData = isPrimaryNumeric ? new TreeMap<Object, StreamEvent>() : new HashMap<Object, StreamEvent>();
            if (primaryKeyReferenceHolders.length == 1) {
                this.allIndexMetaData.put(primaryKeyReferenceHolders[0].getPrimaryKeyAttribute(), primaryKeyReferenceHolders[0].getPrimaryKeyPosition());
                this.primaryKeyAttributes = primaryKeyReferenceHolders[0].getPrimaryKeyAttribute();
            } else {
                StringBuilder primaryKeyAttributesBuilder = new StringBuilder();
                for (PrimaryKeyReferenceHolder primaryKeyReferenceHolder : primaryKeyReferenceHolders) {
                    this.multiPrimaryKeyMetaData.put(primaryKeyReferenceHolder.getPrimaryKeyAttribute(), primaryKeyReferenceHolder.getPrimaryKeyPosition());
                    primaryKeyAttributesBuilder.append(primaryKeyReferenceHolder.getPrimaryKeyAttribute()).append(":-:");
                }
                this.primaryKeyAttributes = primaryKeyAttributesBuilder.toString();
            }
        } else {
            this.primaryKeyData = null;
        }
        if (indexMetaData.size() > 0) {
            this.indexData = new HashMap<String, TreeMap<Object, Set<StreamEvent>>>();
            for (String indexAttributeName : indexMetaData.keySet()) {
                this.indexData.put(indexAttributeName, new TreeMap());
            }
            this.allIndexMetaData.putAll(indexMetaData);
        } else {
            this.indexData = null;
        }
    }

    public void replace(Object key, StreamEvent streamEvent) {
        this.primaryKeyData.replace(key, streamEvent);
    }

    @Override
    public Set<Object> getAllPrimaryKeyValues() {
        if (this.primaryKeyData != null) {
            return this.primaryKeyData.keySet();
        }
        return null;
    }

    @Override
    public PrimaryKeyReferenceHolder[] getPrimaryKeyReferenceHolders() {
        return this.primaryKeyReferenceHolders;
    }

    @Override
    public boolean isMultiPrimaryKeyAttribute(String attributeName) {
        return this.multiPrimaryKeyMetaData.containsKey(attributeName);
    }

    @Override
    public boolean isAttributeIndexed(String attribute) {
        return this.allIndexMetaData.containsKey(attribute);
    }

    @Override
    public boolean isAttributeIndexed(int position) {
        return this.allIndexMetaData.containsValue(position);
    }

    @Override
    public void add(ComplexEventChunk<StreamEvent> addingEventChunk) {
        addingEventChunk.reset();
        while (addingEventChunk.hasNext()) {
            Object complexEvent = addingEventChunk.next();
            StreamEvent streamEvent = this.tableStreamEventFactory.newInstance();
            this.eventConverter.convertComplexEvent((ComplexEvent)complexEvent, streamEvent);
            ++this.eventsCount;
            if (this.isOperationLogEnabled) {
                if (!this.isFullSnapshot()) {
                    StreamEvent streamEvent2 = this.tableStreamEventFactory.newInstance();
                    this.eventConverter.convertComplexEvent((ComplexEvent)complexEvent, streamEvent2);
                    this.operationChangeLog.add(new Operation(Operation.Operator.ADD, streamEvent2));
                } else {
                    this.operationChangeLog.clear();
                    this.forceFullSnapshot = true;
                }
            }
            this.add(streamEvent);
        }
    }

    private void add(StreamEvent streamEvent) {
        Object primaryKey;
        StreamEvent existingValue = null;
        if (this.primaryKeyData != null && (existingValue = this.primaryKeyData.putIfAbsent(primaryKey = this.constructPrimaryKey(streamEvent, this.primaryKeyReferenceHolders), streamEvent)) != null) {
            SiddhiAppRuntimeException e = new SiddhiAppRuntimeException("Siddhi App '" + this.siddhiAppName + "' table '" + this.tableName + "' dropping event : " + streamEvent + ", as there is already an event stored with primary key '" + primaryKey + "'");
            if (this.siddhiAppContext.getRuntimeExceptionListener() != null) {
                this.siddhiAppContext.getRuntimeExceptionListener().exceptionThrown(e);
            }
            log.error(e.getMessage(), (Throwable)e);
        }
        if (this.indexData != null) {
            for (Map.Entry<String, Integer> indexEntry : this.indexMetaData.entrySet()) {
                Object key;
                TreeMap<Object, Set<StreamEvent>> indexMap = this.indexData.get(indexEntry.getKey());
                Set<StreamEvent> values = indexMap.get(key = streamEvent.getOutputData()[indexEntry.getValue()]);
                if (values == null) {
                    values = new HashSet<StreamEvent>();
                    values.add(streamEvent);
                    indexMap.put(streamEvent.getOutputData()[indexEntry.getValue()], values);
                    continue;
                }
                values.add(streamEvent);
            }
        }
    }

    private Object constructPrimaryKey(StreamEvent streamEvent, PrimaryKeyReferenceHolder[] primaryKeyReferenceHolders) {
        if (primaryKeyReferenceHolders.length == 1) {
            return streamEvent.getOutputData()[primaryKeyReferenceHolders[0].getPrimaryKeyPosition()];
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (PrimaryKeyReferenceHolder primaryKeyReferenceHolder : primaryKeyReferenceHolders) {
            stringBuilder.append(streamEvent.getOutputData()[primaryKeyReferenceHolder.getPrimaryKeyPosition()]).append(":-:");
        }
        return stringBuilder.toString();
    }

    protected void handleCachePolicyAttributeUpdate(StreamEvent streamEvent) {
    }

    @Override
    public void overwrite(StreamEvent streamEvent) {
        Object primaryKey;
        if (this.isOperationLogEnabled) {
            if (!this.isFullSnapshot()) {
                StreamEvent streamEvent2 = this.tableStreamEventFactory.newInstance();
                this.eventConverter.convertComplexEvent(streamEvent, streamEvent2);
                this.operationChangeLog.add(new Operation(Operation.Operator.OVERWRITE, streamEvent2));
            } else {
                this.operationChangeLog.clear();
                this.forceFullSnapshot = true;
            }
        }
        StreamEvent deletedEvent = null;
        if (this.primaryKeyData != null && (deletedEvent = this.primaryKeyData.put(primaryKey = this.constructPrimaryKey(streamEvent, this.primaryKeyReferenceHolders), streamEvent)) != null) {
            this.handleCachePolicyAttributeUpdate(streamEvent);
        }
        if (this.indexData != null) {
            for (Map.Entry<String, Integer> indexEntry : this.indexMetaData.entrySet()) {
                Set<StreamEvent> values;
                TreeMap<Object, Set<StreamEvent>> indexMap = this.indexData.get(indexEntry.getKey());
                Object key = streamEvent.getOutputData()[indexEntry.getValue()];
                if (deletedEvent != null) {
                    values = indexMap.get(key);
                    values.remove(deletedEvent);
                    if (values.size() == 0) {
                        indexMap.remove(key);
                    }
                }
                if ((values = indexMap.get(key)) == null) {
                    values = new HashSet<StreamEvent>();
                    values.add(streamEvent);
                    indexMap.put(streamEvent.getOutputData()[indexEntry.getValue()], values);
                    continue;
                }
                values.add(streamEvent);
            }
        }
    }

    @Override
    public Collection<StreamEvent> getAllEvents() {
        if (this.primaryKeyData != null) {
            return this.primaryKeyData.values();
        }
        if (this.indexData != null) {
            HashSet<StreamEvent> resultEventSet = new HashSet<StreamEvent>();
            Iterator<TreeMap<Object, Set<StreamEvent>>> iterator = this.indexData.values().iterator();
            if (iterator.hasNext()) {
                TreeMap<Object, Set<StreamEvent>> aIndexData = iterator.next();
                for (Set<StreamEvent> streamEvents : aIndexData.values()) {
                    resultEventSet.addAll(streamEvents);
                }
            }
            return resultEventSet;
        }
        return new HashSet<StreamEvent>();
    }

    public StreamEvent getEvent(Object key) {
        return this.primaryKeyData.get(key);
    }

    public void deleteEvent(Object key) {
        this.primaryKeyData.remove(key);
    }

    @Override
    public Collection<StreamEvent> findEvents(String attribute, Compare.Operator operator, Object value) {
        if (this.primaryKeyData != null && attribute.equals(this.primaryKeyAttributes)) {
            switch (operator) {
                case LESS_THAN: {
                    return ((TreeMap)this.primaryKeyData).headMap(value, false).values();
                }
                case GREATER_THAN: {
                    return ((TreeMap)this.primaryKeyData).tailMap(value, false).values();
                }
                case LESS_THAN_EQUAL: {
                    return ((TreeMap)this.primaryKeyData).headMap(value, true).values();
                }
                case GREATER_THAN_EQUAL: {
                    return ((TreeMap)this.primaryKeyData).tailMap(value, true).values();
                }
                case EQUAL: {
                    HashSet<StreamEvent> resultEventSet = new HashSet<StreamEvent>();
                    StreamEvent resultEvent = this.primaryKeyData.get(value);
                    if (resultEvent != null) {
                        resultEventSet.add(resultEvent);
                    }
                    return resultEventSet;
                }
                case NOT_EQUAL: {
                    if (this.primaryKeyData.size() <= 0) {
                        return new HashSet<StreamEvent>();
                    }
                    HashSet<StreamEvent> resultEventSet = new HashSet<StreamEvent>(this.primaryKeyData.values());
                    StreamEvent resultEvent = this.primaryKeyData.get(value);
                    if (resultEvent != null) {
                        resultEventSet.remove(resultEvent);
                    }
                    return resultEventSet;
                }
            }
        } else {
            HashSet<StreamEvent> resultEventSet = new HashSet<StreamEvent>();
            TreeMap<Object, Set<StreamEvent>> currentIndexedData = this.indexData.get(attribute);
            switch (operator) {
                case LESS_THAN: {
                    for (Set eventSet : currentIndexedData.headMap(value, false).values()) {
                        resultEventSet.addAll(eventSet);
                    }
                    return resultEventSet;
                }
                case GREATER_THAN: {
                    for (Set eventSet : currentIndexedData.tailMap(value, false).values()) {
                        resultEventSet.addAll(eventSet);
                    }
                    return resultEventSet;
                }
                case LESS_THAN_EQUAL: {
                    for (Set eventSet : currentIndexedData.headMap(value, true).values()) {
                        resultEventSet.addAll(eventSet);
                    }
                    return resultEventSet;
                }
                case GREATER_THAN_EQUAL: {
                    for (Set eventSet : currentIndexedData.tailMap(value, true).values()) {
                        resultEventSet.addAll(eventSet);
                    }
                    return resultEventSet;
                }
                case EQUAL: {
                    Set<StreamEvent> resultEvents = currentIndexedData.get(value);
                    if (resultEvents != null) {
                        resultEventSet.addAll(resultEvents);
                    }
                    return resultEventSet;
                }
                case NOT_EQUAL: {
                    Set<StreamEvent> resultEvents;
                    if (currentIndexedData.size() > 0) {
                        resultEventSet = new HashSet();
                        for (Set<StreamEvent> eventSet : currentIndexedData.values()) {
                            resultEventSet.addAll(eventSet);
                        }
                    } else {
                        resultEventSet = new HashSet();
                    }
                    if ((resultEvents = currentIndexedData.get(value)) != null) {
                        resultEventSet.removeAll(resultEvents);
                    }
                    return resultEventSet;
                }
            }
        }
        throw new OperationNotSupportedException(operator + " not supported for '" + value + "' by " + this.getClass().getName());
    }

    @Override
    public void deleteAll() {
        if (this.isOperationLogEnabled) {
            if (!this.isFullSnapshot()) {
                this.operationChangeLog.add(new Operation(Operation.Operator.CLEAR));
            } else {
                this.operationChangeLog.clear();
                this.forceFullSnapshot = true;
            }
        }
        if (this.primaryKeyData != null) {
            this.primaryKeyData.clear();
        }
        if (this.indexData != null) {
            for (TreeMap<Object, Set<StreamEvent>> aIndexedData : this.indexData.values()) {
                aIndexedData.clear();
            }
        }
    }

    @Override
    public void deleteAll(Collection<StreamEvent> storeEventSet) {
        for (StreamEvent streamEvent : storeEventSet) {
            if (this.isOperationLogEnabled) {
                if (!this.isFullSnapshot()) {
                    StreamEvent streamEvent2 = this.tableStreamEventFactory.newInstance();
                    this.eventConverter.convertComplexEvent(streamEvent, streamEvent2);
                    this.operationChangeLog.add(new Operation(Operation.Operator.REMOVE, streamEvent));
                } else {
                    this.operationChangeLog.clear();
                    this.forceFullSnapshot = true;
                }
            }
            this.deleteAll(streamEvent);
        }
    }

    private void deleteAll(StreamEvent streamEvent) {
        if (this.primaryKeyData != null) {
            Object primaryKey = this.constructPrimaryKey(streamEvent, this.primaryKeyReferenceHolders);
            StreamEvent deletedEvent = this.primaryKeyData.remove(primaryKey);
            if (this.indexData != null) {
                this.deleteFromIndexes(deletedEvent);
            }
        } else if (this.indexData != null) {
            this.deleteFromIndexes(streamEvent);
        }
    }

    @Override
    public void delete(String attribute, Compare.Operator operator, Object value) {
        if (this.isOperationLogEnabled) {
            if (!this.isFullSnapshot()) {
                this.operationChangeLog.add(new Operation(Operation.Operator.DELETE_BY_OPERATOR, new Object[]{attribute, operator, value}));
            } else {
                this.operationChangeLog.clear();
                this.forceFullSnapshot = true;
            }
        }
        if (this.primaryKeyData != null && attribute.equals(this.primaryKeyAttributes)) {
            switch (operator) {
                case LESS_THAN: {
                    Iterator iterator = ((TreeMap)this.primaryKeyData).headMap(value, false).values().iterator();
                    while (iterator.hasNext()) {
                        StreamEvent toDeleteEvent = (StreamEvent)iterator.next();
                        iterator.remove();
                        this.deleteFromIndexes(toDeleteEvent);
                    }
                    return;
                }
                case GREATER_THAN: {
                    Iterator iterator = ((TreeMap)this.primaryKeyData).tailMap(value, false).values().iterator();
                    while (iterator.hasNext()) {
                        StreamEvent toDeleteEvent = (StreamEvent)iterator.next();
                        iterator.remove();
                        this.deleteFromIndexes(toDeleteEvent);
                    }
                    return;
                }
                case LESS_THAN_EQUAL: {
                    Iterator iterator = ((TreeMap)this.primaryKeyData).headMap(value, true).values().iterator();
                    while (iterator.hasNext()) {
                        StreamEvent toDeleteEvent = (StreamEvent)iterator.next();
                        iterator.remove();
                        this.deleteFromIndexes(toDeleteEvent);
                    }
                    return;
                }
                case GREATER_THAN_EQUAL: {
                    Iterator iterator = ((TreeMap)this.primaryKeyData).tailMap(value, true).values().iterator();
                    while (iterator.hasNext()) {
                        StreamEvent toDeleteEvent = (StreamEvent)iterator.next();
                        iterator.remove();
                        this.deleteFromIndexes(toDeleteEvent);
                    }
                    return;
                }
                case EQUAL: {
                    StreamEvent deletedEvent = this.primaryKeyData.remove(value);
                    if (deletedEvent != null) {
                        this.deleteFromIndexes(deletedEvent);
                    }
                    return;
                }
                case NOT_EQUAL: {
                    StreamEvent streamEvent = this.primaryKeyData.get(value);
                    this.deleteAll();
                    if (streamEvent != null) {
                        this.add(streamEvent);
                    }
                    return;
                }
            }
        } else {
            switch (operator) {
                case LESS_THAN: {
                    Iterator iterator = this.indexData.get(attribute).headMap(value, false).values().iterator();
                    while (iterator.hasNext()) {
                        Set deletedEventSet = (Set)iterator.next();
                        this.deleteFromIndexesAndPrimaryKey(attribute, deletedEventSet);
                        iterator.remove();
                    }
                    return;
                }
                case GREATER_THAN: {
                    Iterator iterator = this.indexData.get(attribute).tailMap(value, false).values().iterator();
                    while (iterator.hasNext()) {
                        Set deletedEventSet = (Set)iterator.next();
                        this.deleteFromIndexesAndPrimaryKey(attribute, deletedEventSet);
                        iterator.remove();
                    }
                    return;
                }
                case LESS_THAN_EQUAL: {
                    Iterator iterator = this.indexData.get(attribute).headMap(value, true).values().iterator();
                    while (iterator.hasNext()) {
                        Set deletedEventSet = (Set)iterator.next();
                        this.deleteFromIndexesAndPrimaryKey(attribute, deletedEventSet);
                        iterator.remove();
                    }
                    return;
                }
                case GREATER_THAN_EQUAL: {
                    Iterator iterator = this.indexData.get(attribute).tailMap(value, true).values().iterator();
                    while (iterator.hasNext()) {
                        Set deletedEventSet = (Set)iterator.next();
                        this.deleteFromIndexesAndPrimaryKey(attribute, deletedEventSet);
                        iterator.remove();
                    }
                    return;
                }
                case EQUAL: {
                    Set<StreamEvent> deletedEventSet = this.indexData.get(attribute).remove(value);
                    if (deletedEventSet != null && deletedEventSet.size() > 0) {
                        this.deleteFromIndexesAndPrimaryKey(attribute, deletedEventSet);
                    }
                    return;
                }
                case NOT_EQUAL: {
                    Set<StreamEvent> matchingEventSet = this.indexData.get(attribute).get(value);
                    this.deleteAll();
                    for (StreamEvent matchingEvent : matchingEventSet) {
                        this.add(matchingEvent);
                    }
                    return;
                }
            }
        }
        throw new OperationNotSupportedException(operator + " not supported for '" + value + "' by " + this.getClass().getName());
    }

    @Override
    public boolean containsEventSet(String attribute, Compare.Operator operator, Object value) {
        if (this.primaryKeyData != null && attribute.equals(this.primaryKeyAttributes)) {
            switch (operator) {
                case LESS_THAN: {
                    return ((TreeMap)this.primaryKeyData).lowerKey(value) != null;
                }
                case GREATER_THAN: {
                    return ((TreeMap)this.primaryKeyData).higherKey(value) != null;
                }
                case LESS_THAN_EQUAL: {
                    return ((TreeMap)this.primaryKeyData).ceilingKey(value) != null;
                }
                case GREATER_THAN_EQUAL: {
                    return ((TreeMap)this.primaryKeyData).floorKey(value) != null;
                }
                case EQUAL: {
                    return this.primaryKeyData.get(value) != null;
                }
                case NOT_EQUAL: {
                    return this.primaryKeyData.size() > 1;
                }
            }
        } else {
            TreeMap<Object, Set<StreamEvent>> currentIndexedData = this.indexData.get(attribute);
            switch (operator) {
                case LESS_THAN: {
                    return currentIndexedData.lowerKey(value) != null;
                }
                case GREATER_THAN: {
                    return currentIndexedData.higherKey(value) != null;
                }
                case LESS_THAN_EQUAL: {
                    return currentIndexedData.ceilingKey(value) != null;
                }
                case GREATER_THAN_EQUAL: {
                    return currentIndexedData.floorKey(value) != null;
                }
                case EQUAL: {
                    return currentIndexedData.get(value) != null;
                }
                case NOT_EQUAL: {
                    return currentIndexedData.size() > 1;
                }
            }
        }
        throw new OperationNotSupportedException(operator + " not supported for '" + value + "' by " + this.getClass().getName());
    }

    private void deleteFromIndexesAndPrimaryKey(String currentAttribute, Set<StreamEvent> deletedEventSet) {
        for (StreamEvent deletedEvent : deletedEventSet) {
            if (this.primaryKeyData != null) {
                Object primaryKey = this.constructPrimaryKey(deletedEvent, this.primaryKeyReferenceHolders);
                this.primaryKeyData.remove(primaryKey);
            }
            for (Map.Entry<String, Integer> indexEntry : this.indexMetaData.entrySet()) {
                Object key;
                TreeMap<Object, Set<StreamEvent>> indexMap;
                Set<StreamEvent> values;
                if (currentAttribute.equals(indexEntry.getKey()) || (values = (indexMap = this.indexData.get(indexEntry.getKey())).get(key = deletedEvent.getOutputData()[indexEntry.getValue()])) == null) continue;
                values.remove(deletedEvent);
                if (values.size() != 0) continue;
                indexMap.remove(key);
            }
        }
    }

    private void deleteFromIndexes(StreamEvent toDeleteEvent) {
        if (this.indexMetaData != null) {
            for (Map.Entry<String, Integer> indexEntry : this.indexMetaData.entrySet()) {
                Object key;
                TreeMap<Object, Set<StreamEvent>> indexMap = this.indexData.get(indexEntry.getKey());
                Set<StreamEvent> values = indexMap.get(key = toDeleteEvent.getOutputData()[indexEntry.getValue()]);
                if (values == null) continue;
                values.remove(toDeleteEvent);
                if (values.size() != 0) continue;
                indexMap.remove(key);
            }
        }
    }

    private boolean isFullSnapshot() {
        return (float)this.operationChangeLog.size() > (float)this.eventsCount * 2.1f || this.forceFullSnapshot || SnapshotRequest.isRequestForFullSnapshot();
    }

    @Override
    public Snapshot getSnapshot() {
        if (this.isFullSnapshot()) {
            this.forceFullSnapshot = false;
            return new Snapshot(this, false);
        }
        Snapshot snapshot = new Snapshot(this.operationChangeLog, true);
        this.operationChangeLog = new ArrayList();
        return snapshot;
    }

    @Override
    public void restore(SnapshotStateList snapshotStatelist) {
        TreeMap<Long, Snapshot> revisions = snapshotStatelist.getSnapshotStates();
        Iterator<Map.Entry<Long, Snapshot>> itr = revisions.entrySet().iterator();
        this.isOperationLogEnabled = false;
        while (itr.hasNext()) {
            Map.Entry<Long, Snapshot> snapshotEntry = itr.next();
            if (!snapshotEntry.getValue().isIncrementalSnapshot()) {
                this.deleteAll();
                IndexEventHolder snapshotEventHolder = (IndexEventHolder)snapshotEntry.getValue().getState();
                if (this.primaryKeyData != null) {
                    this.primaryKeyData.clear();
                    this.primaryKeyData.putAll(snapshotEventHolder.primaryKeyData);
                }
                if (this.indexData != null) {
                    this.indexData.clear();
                    this.indexData.putAll(snapshotEventHolder.indexData);
                }
                this.forceFullSnapshot = false;
                continue;
            }
            ArrayList operations = (ArrayList)snapshotEntry.getValue().getState();
            block8: for (Operation op : operations) {
                switch (op.operation) {
                    case ADD: {
                        this.add((StreamEvent)op.parameters);
                        continue block8;
                    }
                    case REMOVE: {
                        this.deleteAll((StreamEvent)op.parameters);
                        continue block8;
                    }
                    case CLEAR: {
                        this.deleteAll();
                        continue block8;
                    }
                    case OVERWRITE: {
                        this.overwrite((StreamEvent)op.parameters);
                        continue block8;
                    }
                    case DELETE_BY_OPERATOR: {
                        Object[] args = (Object[])op.parameters;
                        this.delete((String)args[0], (Compare.Operator)args[1], args[2]);
                        continue block8;
                    }
                }
            }
        }
        this.isOperationLogEnabled = true;
    }

    @Override
    public int size() {
        return this.primaryKeyData.size();
    }
}

