/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.parser;

import io.siddhi.core.aggregation.AggregationRuntime;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiOnDemandQueryContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.state.StateEventFactory;
import io.siddhi.core.event.state.populater.StateEventPopulatorFactory;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.populater.SelectiveComplexEventPopulater;
import io.siddhi.core.event.stream.populater.StreamEventPopulaterFactory;
import io.siddhi.core.exception.OnDemandQueryCreationException;
import io.siddhi.core.exception.QueryableRecordTableException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.DeleteOnDemandQueryRuntime;
import io.siddhi.core.query.FindOnDemandQueryRuntime;
import io.siddhi.core.query.InsertOnDemandQueryRuntime;
import io.siddhi.core.query.OnDemandQueryRuntime;
import io.siddhi.core.query.SelectOnDemandQueryRuntime;
import io.siddhi.core.query.UpdateOnDemandQueryRuntime;
import io.siddhi.core.query.UpdateOrInsertOnDemandQueryRuntime;
import io.siddhi.core.query.output.callback.OutputCallback;
import io.siddhi.core.query.output.ratelimit.PassThroughOutputRateLimiter;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.stream.window.QueryableProcessor;
import io.siddhi.core.query.selector.QuerySelector;
import io.siddhi.core.table.Table;
import io.siddhi.core.table.record.AbstractQueryableRecordTable;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.CompiledSelection;
import io.siddhi.core.util.collection.operator.IncrementalAggregateCompileCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.lock.LockWrapper;
import io.siddhi.core.util.parser.OutputParser;
import io.siddhi.core.util.parser.SelectorParser;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.core.util.snapshot.SnapshotService;
import io.siddhi.core.window.Window;
import io.siddhi.query.api.aggregation.Within;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import io.siddhi.query.api.execution.query.OnDemandQuery;
import io.siddhi.query.api.execution.query.input.store.AggregationInputStore;
import io.siddhi.query.api.execution.query.input.store.ConditionInputStore;
import io.siddhi.query.api.execution.query.input.store.InputStore;
import io.siddhi.query.api.execution.query.output.stream.DeleteStream;
import io.siddhi.query.api.execution.query.output.stream.InsertIntoStream;
import io.siddhi.query.api.execution.query.output.stream.OutputStream;
import io.siddhi.query.api.execution.query.output.stream.ReturnStream;
import io.siddhi.query.api.execution.query.output.stream.UpdateOrInsertStream;
import io.siddhi.query.api.execution.query.output.stream.UpdateStream;
import io.siddhi.query.api.execution.query.selection.Selector;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.constant.BoolConstant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OnDemandQueryParser {
    private static final Logger log = LogManager.getLogger(OnDemandQueryParser.class);

    public static OnDemandQueryRuntime parse(OnDemandQuery onDemandQuery, String onDemandQueryString, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, Map<String, Window> windowMap, Map<String, AggregationRuntime> aggregationMap) {
        LockWrapper lockWrapper = new LockWrapper("OnDemandQueryLock");
        lockWrapper.setLock(new ReentrantLock());
        MetaStreamEvent metaStreamEvent = new MetaStreamEvent();
        int metaPosition = -1;
        SnapshotService.getSkipStateStorageThreadLocal().set(true);
        switch (onDemandQuery.getType()) {
            case FIND: {
                Within within = null;
                Expression per = null;
                String queryName = "store_select_query_" + onDemandQuery.getInputStore().getStoreId();
                SiddhiOnDemandQueryContext siddhiQueryContext = new SiddhiOnDemandQueryContext(siddhiAppContext, queryName, onDemandQueryString);
                InputStore inputStore = onDemandQuery.getInputStore();
                try {
                    BoolConstant onCondition = Expression.value((boolean)true);
                    metaStreamEvent.setInputReferenceId(inputStore.getStoreReferenceId());
                    if (inputStore instanceof AggregationInputStore) {
                        AggregationInputStore aggregationInputStore = (AggregationInputStore)inputStore;
                        if (aggregationMap.get(inputStore.getStoreId()) == null) {
                            throw new OnDemandQueryCreationException("Aggregation \"" + inputStore.getStoreId() + "\" has not been defined");
                        }
                        if (aggregationInputStore.getPer() != null && aggregationInputStore.getWithin() != null) {
                            within = aggregationInputStore.getWithin();
                            per = aggregationInputStore.getPer();
                        } else if (aggregationInputStore.getPer() != null || aggregationInputStore.getWithin() != null) {
                            throw new OnDemandQueryCreationException(inputStore.getStoreId() + " should either have both 'within' and 'per' defined or none.");
                        }
                        if (((AggregationInputStore)inputStore).getOnCondition() != null) {
                            onCondition = ((AggregationInputStore)inputStore).getOnCondition();
                        }
                    } else if (inputStore instanceof ConditionInputStore && ((ConditionInputStore)inputStore).getOnCondition() != null) {
                        onCondition = ((ConditionInputStore)inputStore).getOnCondition();
                    }
                    ArrayList<VariableExpressionExecutor> variableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
                    Table table = tableMap.get(inputStore.getStoreId());
                    if (table != null) {
                        OnDemandQueryRuntime onDemandQueryRuntime = OnDemandQueryParser.constructOnDemandQueryRuntime(table, onDemandQuery, tableMap, windowMap, metaPosition, (Expression)onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper, (SiddhiQueryContext)siddhiQueryContext);
                        return onDemandQueryRuntime;
                    }
                    AggregationRuntime aggregation = aggregationMap.get(inputStore.getStoreId());
                    if (aggregation != null) {
                        OnDemandQueryRuntime onDemandQueryRuntime = OnDemandQueryParser.constructOnDemandQueryRuntime(aggregation, onDemandQuery, tableMap, windowMap, within, per, (Expression)onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper, siddhiQueryContext);
                        return onDemandQueryRuntime;
                    }
                    Window window = windowMap.get(inputStore.getStoreId());
                    if (window != null) {
                        OnDemandQueryRuntime onDemandQueryRuntime = OnDemandQueryParser.constructOnDemandQueryRuntime(window, onDemandQuery, tableMap, windowMap, metaPosition, (Expression)onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper, (SiddhiQueryContext)siddhiQueryContext);
                        return onDemandQueryRuntime;
                    }
                    throw new OnDemandQueryCreationException(inputStore.getStoreId() + " is neither a table, aggregation or window");
                }
                finally {
                    SnapshotService.getSkipStateStorageThreadLocal().set(null);
                }
            }
            case INSERT: {
                InsertIntoStream inserIntoStreamt = (InsertIntoStream)onDemandQuery.getOutputStream();
                String queryName = "store_insert_query_" + inserIntoStreamt.getId();
                SiddhiOnDemandQueryContext siddhiQueryContext = new SiddhiOnDemandQueryContext(siddhiAppContext, queryName, onDemandQueryString);
                BoolConstant onCondition = Expression.value((boolean)true);
                return OnDemandQueryParser.getOnDemandQueryRuntime(onDemandQuery, tableMap, windowMap, metaPosition, lockWrapper, metaStreamEvent, (OutputStream)inserIntoStreamt, (Expression)onCondition, siddhiQueryContext);
            }
            case DELETE: {
                DeleteStream deleteStream = (DeleteStream)onDemandQuery.getOutputStream();
                String queryName = "store_delete_query_" + deleteStream.getId();
                SiddhiOnDemandQueryContext siddhiQueryContext = new SiddhiOnDemandQueryContext(siddhiAppContext, queryName, onDemandQueryString);
                Expression onCondition = deleteStream.getOnDeleteExpression();
                return OnDemandQueryParser.getOnDemandQueryRuntime(onDemandQuery, tableMap, windowMap, metaPosition, lockWrapper, metaStreamEvent, (OutputStream)deleteStream, onCondition, siddhiQueryContext);
            }
            case UPDATE: {
                UpdateStream outputStream = (UpdateStream)onDemandQuery.getOutputStream();
                String queryName = "store_update_query_" + outputStream.getId();
                SiddhiOnDemandQueryContext siddhiQueryContext = new SiddhiOnDemandQueryContext(siddhiAppContext, queryName, onDemandQueryString);
                Expression onCondition = outputStream.getOnUpdateExpression();
                return OnDemandQueryParser.getOnDemandQueryRuntime(onDemandQuery, tableMap, windowMap, metaPosition, lockWrapper, metaStreamEvent, (OutputStream)outputStream, onCondition, siddhiQueryContext);
            }
            case UPDATE_OR_INSERT: {
                UpdateOrInsertStream onDemandQueryOutputStream = (UpdateOrInsertStream)onDemandQuery.getOutputStream();
                String queryName = "store_update_or_insert_query_" + onDemandQueryOutputStream.getId();
                SiddhiOnDemandQueryContext siddhiQueryContext = new SiddhiOnDemandQueryContext(siddhiAppContext, queryName, onDemandQueryString);
                Expression onCondition = onDemandQueryOutputStream.getOnUpdateExpression();
                return OnDemandQueryParser.getOnDemandQueryRuntime(onDemandQuery, tableMap, windowMap, metaPosition, lockWrapper, metaStreamEvent, (OutputStream)onDemandQueryOutputStream, onCondition, siddhiQueryContext);
            }
        }
        return null;
    }

    private static OnDemandQueryRuntime getOnDemandQueryRuntime(OnDemandQuery onDemandQuery, Map<String, Table> tableMap, Map<String, Window> windowMap, int metaPosition, LockWrapper lockWrapper, MetaStreamEvent metaStreamEvent, OutputStream outputStream, Expression onCondition, SiddhiQueryContext siddhiQueryContext) {
        try {
            ArrayList<VariableExpressionExecutor> variableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
            Table table = tableMap.get(outputStream.getId());
            if (table != null) {
                OnDemandQueryRuntime onDemandQueryRuntime = OnDemandQueryParser.constructOnDemandQueryRuntime(table, onDemandQuery, tableMap, windowMap, metaPosition, onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper, siddhiQueryContext);
                return onDemandQueryRuntime;
            }
            throw new OnDemandQueryCreationException(outputStream.getId() + " is not a table.");
        }
        finally {
            SnapshotService.getSkipStateStorageThreadLocal().set(null);
        }
    }

    private static OnDemandQueryRuntime constructOnDemandQueryRuntime(Window window, OnDemandQuery onDemandQuery, Map<String, Table> tableMap, Map<String, Window> windowMap, int metaPosition, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors, LockWrapper lockWrapper, SiddhiQueryContext siddhiQueryContext) {
        metaStreamEvent.setEventType(MetaStreamEvent.EventType.WINDOW);
        OnDemandQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)window.getWindowDefinition());
        MatchingMetaInfoHolder metaStreamInfoHolder = OnDemandQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)window.getWindowDefinition());
        CompiledCondition compiledCondition = window.compileCondition(onCondition, OnDemandQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)window.getWindowDefinition()), variableExpressionExecutors, tableMap, siddhiQueryContext);
        FindOnDemandQueryRuntime findOnDemandQueryRuntime = new FindOnDemandQueryRuntime(window, compiledCondition, siddhiQueryContext.getName(), metaStreamEvent);
        OnDemandQueryParser.populateFindOnDemandQueryRuntime(findOnDemandQueryRuntime, metaStreamInfoHolder, onDemandQuery.getSelector(), variableExpressionExecutors, tableMap, windowMap, metaPosition, !onDemandQuery.getSelector().getGroupByList().isEmpty(), lockWrapper, siddhiQueryContext);
        return findOnDemandQueryRuntime;
    }

    private static OnDemandQueryRuntime constructOnDemandQueryRuntime(AggregationRuntime aggregation, OnDemandQuery onDemandQuery, Map<String, Table> tableMap, Map<String, Window> windowMap, Within within, Expression per, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors, LockWrapper lockWrapper, SiddhiQueryContext siddhiQueryContext) {
        metaStreamEvent.setEventType(MetaStreamEvent.EventType.AGGREGATE);
        OnDemandQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)aggregation.getAggregationDefinition());
        MatchingMetaInfoHolder metaStreamInfoHolder = OnDemandQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)aggregation.getAggregationDefinition());
        CompiledCondition compiledCondition = aggregation.compileExpression(onCondition, within, per, onDemandQuery.getSelector().getGroupByList(), metaStreamInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
        ((IncrementalAggregateCompileCondition)compiledCondition).init();
        metaStreamInfoHolder = ((IncrementalAggregateCompileCondition)compiledCondition).getAlteredMatchingMetaInfoHolder();
        FindOnDemandQueryRuntime findOnDemandQueryRuntime = new FindOnDemandQueryRuntime(aggregation, compiledCondition, siddhiQueryContext.getName(), metaStreamEvent, siddhiQueryContext);
        int metaPosition = 1;
        OnDemandQueryParser.populateFindOnDemandQueryRuntime(findOnDemandQueryRuntime, metaStreamInfoHolder, onDemandQuery.getSelector(), variableExpressionExecutors, tableMap, windowMap, metaPosition, !onDemandQuery.getSelector().getGroupByList().isEmpty(), lockWrapper, siddhiQueryContext);
        SelectiveComplexEventPopulater complexEventPopulater = StreamEventPopulaterFactory.constructEventPopulator(metaStreamInfoHolder.getMetaStateEvent().getMetaStreamEvent(0), 0, ((IncrementalAggregateCompileCondition)compiledCondition).getAdditionalAttributes());
        ((IncrementalAggregateCompileCondition)compiledCondition).setComplexEventPopulater(complexEventPopulater);
        return findOnDemandQueryRuntime;
    }

    private static OnDemandQueryRuntime constructOnDemandQueryRuntime(Table table, OnDemandQuery onDemandQuery, Map<String, Table> tableMap, Map<String, Window> windowMap, int metaPosition, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors, LockWrapper lockWrapper, SiddhiQueryContext siddhiQueryContext) {
        metaStreamEvent.setEventType(MetaStreamEvent.EventType.TABLE);
        if (table instanceof QueryableProcessor && onDemandQuery.getType() == OnDemandQuery.OnDemandQueryType.FIND) {
            try {
                return OnDemandQueryParser.constructOptimizedOnDemandQueryRuntime(table, onDemandQuery, tableMap, metaPosition, onCondition, metaStreamEvent, variableExpressionExecutors, siddhiQueryContext);
            }
            catch (QueryableRecordTableException | SiddhiAppCreationException | SiddhiAppValidationException e) {
                if (log.isDebugEnabled()) {
                    log.debug("On-demand query optimization failed for table: " + table.getTableDefinition().getId() + ". Creating On-demand query runtime in normal mode. Reason for failure: " + e.getMessage());
                }
                return OnDemandQueryParser.constructRegularOnDemandQueryRuntime(table, onDemandQuery, tableMap, windowMap, metaPosition, onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper, siddhiQueryContext);
            }
        }
        return OnDemandQueryParser.constructRegularOnDemandQueryRuntime(table, onDemandQuery, tableMap, windowMap, metaPosition, onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper, siddhiQueryContext);
    }

    private static OnDemandQueryRuntime constructOptimizedOnDemandQueryRuntime(Table table, OnDemandQuery onDemandQuery, Map<String, Table> tableMap, int metaPosition, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors, SiddhiQueryContext siddhiQueryContext) {
        OnDemandQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
        MatchingMetaInfoHolder matchingMetaInfoHolder = OnDemandQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
        CompiledCondition compiledCondition = table.compileCondition(onCondition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
        List<Attribute> expectedOutputAttributes = OnDemandQueryParser.buildExpectedOutputAttributes(onDemandQuery, tableMap, metaPosition, matchingMetaInfoHolder, siddhiQueryContext);
        CompiledSelection compiledSelection = ((QueryableProcessor)((Object)table)).compileSelection(onDemandQuery.getSelector(), expectedOutputAttributes, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
        SelectOnDemandQueryRuntime onDemandQueryRuntime = new SelectOnDemandQueryRuntime((QueryableProcessor)((Object)table), compiledCondition, compiledSelection, expectedOutputAttributes, siddhiQueryContext.getName());
        try {
            AbstractQueryableRecordTable.CompiledSelectionWithCache compiledSelectionWithCache = (AbstractQueryableRecordTable.CompiledSelectionWithCache)compiledSelection;
            onDemandQueryRuntime.setSelector(compiledSelectionWithCache.getQuerySelector());
            onDemandQueryRuntime.setMetaStreamEvent(metaStreamEvent);
            onDemandQueryRuntime.setStateEventFactory(new StateEventFactory(matchingMetaInfoHolder.getMetaStateEvent()));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        QueryParserHelper.reduceMetaComplexEvent(matchingMetaInfoHolder.getMetaStateEvent());
        QueryParserHelper.updateVariablePosition(matchingMetaInfoHolder.getMetaStateEvent(), variableExpressionExecutors);
        return onDemandQueryRuntime;
    }

    private static OnDemandQueryRuntime constructRegularOnDemandQueryRuntime(Table table, OnDemandQuery onDemandQuery, Map<String, Table> tableMap, Map<String, Window> windowMap, int metaPosition, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors, LockWrapper lockWrapper, SiddhiQueryContext siddhiQueryContext) {
        switch (onDemandQuery.getType()) {
            case FIND: {
                OnDemandQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
                MatchingMetaInfoHolder matchingMetaInfoHolder = OnDemandQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
                CompiledCondition compiledCondition = table.compileCondition(onCondition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
                FindOnDemandQueryRuntime findOnDemandQueryRuntime = new FindOnDemandQueryRuntime(table, compiledCondition, siddhiQueryContext.getName(), metaStreamEvent);
                OnDemandQueryParser.populateFindOnDemandQueryRuntime(findOnDemandQueryRuntime, matchingMetaInfoHolder, onDemandQuery.getSelector(), variableExpressionExecutors, tableMap, windowMap, metaPosition, !onDemandQuery.getSelector().getGroupByList().isEmpty(), lockWrapper, siddhiQueryContext);
                return findOnDemandQueryRuntime;
            }
            case INSERT: {
                OnDemandQueryParser.initMetaStreamEvent(metaStreamEvent, OnDemandQueryParser.getInputDefinition(onDemandQuery, table));
                MatchingMetaInfoHolder matchingMetaInfoHolder = OnDemandQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
                QuerySelector querySelector = OnDemandQueryParser.getQuerySelector(matchingMetaInfoHolder, variableExpressionExecutors, tableMap, windowMap, metaPosition, onDemandQuery, lockWrapper, siddhiQueryContext);
                InsertOnDemandQueryRuntime insertOnDemandQueryRuntime = new InsertOnDemandQueryRuntime(siddhiQueryContext.getName(), metaStreamEvent);
                insertOnDemandQueryRuntime.setStateEventFactory(new StateEventFactory(matchingMetaInfoHolder.getMetaStateEvent()));
                insertOnDemandQueryRuntime.setSelector(querySelector);
                insertOnDemandQueryRuntime.setOutputAttributes(matchingMetaInfoHolder.getMetaStateEvent().getOutputStreamDefinition().getAttributeList());
                return insertOnDemandQueryRuntime;
            }
            case DELETE: {
                AbstractDefinition inputDefinition = OnDemandQueryParser.getInputDefinition(onDemandQuery, table);
                OnDemandQueryParser.initMetaStreamEvent(metaStreamEvent, inputDefinition);
                MatchingMetaInfoHolder matchingMetaInfoHolder = OnDemandQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, inputDefinition, (AbstractDefinition)table.getTableDefinition());
                QuerySelector querySelector = OnDemandQueryParser.getQuerySelector(matchingMetaInfoHolder, variableExpressionExecutors, tableMap, windowMap, metaPosition, onDemandQuery, lockWrapper, siddhiQueryContext);
                DeleteOnDemandQueryRuntime deleteOnDemandQueryRuntime = new DeleteOnDemandQueryRuntime(siddhiQueryContext.getName(), metaStreamEvent);
                deleteOnDemandQueryRuntime.setStateEventFactory(new StateEventFactory(matchingMetaInfoHolder.getMetaStateEvent()));
                deleteOnDemandQueryRuntime.setSelector(querySelector);
                deleteOnDemandQueryRuntime.setOutputAttributes(matchingMetaInfoHolder.getMetaStateEvent().getOutputStreamDefinition().getAttributeList());
                return deleteOnDemandQueryRuntime;
            }
            case UPDATE: {
                AbstractDefinition inputDefinition = OnDemandQueryParser.getInputDefinition(onDemandQuery, table);
                OnDemandQueryParser.initMetaStreamEvent(metaStreamEvent, inputDefinition);
                MatchingMetaInfoHolder matchingMetaInfoHolder = OnDemandQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, inputDefinition, (AbstractDefinition)table.getTableDefinition());
                QuerySelector querySelector = OnDemandQueryParser.getQuerySelector(matchingMetaInfoHolder, variableExpressionExecutors, tableMap, windowMap, metaPosition, onDemandQuery, lockWrapper, siddhiQueryContext);
                UpdateOnDemandQueryRuntime updateOnDemandQueryRuntime = new UpdateOnDemandQueryRuntime(siddhiQueryContext.getName(), metaStreamEvent);
                updateOnDemandQueryRuntime.setStateEventFactory(new StateEventFactory(matchingMetaInfoHolder.getMetaStateEvent()));
                updateOnDemandQueryRuntime.setSelector(querySelector);
                updateOnDemandQueryRuntime.setOutputAttributes(matchingMetaInfoHolder.getMetaStateEvent().getOutputStreamDefinition().getAttributeList());
                return updateOnDemandQueryRuntime;
            }
            case UPDATE_OR_INSERT: {
                AbstractDefinition inputDefinition = OnDemandQueryParser.getInputDefinition(onDemandQuery, table);
                OnDemandQueryParser.initMetaStreamEvent(metaStreamEvent, inputDefinition);
                MatchingMetaInfoHolder matchingMetaInfoHolder = OnDemandQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, inputDefinition, (AbstractDefinition)table.getTableDefinition());
                QuerySelector querySelector = OnDemandQueryParser.getQuerySelector(matchingMetaInfoHolder, variableExpressionExecutors, tableMap, windowMap, metaPosition, onDemandQuery, lockWrapper, siddhiQueryContext);
                UpdateOrInsertOnDemandQueryRuntime updateOrInsertIntoOnDemandQueryRuntime = new UpdateOrInsertOnDemandQueryRuntime(siddhiQueryContext.getName(), metaStreamEvent);
                updateOrInsertIntoOnDemandQueryRuntime.setStateEventFactory(new StateEventFactory(matchingMetaInfoHolder.getMetaStateEvent()));
                updateOrInsertIntoOnDemandQueryRuntime.setSelector(querySelector);
                updateOrInsertIntoOnDemandQueryRuntime.setOutputAttributes(matchingMetaInfoHolder.getMetaStateEvent().getOutputStreamDefinition().getAttributeList());
                return updateOrInsertIntoOnDemandQueryRuntime;
            }
        }
        return null;
    }

    public static List<Attribute> buildExpectedOutputAttributes(OnDemandQuery onDemandQuery, Map<String, Table> tableMap, int metaPosition, MatchingMetaInfoHolder metaStreamInfoHolder, SiddhiQueryContext siddhiQueryContext) {
        MetaStateEvent selectMetaStateEvent = new MetaStateEvent(metaStreamInfoHolder.getMetaStateEvent().getMetaStreamEvents());
        SelectorParser.parse(onDemandQuery.getSelector(), (OutputStream)new ReturnStream(OutputStream.OutputEventType.CURRENT_EVENTS), selectMetaStateEvent, tableMap, new ArrayList<VariableExpressionExecutor>(), metaPosition, ProcessingMode.BATCH, false, siddhiQueryContext);
        return selectMetaStateEvent.getOutputStreamDefinition().getAttributeList();
    }

    private static void populateFindOnDemandQueryRuntime(FindOnDemandQueryRuntime findOnDemandQueryRuntime, MatchingMetaInfoHolder metaStreamInfoHolder, Selector selector, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, Map<String, Window> windowMap, int metaPosition, boolean groupBy, LockWrapper lockWrapper, SiddhiQueryContext siddhiQueryContext) {
        ReturnStream returnStream = new ReturnStream(OutputStream.OutputEventType.CURRENT_EVENTS);
        QuerySelector querySelector = SelectorParser.parse(selector, (OutputStream)returnStream, metaStreamInfoHolder.getMetaStateEvent(), tableMap, variableExpressionExecutors, metaPosition, ProcessingMode.BATCH, false, siddhiQueryContext);
        PassThroughOutputRateLimiter rateLimiter = new PassThroughOutputRateLimiter(siddhiQueryContext.getName());
        rateLimiter.init(lockWrapper, groupBy, siddhiQueryContext);
        OutputCallback outputCallback = OutputParser.constructOutputCallback((OutputStream)returnStream, metaStreamInfoHolder.getMetaStateEvent().getOutputStreamDefinition(), tableMap, windowMap, true, siddhiQueryContext);
        rateLimiter.setOutputCallback(outputCallback);
        querySelector.setNextProcessor(rateLimiter);
        QueryParserHelper.reduceMetaComplexEvent(metaStreamInfoHolder.getMetaStateEvent());
        QueryParserHelper.updateVariablePosition(metaStreamInfoHolder.getMetaStateEvent(), variableExpressionExecutors);
        querySelector.setEventPopulator(StateEventPopulatorFactory.constructEventPopulator(metaStreamInfoHolder.getMetaStateEvent()));
        findOnDemandQueryRuntime.setStateEventFactory(new StateEventFactory(metaStreamInfoHolder.getMetaStateEvent()));
        findOnDemandQueryRuntime.setSelector(querySelector);
        findOnDemandQueryRuntime.setOutputAttributes(metaStreamInfoHolder.getMetaStateEvent().getOutputStreamDefinition().getAttributeList());
    }

    private static QuerySelector getQuerySelector(MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, Map<String, Window> windowMap, int metaPosition, OnDemandQuery onDemandQuery, LockWrapper lockWrapper, SiddhiQueryContext siddhiQueryContext) {
        QuerySelector querySelector = SelectorParser.parse(onDemandQuery.getSelector(), onDemandQuery.getOutputStream(), matchingMetaInfoHolder.getMetaStateEvent(), tableMap, variableExpressionExecutors, metaPosition, ProcessingMode.BATCH, false, siddhiQueryContext);
        PassThroughOutputRateLimiter rateLimiter = new PassThroughOutputRateLimiter(siddhiQueryContext.getName());
        rateLimiter.init(lockWrapper, !onDemandQuery.getSelector().getGroupByList().isEmpty(), siddhiQueryContext);
        OutputCallback outputCallback = OutputParser.constructOutputCallback(onDemandQuery.getOutputStream(), matchingMetaInfoHolder.getMetaStateEvent().getOutputStreamDefinition(), tableMap, windowMap, true, siddhiQueryContext);
        rateLimiter.setOutputCallback(outputCallback);
        querySelector.setNextProcessor(rateLimiter);
        QueryParserHelper.reduceMetaComplexEvent(matchingMetaInfoHolder.getMetaStateEvent());
        QueryParserHelper.updateVariablePosition(matchingMetaInfoHolder.getMetaStateEvent(), variableExpressionExecutors);
        querySelector.setEventPopulator(StateEventPopulatorFactory.constructEventPopulator(matchingMetaInfoHolder.getMetaStateEvent()));
        return querySelector;
    }

    private static MatchingMetaInfoHolder generateMatchingMetaInfoHolder(MetaStreamEvent metaStreamEvent, AbstractDefinition definition) {
        MetaStateEvent metaStateEvent = new MetaStateEvent(1);
        metaStateEvent.addEvent(metaStreamEvent);
        return new MatchingMetaInfoHolder(metaStateEvent, -1, 0, definition, definition, 0);
    }

    private static AbstractDefinition generateTableDefinitionFromOnDemandQuery(OnDemandQuery onDemandQuery, List<Attribute> expectedOutputAttributes) {
        TableDefinition tableDefinition = TableDefinition.id((String)onDemandQuery.getInputStore().getStoreId());
        for (Attribute attribute : expectedOutputAttributes) {
            tableDefinition.attribute(attribute.getName(), attribute.getType());
        }
        return tableDefinition;
    }

    private static MatchingMetaInfoHolder generateMatchingMetaInfoHolder(MetaStreamEvent metaStreamEvent, AbstractDefinition streamDefinition, AbstractDefinition storeDefinition) {
        MetaStateEvent metaStateEvent = new MetaStateEvent(1);
        metaStateEvent.addEvent(metaStreamEvent);
        return new MatchingMetaInfoHolder(metaStateEvent, -1, 0, streamDefinition, storeDefinition, 0);
    }

    public static MatchingMetaInfoHolder generateMatchingMetaInfoHolderForCacheTable(TableDefinition tableDefinition) {
        MetaStateEvent metaStateEvent = new MetaStateEvent(1);
        MetaStreamEvent metaStreamEvent = new MetaStreamEvent();
        OnDemandQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)tableDefinition);
        metaStateEvent.addEvent(metaStreamEvent);
        MatchingMetaInfoHolder matchingMetaInfoHolder = new MatchingMetaInfoHolder(metaStateEvent, -1, 0, (AbstractDefinition)tableDefinition, (AbstractDefinition)tableDefinition, 0);
        return matchingMetaInfoHolder;
    }

    private static void initMetaStreamEvent(MetaStreamEvent metaStreamEvent, AbstractDefinition inputDefinition) {
        metaStreamEvent.addInputDefinition(inputDefinition);
        metaStreamEvent.initializeOnAfterWindowData();
        inputDefinition.getAttributeList().forEach(metaStreamEvent::addData);
    }

    private static AbstractDefinition getInputDefinition(OnDemandQuery onDemandQuery, Table table) {
        if (onDemandQuery.getSelector().getSelectionList().isEmpty()) {
            return table.getTableDefinition();
        }
        StreamDefinition streamDefinition = new StreamDefinition();
        streamDefinition.setId(table.getTableDefinition().getId() + "InputStream");
        return streamDefinition;
    }
}

